/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.management.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.hornetq.api.core.management.Operation;
import org.hornetq.api.core.management.Parameter;

public class MBeanInfoHelper {
    public static MBeanOperationInfo[] getMBeanOperationsInfo(Class mbeanInterface) {
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        for (Method method : mbeanInterface.getMethods()) {
            if (MBeanInfoHelper.isGetterMethod(method) || MBeanInfoHelper.isSetterMethod(method) || MBeanInfoHelper.isIsBooleanMethod(method)) continue;
            operations.add(MBeanInfoHelper.getOperationInfo(method));
        }
        return operations.toArray(new MBeanOperationInfo[0]);
    }

    private static boolean isGetterMethod(Method method) {
        return !method.getName().equals("get") && method.getName().startsWith("get") && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE);
    }

    private static boolean isSetterMethod(Method method) {
        return !method.getName().equals("set") && method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType().equals(Void.TYPE);
    }

    private static boolean isIsBooleanMethod(Method method) {
        return !method.getName().equals("is") && method.getName().startsWith("is") && method.getParameterTypes().length == 0 && method.getReturnType().equals(Boolean.TYPE);
    }

    private static MBeanOperationInfo getOperationInfo(Method operation) {
        MBeanOperationInfo info = null;
        Class<?> returnType = operation.getReturnType();
        MBeanParameterInfo[] paramsInfo = MBeanInfoHelper.getParametersInfo(operation.getParameterAnnotations(), operation.getParameterTypes());
        String description = operation.getName();
        int impact = 3;
        if (operation.getAnnotation(Operation.class) != null) {
            description = operation.getAnnotation(Operation.class).desc();
            impact = operation.getAnnotation(Operation.class).impact();
        }
        info = new MBeanOperationInfo(operation.getName(), description, paramsInfo, returnType.getName(), impact);
        return info;
    }

    private static MBeanParameterInfo[] getParametersInfo(Annotation[][] params, Class<?>[] paramTypes) {
        MBeanParameterInfo[] paramsInfo = new MBeanParameterInfo[params.length];
        for (int i = 0; i < params.length; ++i) {
            MBeanParameterInfo paramInfo = null;
            String type = paramTypes[i].getName();
            for (Annotation anno : params[i]) {
                if (!Parameter.class.isInstance(anno)) continue;
                String name = ((Parameter)Parameter.class.cast(anno)).name();
                String description = ((Parameter)Parameter.class.cast(anno)).desc();
                paramInfo = new MBeanParameterInfo(name, type, description);
            }
            if (paramInfo == null) {
                paramInfo = new MBeanParameterInfo("p " + (i + 1), type, "parameter " + (i + 1));
            }
            paramsInfo[i] = paramInfo;
        }
        return paramsInfo;
    }
}

