/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import java.net.SocketAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hornetq.core.remoting.impl.netty.HttpKeepAliveRunnable;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.UpstreamMessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

class HttpAcceptorHandler
extends SimpleChannelHandler {
    private final BlockingQueue<ResponseHolder> responses = new LinkedBlockingQueue<ResponseHolder>();
    private final BlockingQueue<Runnable> delayedResponses = new LinkedBlockingQueue<Runnable>();
    private final ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, this.delayedResponses);
    private final HttpKeepAliveRunnable httpKeepAliveTask;
    private final long responseTime;
    private Channel channel;

    public HttpAcceptorHandler(HttpKeepAliveRunnable httpKeepAliveTask, long responseTime) {
        this.responseTime = responseTime;
        this.httpKeepAliveTask = httpKeepAliveTask;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelConnected(ctx, e);
        this.channel = e.getChannel();
        this.httpKeepAliveTask.registerKeepAliveHandler(this);
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelDisconnected(ctx, e);
        this.httpKeepAliveTask.unregisterKeepAliveHandler(this);
        this.channel = null;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        HttpRequest request = (HttpRequest)e.getMessage();
        HttpMethod method = request.getMethod();
        if (method.equals((Object)HttpMethod.POST)) {
            UpstreamMessageEvent event = new UpstreamMessageEvent(e.getChannel(), (Object)request.getContent(), e.getRemoteAddress());
            ctx.sendUpstream((ChannelEvent)event);
        }
        this.responses.put(new ResponseHolder(System.currentTimeMillis() + this.responseTime, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)));
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (e.getMessage() instanceof ChannelBuffer) {
            ChannelBuffer buf = (ChannelBuffer)e.getMessage();
            this.executor.execute(new ResponseRunner(buf));
        } else {
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)e.getMessage(), (SocketAddress)e.getRemoteAddress());
        }
    }

    public void keepAlive(long time) {
        int lateResponses = 0;
        for (ResponseHolder response : this.responses) {
            if (response.timeReceived >= time) break;
            ++lateResponses;
        }
        for (int i = 0; i < lateResponses; ++i) {
            this.executor.execute(new ResponseRunner());
        }
    }

    public void shutdown() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.executor.shutdownNow();
        }
    }

    private static final class ResponseHolder {
        final HttpResponse response;
        final long timeReceived;

        public ResponseHolder(long timeReceived, HttpResponse response) {
            this.timeReceived = timeReceived;
            this.response = response;
        }
    }

    final class ResponseRunner
    implements Runnable {
        private final ChannelBuffer buffer;
        private final boolean bogusResponse;

        public ResponseRunner(ChannelBuffer buffer) {
            this.buffer = buffer;
            this.bogusResponse = false;
        }

        public ResponseRunner() {
            this.bogusResponse = true;
            this.buffer = ChannelBuffers.buffer((int)0);
        }

        @Override
        public void run() {
            ResponseHolder responseHolder = null;
            do {
                try {
                    responseHolder = (ResponseHolder)HttpAcceptorHandler.this.responses.take();
                }
                catch (InterruptedException e) {
                    if (!HttpAcceptorHandler.this.executor.isShutdown()) continue;
                    return;
                }
            } while (responseHolder == null);
            if (!this.bogusResponse) {
                ChannelBuffer piggyBackBuffer = this.piggyBackResponses();
                responseHolder.response.setContent(piggyBackBuffer);
                responseHolder.response.addHeader("Content-Length", (Object)String.valueOf(piggyBackBuffer.writerIndex()));
                HttpAcceptorHandler.this.channel.write((Object)responseHolder.response);
            } else {
                responseHolder.response.setContent(this.buffer);
                responseHolder.response.addHeader("Content-Length", (Object)String.valueOf(this.buffer.writerIndex()));
                HttpAcceptorHandler.this.channel.write((Object)responseHolder.response);
            }
        }

        private ChannelBuffer piggyBackResponses() {
            if (HttpAcceptorHandler.this.responses.isEmpty()) {
                ChannelBuffer buf = ChannelBuffers.dynamicBuffer();
                buf.writeBytes(this.buffer);
                do {
                    try {
                        ResponseRunner responseRunner = (ResponseRunner)HttpAcceptorHandler.this.delayedResponses.poll(0L, TimeUnit.MILLISECONDS);
                        if (responseRunner == null) break;
                        buf.writeBytes(responseRunner.buffer);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                } while (HttpAcceptorHandler.this.responses.isEmpty());
                return buf;
            }
            return this.buffer;
        }
    }
}

