/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.proton;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointError;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.impl.ConnectionImpl;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.protocol.proton.ProtonDeliveryHandler;
import org.hornetq.core.protocol.proton.ProtonProtocolManager;
import org.hornetq.core.protocol.proton.ProtonSession;
import org.hornetq.core.protocol.proton.exceptions.HornetQAMQPException;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Acceptor;

public class ProtonRemotingConnection
implements RemotingConnection {
    private TransportImpl protonTransport;
    private ConnectionImpl protonConnection;
    private final Map<Object, ProtonSession> sessions = new HashMap<Object, ProtonSession>();
    private final Object deliveryLock = new Object();
    private boolean destroyed = false;
    private String clientId;
    private final Acceptor acceptorUsed;
    private final long creationTime;
    private final org.hornetq.spi.core.remoting.Connection connection;
    private final ProtonProtocolManager protonProtocolManager;
    private final List<FailureListener> failureListeners = new CopyOnWriteArrayList<FailureListener>();
    private final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();
    private boolean initialised = false;
    private static final byte[] VERSION_HEADER = new byte[]{65, 77, 81, 80, 0, 1, 0, 0};
    private Sasl sasl;
    private String username;
    private String passcode;
    private boolean dataReceived;

    public ProtonRemotingConnection(Acceptor acceptorUsed, org.hornetq.spi.core.remoting.Connection connection, ProtonProtocolManager protonProtocolManager) {
        this.protonProtocolManager = protonProtocolManager;
        this.connection = connection;
        this.creationTime = System.currentTimeMillis();
        this.acceptorUsed = acceptorUsed;
        this.protonTransport = new TransportImpl();
        this.protonConnection = new ConnectionImpl();
        this.protonTransport.bind((Connection)this.protonConnection);
    }

    public Object getID() {
        return this.connection.getID();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getRemoteAddress() {
        return this.connection.getRemoteAddress();
    }

    public void addFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        this.failureListeners.add(listener);
    }

    public boolean removeFailureListener(FailureListener listener) {
        if (listener == null) {
            throw new IllegalStateException("FailureListener cannot be null");
        }
        return this.failureListeners.remove(listener);
    }

    public void addCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        this.closeListeners.add(listener);
    }

    public boolean removeCloseListener(CloseListener listener) {
        if (listener == null) {
            throw new IllegalStateException("CloseListener cannot be null");
        }
        return this.closeListeners.remove(listener);
    }

    public List<CloseListener> removeCloseListeners() {
        ArrayList<CloseListener> ret = new ArrayList<CloseListener>(this.closeListeners);
        this.closeListeners.clear();
        return ret;
    }

    public List<FailureListener> removeFailureListeners() {
        ArrayList<FailureListener> ret = new ArrayList<FailureListener>(this.failureListeners);
        this.failureListeners.clear();
        return ret;
    }

    public void setCloseListeners(List<CloseListener> listeners) {
        this.closeListeners.clear();
        this.closeListeners.addAll(listeners);
    }

    public void setFailureListeners(List<FailureListener> listeners) {
        this.failureListeners.clear();
        this.failureListeners.addAll(listeners);
    }

    public List<FailureListener> getFailureListeners() {
        return Collections.emptyList();
    }

    public HornetQBuffer createBuffer(int size) {
        return this.connection.createBuffer(size);
    }

    public void fail(HornetQException me) {
        HornetQServerLogger.LOGGER.connectionFailureDetected(me.getMessage(), me.getType());
        this.callFailureListeners(me);
        this.callClosingListeners();
        this.destroyed = true;
        this.connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.destroyed = true;
        this.connection.close();
        Object object = this.deliveryLock;
        synchronized (object) {
            this.callClosingListeners();
        }
    }

    public org.hornetq.spi.core.remoting.Connection getTransportConnection() {
        return this.connection;
    }

    public boolean isClient() {
        return false;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void disconnect(boolean criticalError) {
        this.destroy();
    }

    public boolean checkDataReceived() {
        boolean res = this.dataReceived;
        this.dataReceived = false;
        return res;
    }

    public void flush() {
    }

    public void bufferReceived(Object connectionID, HornetQBuffer buffer) {
        if (this.initialised) {
            this.protonProtocolManager.handleBuffer(this, buffer);
        } else {
            byte[] prot = new byte[4];
            buffer.readBytes(prot);
            String headerProt = new String(prot);
            this.checkProtocol(headerProt);
            byte protocolId = buffer.readByte();
            byte major = buffer.readByte();
            byte minor = buffer.readByte();
            byte revision = buffer.readByte();
            if (!this.checkVersion(major, minor, revision) || !this.checkProtocol(headerProt)) {
                this.protonTransport.close();
                this.protonConnection.close();
                this.write();
                this.destroy();
                return;
            }
            if (protocolId == 3) {
                this.sasl = this.protonTransport.sasl();
                this.sasl.setMechanisms(new String[]{"ANONYMOUS", "PLAIN"});
                this.sasl.server();
            }
            this.protonTransport.input(VERSION_HEADER, 0, VERSION_HEADER.length);
            this.write();
            this.initialised = true;
            if (buffer.capacity() > VERSION_HEADER.length) {
                this.protonProtocolManager.handleBuffer(this, buffer.copy(VERSION_HEADER.length, buffer.capacity() - VERSION_HEADER.length));
            }
            if (this.sasl != null) {
                if (this.sasl.getRemoteMechanisms().length > 0) {
                    if ("PLAIN".equals(this.sasl.getRemoteMechanisms()[0])) {
                        byte[] data = new byte[this.sasl.pending()];
                        this.sasl.recv(data, 0, data.length);
                        this.sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
                        this.sasl = null;
                    } else if ("ANONYMOUS".equals(this.sasl.getRemoteMechanisms()[0])) {
                        this.sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
                        this.sasl = null;
                    }
                }
                this.write();
            }
        }
    }

    private boolean checkProtocol(String headerProt) {
        boolean ok = "AMQP".equals(headerProt);
        if (!ok) {
            this.protonConnection.setLocalError(new EndpointError(HornetQAMQPException.AmqpError.ILLEGAL_STATE.getError(), "Unknown Protocol " + headerProt));
        }
        return ok;
    }

    private boolean checkVersion(int major, int minor, int revision) {
        if (major < 1) {
            this.protonConnection.setLocalError(new EndpointError(HornetQAMQPException.AmqpError.ILLEGAL_STATE.getError(), "Version not supported " + major + "." + minor + "." + revision));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write() {
        Object object = this.deliveryLock;
        synchronized (object) {
            int size = 65536;
            byte[] data = new byte[size];
            boolean done = false;
            while (!done) {
                int count = this.protonTransport.output(data, 0, size);
                if (count > 0) {
                    HornetQBuffer buffer = this.connection.createBuffer(count);
                    buffer.writeBytes(data, 0, count);
                    this.connection.write(buffer);
                    continue;
                }
                done = true;
            }
        }
    }

    public String getLogin() {
        return this.username;
    }

    public String getPasscode() {
        return this.passcode;
    }

    public ServerMessageImpl createServerMessage() {
        return this.protonProtocolManager.createServerMessage();
    }

    protected synchronized void setDataReceived() {
        this.dataReceived = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFrame(byte[] frame) {
        Object object = this.deliveryLock;
        synchronized (object) {
            this.protonTransport.input(frame, 0, frame.length);
        }
        if (this.sasl != null && this.sasl.getRemoteMechanisms().length > 0) {
            if ("PLAIN".equals(this.sasl.getRemoteMechanisms()[0])) {
                byte[] data = new byte[this.sasl.pending()];
                this.sasl.recv(data, 0, data.length);
                this.setUserPass(data);
                this.sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
                this.sasl = null;
            } else if ("ANONYMOUS".equals(this.sasl.getRemoteMechanisms()[0])) {
                this.sasl.done(Sasl.SaslOutcome.PN_SASL_OK);
                this.sasl = null;
            }
        }
        if (this.protonConnection.getLocalState() == EndpointState.UNINITIALIZED && this.protonConnection.getRemoteState() != EndpointState.UNINITIALIZED) {
            this.clientId = this.protonConnection.getRemoteContainer();
            this.protonConnection.open();
            this.write();
        }
        Session session = this.protonConnection.sessionHead(ProtonProtocolManager.UNINITIALIZED, ProtonProtocolManager.INITIALIZED);
        while (session != null) {
            try {
                ProtonSession protonSession = this.getSession(session);
                session.setContext((Object)protonSession);
                session.open();
            }
            catch (HornetQAMQPException e) {
                this.protonConnection.setLocalError(new EndpointError(((Object)((Object)e)).getClass().getName(), e.getMessage()));
                session.close();
            }
            this.write();
            session = this.protonConnection.sessionHead(ProtonProtocolManager.UNINITIALIZED, ProtonProtocolManager.INITIALIZED);
        }
        LinkImpl link = (LinkImpl)this.protonConnection.linkHead(ProtonProtocolManager.UNINITIALIZED, ProtonProtocolManager.INITIALIZED);
        while (link != null) {
            try {
                this.protonProtocolManager.handleNewLink((Link)link, this.getSession((Session)link.getSession()));
            }
            catch (HornetQAMQPException e) {
                link.setLocalError(new EndpointError(e.getAmqpError(), e.getMessage()));
                link.close();
            }
            link = (LinkImpl)this.protonConnection.linkHead(ProtonProtocolManager.UNINITIALIZED, ProtonProtocolManager.INITIALIZED);
        }
        Iterator iterator = this.protonConnection.getWorkSequence();
        while (iterator.hasNext()) {
            DeliveryImpl delivery = (DeliveryImpl)iterator.next();
            ProtonDeliveryHandler handler = (ProtonDeliveryHandler)delivery.getLink().getContext();
            try {
                handler.onMessage((Delivery)delivery);
            }
            catch (HornetQAMQPException e) {
                delivery.getLink().setLocalError(new EndpointError(e.getAmqpError(), e.getMessage()));
            }
        }
        for (link = (LinkImpl)this.protonConnection.linkHead(ProtonProtocolManager.ACTIVE, ProtonProtocolManager.ANY_ENDPOINT_STATE); link != null; link = (LinkImpl)link.next(ProtonProtocolManager.ACTIVE, ProtonProtocolManager.ANY_ENDPOINT_STATE)) {
            try {
                this.protonProtocolManager.handleActiveLink((Link)link);
                continue;
            }
            catch (HornetQAMQPException e) {
                link.setLocalError(new EndpointError(e.getAmqpError(), e.getMessage()));
            }
        }
        for (link = (LinkImpl)this.protonConnection.linkHead(ProtonProtocolManager.ACTIVE, ProtonProtocolManager.CLOSED); link != null; link = (LinkImpl)link.next(ProtonProtocolManager.ACTIVE, ProtonProtocolManager.CLOSED)) {
            try {
                ((ProtonDeliveryHandler)link.getContext()).close();
            }
            catch (HornetQAMQPException e) {
                link.setLocalError(new EndpointError(e.getAmqpError(), e.getMessage()));
            }
            link.close();
        }
        for (session = this.protonConnection.sessionHead(ProtonProtocolManager.ACTIVE, ProtonProtocolManager.CLOSED); session != null; session = session.next(ProtonProtocolManager.ACTIVE, ProtonProtocolManager.CLOSED)) {
            ProtonSession protonSession = (ProtonSession)session.getContext();
            protonSession.close();
            this.sessions.remove(session);
            session.close();
        }
        if (this.protonConnection.getLocalState() == EndpointState.ACTIVE && this.protonConnection.getRemoteState() == EndpointState.CLOSED) {
            for (ProtonSession protonSession : this.sessions.values()) {
                protonSession.close();
            }
            this.sessions.clear();
            this.protonConnection.close();
            this.write();
            this.destroy();
        }
        this.write();
    }

    private void setUserPass(byte[] data) {
        String bytes = new String(data);
        String[] credentials = bytes.split(Character.toString('\u0000'));
        int offSet = 0;
        if (credentials.length > 0) {
            if (credentials[0].length() == 0) {
                offSet = 1;
            }
            if (credentials.length >= offSet) {
                this.username = credentials[offSet];
            }
            if (credentials.length >= offSet + 1) {
                this.passcode = credentials[offSet + 1];
            }
        }
    }

    private ProtonSession getSession(Session realSession) throws HornetQAMQPException {
        ProtonSession protonSession = this.sessions.get(realSession);
        if (protonSession == null) {
            protonSession = this.protonProtocolManager.createSession(this, this.protonTransport);
            this.sessions.put(realSession, protonSession);
        }
        return protonSession;
    }

    private void callFailureListeners(HornetQException me) {
        ArrayList<FailureListener> listenersClone = new ArrayList<FailureListener>(this.failureListeners);
        for (FailureListener listener : listenersClone) {
            try {
                listener.connectionFailed(me, false);
            }
            catch (Throwable t) {
                HornetQServerLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    private void callClosingListeners() {
        ArrayList<CloseListener> listenersClone = new ArrayList<CloseListener>(this.closeListeners);
        for (CloseListener listener : listenersClone) {
            try {
                listener.connectionClosed();
            }
            catch (Throwable t) {
                HornetQServerLogger.LOGGER.errorCallingFailureListener(t);
            }
        }
    }

    public Object getDeliveryLock() {
        return this.deliveryLock;
    }
}

