/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQIllegalStateException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.management.CoreNotificationType;
import org.hornetq.api.core.management.ManagementHelper;
import org.hornetq.api.core.management.NotificationType;
import org.hornetq.core.client.impl.ClientConsumerImpl;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.message.BodyEncoder;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.QueueBinding;
import org.hornetq.core.server.HandleStatus;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerConsumer;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.ServerSession;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.core.server.impl.ServerSessionImpl;
import org.hornetq.core.server.management.ManagementService;
import org.hornetq.core.server.management.Notification;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.impl.TransactionImpl;
import org.hornetq.spi.core.protocol.SessionCallback;
import org.hornetq.spi.core.remoting.ReadyListener;
import org.hornetq.utils.FutureLatch;
import org.hornetq.utils.LinkedListIterator;
import org.hornetq.utils.TypedProperties;

public class ServerConsumerImpl
implements ServerConsumer,
ReadyListener {
    private static boolean isTrace = HornetQServerLogger.LOGGER.isTraceEnabled();
    private final long id;
    private final Queue messageQueue;
    private final Filter filter;
    private final int minLargeMessageSize;
    private final ServerSession session;
    private final Object lock = new Object();
    private final boolean supportLargeMessage;
    private final ReadWriteLock lockDelivery = new ReentrantReadWriteLock();
    private volatile AtomicInteger availableCredits = new AtomicInteger(0);
    private boolean started;
    private volatile LargeMessageDeliverer largeMessageDeliverer = null;
    private final boolean browseOnly;
    private BrowserDeliverer browserDeliverer;
    private final boolean strictUpdateDeliveryCount;
    private final StorageManager storageManager;
    private final java.util.Queue<MessageReference> deliveringRefs = new ConcurrentLinkedQueue<MessageReference>();
    private final SessionCallback callback;
    private final boolean preAcknowledge;
    private final ManagementService managementService;
    private final Binding binding;
    private boolean transferring = false;
    private final AtomicBoolean writeReady = new AtomicBoolean(true);
    private final long creationTime;
    private final Runnable resumeLargeMessageRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = ServerConsumerImpl.this.lock;
            synchronized (object) {
                try {
                    if (ServerConsumerImpl.this.largeMessageDeliverer == null || ServerConsumerImpl.this.largeMessageDeliverer.deliver()) {
                        ServerConsumerImpl.this.forceDelivery();
                    }
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.errorRunningLargeMessageDeliverer(e);
                }
            }
        }
    };

    @Override
    public String debug() {
        return this.toString() + "::Delivering " + this.deliveringRefs.size();
    }

    public ServerConsumerImpl(long id, ServerSession session, QueueBinding binding, Filter filter, boolean started, boolean browseOnly, StorageManager storageManager, SessionCallback callback, boolean preAcknowledge, boolean strictUpdateDeliveryCount, ManagementService managementService) throws Exception {
        this(id, session, binding, filter, started, browseOnly, storageManager, callback, preAcknowledge, strictUpdateDeliveryCount, managementService, true, null);
    }

    public ServerConsumerImpl(long id, ServerSession session, QueueBinding binding, Filter filter, boolean started, boolean browseOnly, StorageManager storageManager, SessionCallback callback, boolean preAcknowledge, boolean strictUpdateDeliveryCount, ManagementService managementService, boolean supportLargeMessage, Integer credits) throws Exception {
        this.id = id;
        this.filter = filter;
        this.session = session;
        this.binding = binding;
        this.messageQueue = binding.getQueue();
        this.started = browseOnly || started;
        this.browseOnly = browseOnly;
        this.storageManager = storageManager;
        this.callback = callback;
        this.preAcknowledge = preAcknowledge;
        this.managementService = managementService;
        this.minLargeMessageSize = session.getMinLargeMessageSize();
        this.strictUpdateDeliveryCount = strictUpdateDeliveryCount;
        this.callback.addReadyListener(this);
        this.creationTime = System.currentTimeMillis();
        if (browseOnly) {
            this.browserDeliverer = new BrowserDeliverer(this.messageQueue.iterator());
        } else {
            this.messageQueue.addConsumer(this);
        }
        this.supportLargeMessage = supportLargeMessage;
        if (credits != null) {
            if (credits == -1) {
                this.availableCredits = null;
            } else {
                this.availableCredits.set(credits);
            }
        }
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public boolean isBrowseOnly() {
        return this.browseOnly;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getConnectionID() {
        return this.session.getConnectionID().toString();
    }

    @Override
    public String getSessionID() {
        return this.session.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> getDeliveringMessages() {
        LinkedList<MessageReference> refs = new LinkedList<MessageReference>();
        Object object = this.lock;
        synchronized (object) {
            List<MessageReference> refsOnConsumer = this.session.getInTXMessagesForConsumer(this.id);
            if (refsOnConsumer != null) {
                refs.addAll(refsOnConsumer);
            }
            refs.addAll(this.deliveringRefs);
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleStatus handle(MessageReference ref) throws Exception {
        if (this.availableCredits != null && this.availableCredits.get() <= 0) {
            if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
                HornetQServerLogger.LOGGER.debug(this + " is busy for the lack of credits. Current credits = " + this.availableCredits + " Can't receive reference " + ref);
            }
            return HandleStatus.BUSY;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.started || this.transferring) {
                return HandleStatus.BUSY;
            }
            if (this.largeMessageDeliverer != null) {
                if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
                    HornetQServerLogger.LOGGER.debug(this + " is busy delivering large message " + this.largeMessageDeliverer + ", can't deliver reference " + ref);
                }
                return HandleStatus.BUSY;
            }
            ServerMessage message = ref.getMessage();
            if (this.filter != null && !this.filter.match(message)) {
                if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
                    HornetQServerLogger.LOGGER.trace("Reference " + ref + " is a noMatch on consumer " + this);
                }
                return HandleStatus.NO_MATCH;
            }
            if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
                HornetQServerLogger.LOGGER.trace("Handling reference " + ref);
            }
            if (!this.browseOnly) {
                if (!this.preAcknowledge) {
                    this.deliveringRefs.add(ref);
                }
                ref.handled();
                ref.setConsumerId(this.id);
                ref.incrementDeliveryCount();
                if (this.strictUpdateDeliveryCount && !ref.isPaged() && ref.getMessage().isDurable() && ref.getQueue().isDurable() && !ref.getQueue().isInternalQueue() && !ref.isPaged()) {
                    this.storageManager.updateDeliveryCount(ref);
                }
                if (this.preAcknowledge) {
                    if (message.isLargeMessage()) {
                        ((LargeServerMessage)message).incrementDelayDeletionCount();
                    }
                    ref.getQueue().acknowledge(ref);
                }
            }
            if (message.isLargeMessage() && this.supportLargeMessage) {
                this.largeMessageDeliverer = new LargeMessageDeliverer((LargeServerMessage)message, ref);
            }
            this.lockDelivery.readLock().lock();
            return HandleStatus.HANDLED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proceedDeliver(MessageReference reference) throws Exception {
        try {
            ServerMessage message = reference.getMessage();
            if (message.isLargeMessage() && this.supportLargeMessage) {
                if (this.largeMessageDeliverer == null) {
                    this.largeMessageDeliverer = new LargeMessageDeliverer((LargeServerMessage)message, reference);
                }
                this.largeMessageDeliverer.deliver();
            } else {
                this.deliverStandardMessage(reference, message);
            }
        }
        finally {
            this.lockDelivery.readLock().unlock();
        }
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void close(boolean failed) throws Exception {
        this.callback.removeReadyListener(this);
        this.setStarted(false);
        LargeMessageDeliverer del = this.largeMessageDeliverer;
        if (del != null) {
            del.finish();
        }
        if (this.browseOnly) {
            this.browserDeliverer.close();
        } else {
            this.messageQueue.removeConsumer(this);
        }
        this.session.removeConsumer(this.id);
        List refs = this.cancelRefs(failed, false, null);
        Iterator iter = ((AbstractSequentialList)refs).iterator();
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        while (iter.hasNext()) {
            MessageReference ref = (MessageReference)iter.next();
            ref.getQueue().cancel(tx, ref, true);
        }
        tx.rollback();
        if (!this.browseOnly) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, this.binding.getAddress());
            props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, this.binding.getClusterName());
            props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, this.binding.getRoutingName());
            props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, this.filter == null ? null : this.filter.getFilterString());
            props.putIntProperty(ManagementHelper.HDR_DISTANCE, this.binding.getDistance());
            props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, this.messageQueue.getConsumerCount());
            props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.toSimpleString((String)this.session.getUsername()));
            props.putSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS, SimpleString.toSimpleString((String)((ServerSessionImpl)this.session).getRemotingConnection().getRemoteAddress()));
            props.putSimpleStringProperty(ManagementHelper.HDR_SESSION_NAME, SimpleString.toSimpleString((String)this.session.getName()));
            Notification notification = new Notification(null, (NotificationType)CoreNotificationType.CONSUMER_CLOSED, props);
            this.managementService.sendNotification(notification);
        }
    }

    @Override
    public synchronized void forceDelivery(final long sequence) {
        this.promptDelivery();
        this.messageQueue.getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = ServerConsumerImpl.this.lock;
                    synchronized (object) {
                        if (ServerConsumerImpl.this.transferring) {
                            ServerConsumerImpl.this.messageQueue.getExecutor().execute(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConsumerImpl.this.forceDelivery(sequence);
                                }
                            });
                        } else {
                            ServerMessageImpl forcedDeliveryMessage = new ServerMessageImpl(ServerConsumerImpl.this.storageManager.generateUniqueID(), 50);
                            forcedDeliveryMessage.putLongProperty(ClientConsumerImpl.FORCED_DELIVERY_MESSAGE, sequence);
                            forcedDeliveryMessage.setAddress(ServerConsumerImpl.this.messageQueue.getName());
                            ServerConsumerImpl.this.callback.sendMessage(forcedDeliveryMessage, ServerConsumerImpl.this.id, 0);
                        }
                    }
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.errorSendingForcedDelivery(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<MessageReference> cancelRefs(boolean failed, boolean lastConsumedAsDelivered, Transaction tx) throws Exception {
        boolean performACK = lastConsumedAsDelivered;
        try {
            if (this.largeMessageDeliverer != null) {
                this.largeMessageDeliverer.finish();
            }
        }
        catch (Throwable e) {
            HornetQServerLogger.LOGGER.errorResttingLargeMessage(e, this.largeMessageDeliverer);
        }
        finally {
            this.largeMessageDeliverer = null;
        }
        LinkedList<MessageReference> refs = new LinkedList<MessageReference>();
        if (!this.deliveringRefs.isEmpty()) {
            for (MessageReference ref : this.deliveringRefs) {
                if (isTrace) {
                    HornetQServerLogger.LOGGER.trace("Cancelling reference for messageID = " + ref.getMessage().getMessageID() + ", ref = " + ref);
                }
                if (performACK) {
                    this.acknowledge(false, tx, ref.getMessage().getMessageID());
                    performACK = false;
                    continue;
                }
                if (!failed) {
                    ref.decrementDeliveryCount();
                }
                refs.add(ref);
            }
            this.deliveringRefs.clear();
        }
        return refs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStarted(boolean started) {
        Object object = this.lock;
        synchronized (object) {
            this.lockDelivery.writeLock().lock();
            try {
                this.started = this.browseOnly || started;
            }
            finally {
                this.lockDelivery.writeLock().unlock();
            }
        }
        if (started) {
            this.promptDelivery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransferring(boolean transferring) {
        Object object = this.lock;
        synchronized (object) {
            this.lockDelivery.writeLock().lock();
            try {
                this.transferring = transferring;
            }
            finally {
                this.lockDelivery.writeLock().unlock();
            }
        }
        if (transferring) {
            FutureLatch future = new FutureLatch();
            this.messageQueue.getExecutor().execute((Runnable)future);
            boolean ok = future.await(10000L);
            if (!ok) {
                HornetQServerLogger.LOGGER.errorTransferringConsumer();
            }
        }
        if (!transferring) {
            this.promptDelivery();
        }
    }

    @Override
    public void receiveCredits(int credits) throws Exception {
        if (credits == -1) {
            if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
                HornetQServerLogger.LOGGER.debug(this + ":: FlowControl::Received disable flow control message");
            }
            this.availableCredits = null;
            this.promptDelivery();
        } else if (credits == 0) {
            HornetQServerLogger.LOGGER.debug(this + ":: FlowControl::Received reset flow control message");
            this.availableCredits.set(0);
        } else {
            int previous = this.availableCredits.getAndAdd(credits);
            if (HornetQServerLogger.LOGGER.isDebugEnabled()) {
                HornetQServerLogger.LOGGER.debug(this + "::FlowControl::Received " + credits + " credits, previous value = " + previous + " currentValue = " + this.availableCredits.get());
            }
            if (previous <= 0 && previous + credits > 0) {
                if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
                    HornetQServerLogger.LOGGER.trace(this + "::calling promptDelivery from receiving credits");
                }
                this.promptDelivery();
            }
        }
    }

    @Override
    public Queue getQueue() {
        return this.messageQueue;
    }

    @Override
    public void acknowledge(boolean autoCommitAcks, Transaction tx, long messageID) throws Exception {
        if (this.browseOnly) {
            return;
        }
        boolean startedTransaction = false;
        if (tx == null || autoCommitAcks) {
            startedTransaction = true;
            tx = new TransactionImpl(this.storageManager);
        }
        try {
            MessageReference ref;
            do {
                ref = this.deliveringRefs.poll();
                if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
                    HornetQServerLogger.LOGGER.trace("ACKing ref " + ref + " on tx= " + tx + ", consumer=" + this);
                }
                if (ref == null) {
                    throw HornetQMessageBundle.BUNDLE.consumerNoReference(this.id, messageID, this.messageQueue.getName());
                }
                ref.getQueue().acknowledge(tx, ref);
            } while (ref.getMessage().getMessageID() != messageID);
            if (startedTransaction) {
                tx.commit();
            }
        }
        catch (HornetQException e) {
            if (startedTransaction) {
                tx.rollback();
            } else {
                tx.markAsRollbackOnly(e);
            }
            throw e;
        }
        catch (Throwable e) {
            HornetQServerLogger.LOGGER.errorAckingMessage((Exception)e);
            HornetQIllegalStateException hqex = new HornetQIllegalStateException(e.getMessage());
            if (startedTransaction) {
                tx.rollback();
            } else {
                tx.markAsRollbackOnly((HornetQException)hqex);
            }
            throw hqex;
        }
    }

    @Override
    public void individualAcknowledge(boolean autoCommitAcks, Transaction tx, long messageID) throws Exception {
        if (this.browseOnly) {
            return;
        }
        MessageReference ref = this.removeReferenceByID(messageID);
        if (ref == null) {
            throw new IllegalStateException("Cannot find ref to ack " + messageID);
        }
        if (autoCommitAcks) {
            ref.getQueue().acknowledge(ref);
        } else {
            ref.getQueue().acknowledge(tx, ref);
        }
    }

    @Override
    public void individualCancel(long messageID, boolean failed) throws Exception {
        if (this.browseOnly) {
            return;
        }
        MessageReference ref = this.removeReferenceByID(messageID);
        if (ref == null) {
            throw new IllegalStateException("Cannot find ref to ack " + messageID);
        }
        if (!failed) {
            ref.decrementDeliveryCount();
        }
        ref.getQueue().cancel(ref, System.currentTimeMillis());
    }

    @Override
    public MessageReference removeReferenceByID(long messageID) throws Exception {
        if (this.browseOnly) {
            return null;
        }
        Iterator iter = this.deliveringRefs.iterator();
        MessageReference ref = null;
        while (iter.hasNext()) {
            MessageReference theRef = (MessageReference)iter.next();
            if (theRef.getMessage().getMessageID() != messageID) continue;
            iter.remove();
            ref = theRef;
            break;
        }
        return ref;
    }

    public void readyForWriting(boolean ready) {
        if (ready) {
            this.writeReady.set(true);
            this.promptDelivery();
        } else {
            this.writeReady.set(false);
        }
    }

    public AtomicInteger getAvailableCredits() {
        return this.availableCredits;
    }

    public String toString() {
        return "ServerConsumerImpl [id=" + this.id + ", filter=" + this.filter + ", binding=" + this.binding + "]";
    }

    @Override
    public String toManagementString() {
        return "ServerConsumer [id=" + this.id + ", filter=" + this.filter + ", binding=" + this.binding.toManagementString() + "]";
    }

    @Override
    public void disconnect() {
        this.callback.disconnect(this.id, this.getQueue().getName().toString());
    }

    private void promptDelivery() {
        if (this.largeMessageDeliverer != null) {
            this.resumeLargeMessage();
        } else {
            this.forceDelivery();
        }
    }

    private void forceDelivery() {
        if (this.browseOnly) {
            this.messageQueue.getExecutor().execute(this.browserDeliverer);
        } else {
            this.messageQueue.deliverAsync();
        }
    }

    private void resumeLargeMessage() {
        this.messageQueue.getExecutor().execute(this.resumeLargeMessageRunnable);
    }

    private void deliverStandardMessage(MessageReference ref, ServerMessage message) {
        int packetSize = this.callback.sendMessage(message, this.id, ref.getDeliveryCount());
        if (this.availableCredits != null) {
            this.availableCredits.addAndGet(-packetSize);
            if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
                HornetQServerLogger.LOGGER.trace(this + "::FlowControl::delivery standard taking " + packetSize + " from credits, available now is " + this.availableCredits);
            }
        }
    }

    private class BrowserDeliverer
    implements Runnable {
        private MessageReference current = null;
        private final LinkedListIterator<MessageReference> iterator;

        public BrowserDeliverer(LinkedListIterator<MessageReference> iterator) {
            this.iterator = iterator;
        }

        public synchronized void close() {
            this.iterator.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            block13: {
                if (this.current != null) {
                    try {
                        HandleStatus status = ServerConsumerImpl.this.handle(this.current);
                        if (status == HandleStatus.BUSY) {
                            return;
                        }
                        if (status == HandleStatus.HANDLED) {
                            ServerConsumerImpl.this.proceedDeliver(this.current);
                        }
                        this.current = null;
                    }
                    catch (Exception e) {
                        HornetQServerLogger.LOGGER.errorBrowserHandlingMessage(e, this.current);
                        return;
                    }
                }
                MessageReference ref = null;
                try {
                    while (true) {
                        HandleStatus status;
                        ref = null;
                        Queue queue = ServerConsumerImpl.this.messageQueue;
                        synchronized (queue) {
                            if (!this.iterator.hasNext()) {
                                break block13;
                            }
                            ref = (MessageReference)this.iterator.next();
                            status = ServerConsumerImpl.this.handle(ref);
                        }
                        if (status == HandleStatus.HANDLED) {
                            ServerConsumerImpl.this.proceedDeliver(ref);
                            continue;
                        }
                        if (status == HandleStatus.BUSY) break;
                    }
                    this.current = ref;
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.errorBrowserHandlingMessage(e, ref);
                }
            }
        }

        public boolean isBrowsed() {
            ServerConsumerImpl.this.messageQueue.deliverAsync();
            boolean b = !this.iterator.hasNext();
            return b;
        }
    }

    private final class LargeMessageDeliverer {
        private long sizePendingLargeMessage;
        private LargeServerMessage largeMessage;
        private final MessageReference ref;
        private boolean sentInitialPacket = false;
        private long positionPendingLargeMessage;
        private BodyEncoder context;

        public LargeMessageDeliverer(LargeServerMessage message, MessageReference ref) throws Exception {
            this.largeMessage = message;
            this.largeMessage.incrementDelayDeletionCount();
            this.ref = ref;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean deliver() throws Exception {
            ServerConsumerImpl.this.lockDelivery.readLock().lock();
            try {
                if (this.largeMessage == null) {
                    boolean bl = true;
                    return bl;
                }
                if (ServerConsumerImpl.this.availableCredits != null && ServerConsumerImpl.this.availableCredits.get() <= 0) {
                    if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
                        HornetQServerLogger.LOGGER.trace(this + "::FlowControl::delivery largeMessage interrupting as there are no more credits, available=" + ServerConsumerImpl.this.availableCredits);
                    }
                    boolean bl = false;
                    return bl;
                }
                if (!this.sentInitialPacket) {
                    this.context = this.largeMessage.getBodyEncoder();
                    this.sizePendingLargeMessage = this.context.getLargeBodySize();
                    this.context.open();
                    this.sentInitialPacket = true;
                    int packetSize = ServerConsumerImpl.this.callback.sendLargeMessage(this.largeMessage, ServerConsumerImpl.this.id, this.context.getLargeBodySize(), this.ref.getDeliveryCount());
                    if (ServerConsumerImpl.this.availableCredits != null) {
                        ServerConsumerImpl.this.availableCredits.addAndGet(-packetSize);
                        if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
                            HornetQServerLogger.LOGGER.trace(this + "::FlowControl::" + " deliver initialpackage with " + packetSize + " delivered, available now = " + ServerConsumerImpl.this.availableCredits);
                        }
                    }
                    ServerConsumerImpl.this.resumeLargeMessage();
                    boolean bl = false;
                    return bl;
                }
                if (ServerConsumerImpl.this.availableCredits != null && ServerConsumerImpl.this.availableCredits.get() <= 0) {
                    if (isTrace) {
                        HornetQServerLogger.LOGGER.trace(this + "::FlowControl::deliverLargeMessage Leaving loop of send LargeMessage because of credits, available=" + ServerConsumerImpl.this.availableCredits);
                    }
                    boolean packetSize = false;
                    return packetSize;
                }
                int localChunkLen = 0;
                localChunkLen = (int)Math.min(this.sizePendingLargeMessage - this.positionPendingLargeMessage, (long)ServerConsumerImpl.this.minLargeMessageSize);
                HornetQBuffer bodyBuffer = HornetQBuffers.fixedBuffer((int)localChunkLen);
                this.context.encode(bodyBuffer, localChunkLen);
                byte[] body = bodyBuffer.toByteBuffer().array();
                int packetSize = ServerConsumerImpl.this.callback.sendLargeMessageContinuation(ServerConsumerImpl.this.id, body, this.positionPendingLargeMessage + (long)localChunkLen < this.sizePendingLargeMessage, false);
                int chunkLen = body.length;
                if (ServerConsumerImpl.this.availableCredits != null) {
                    ServerConsumerImpl.this.availableCredits.addAndGet(-packetSize);
                    if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
                        HornetQServerLogger.LOGGER.trace(this + "::FlowControl::largeMessage deliver continuation, packetSize=" + packetSize + " available now=" + ServerConsumerImpl.this.availableCredits);
                    }
                }
                this.positionPendingLargeMessage += (long)chunkLen;
                if (this.positionPendingLargeMessage < this.sizePendingLargeMessage) {
                    ServerConsumerImpl.this.resumeLargeMessage();
                    boolean bl = false;
                    return bl;
                }
                if (isTrace) {
                    HornetQServerLogger.LOGGER.trace("Finished deliverLargeMessage");
                }
                this.finish();
                boolean bl = true;
                return bl;
            }
            finally {
                ServerConsumerImpl.this.lockDelivery.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() throws Exception {
            Object object = ServerConsumerImpl.this.lock;
            synchronized (object) {
                if (this.largeMessage == null) {
                    return;
                }
                if (this.context != null) {
                    this.context.close();
                }
                this.largeMessage.releaseResources();
                this.largeMessage.decrementDelayDeletionCount();
                if (ServerConsumerImpl.this.preAcknowledge && !ServerConsumerImpl.this.browseOnly) {
                    this.largeMessage.decrementDelayDeletionCount();
                }
                ServerConsumerImpl.this.largeMessageDeliverer = null;
                this.largeMessage = null;
            }
        }
    }
}

