/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl;

import io.netty.channel.ChannelPipeline;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.Interceptor;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.TopologyMember;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.protocol.ServerPacketDecoder;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.ChannelHandler;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.ServerSessionPacketHandler;
import org.hornetq.core.protocol.core.impl.ChannelImpl;
import org.hornetq.core.protocol.core.impl.HornetQPacketHandler;
import org.hornetq.core.protocol.core.impl.PacketDecoder;
import org.hornetq.core.protocol.core.impl.RemotingConnectionImpl;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V2;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterTopologyChangeMessage_V3;
import org.hornetq.core.protocol.core.impl.wireformat.Ping;
import org.hornetq.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SubscribeClusterTopologyUpdatesMessageV2;
import org.hornetq.core.remoting.CloseListener;
import org.hornetq.core.remoting.impl.netty.HornetQFrameDecoder2;
import org.hornetq.core.remoting.impl.netty.NettyServerConnection;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.spi.core.protocol.ConnectionEntry;
import org.hornetq.spi.core.protocol.MessageConverter;
import org.hornetq.spi.core.protocol.ProtocolManager;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.remoting.Acceptor;
import org.hornetq.spi.core.remoting.Connection;

class CoreProtocolManager
implements ProtocolManager {
    private static final boolean isTrace = HornetQServerLogger.LOGGER.isTraceEnabled();
    private final HornetQServer server;
    private final List<Interceptor> incomingInterceptors;
    private final List<Interceptor> outgoingInterceptors;
    private final Map<String, ServerSessionPacketHandler> sessionHandlers = new ConcurrentHashMap<String, ServerSessionPacketHandler>();

    CoreProtocolManager(HornetQServer server, List<Interceptor> incomingInterceptors, List<Interceptor> outgoingInterceptors) {
        this.server = server;
        this.incomingInterceptors = incomingInterceptors;
        this.outgoingInterceptors = outgoingInterceptors;
    }

    @Override
    public MessageConverter getConverter() {
        return null;
    }

    @Override
    public ConnectionEntry createConnectionEntry(Acceptor acceptorUsed, Connection connection) {
        Configuration config = this.server.getConfiguration();
        Executor connectionExecutor = this.server.getExecutorFactory().getExecutor();
        RemotingConnectionImpl rc = new RemotingConnectionImpl((PacketDecoder)ServerPacketDecoder.INSTANCE, connection, this.incomingInterceptors, this.outgoingInterceptors, config.isAsyncConnectionExecutionEnabled() ? connectionExecutor : null, this.server.getNodeID());
        Channel channel1 = rc.getChannel(ChannelImpl.CHANNEL_ID.SESSION.id, -1);
        HornetQPacketHandler handler = new HornetQPacketHandler(this, this.server, channel1, (CoreRemotingConnection)rc);
        channel1.setHandler((ChannelHandler)handler);
        long ttl = HornetQClient.DEFAULT_CONNECTION_TTL;
        if (config.getConnectionTTLOverride() != -1L) {
            ttl = config.getConnectionTTLOverride();
        }
        ConnectionEntry entry = new ConnectionEntry((RemotingConnection)rc, connectionExecutor, System.currentTimeMillis(), ttl);
        Channel channel0 = rc.getChannel(ChannelImpl.CHANNEL_ID.PING.id, -1);
        channel0.setHandler((ChannelHandler)new LocalChannelHandler(config, entry, channel0, acceptorUsed, (CoreRemotingConnection)rc));
        this.server.getClusterManager().addClusterChannelHandler(rc.getChannel(ChannelImpl.CHANNEL_ID.CLUSTER.id, -1), acceptorUsed, (CoreRemotingConnection)rc, this.server.getActivation());
        return entry;
    }

    ServerSessionPacketHandler getSessionHandler(String sessionName) {
        return this.sessionHandlers.get(sessionName);
    }

    void addSessionHandler(String name, ServerSessionPacketHandler handler) {
        this.sessionHandlers.put(name, handler);
    }

    @Override
    public void removeHandler(String name) {
        this.sessionHandlers.remove(name);
    }

    @Override
    public void handleBuffer(RemotingConnection connection, HornetQBuffer buffer) {
    }

    @Override
    public void addChannelHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("hornetq-decoder", (io.netty.channel.ChannelHandler)new HornetQFrameDecoder2());
    }

    @Override
    public boolean isProtocol(byte[] array) {
        String frameStart = new String(array, StandardCharsets.US_ASCII);
        return frameStart.startsWith("HORNETQ");
    }

    @Override
    public void handshake(NettyServerConnection connection, HornetQBuffer buffer) {
        if (buffer.getByte(0) == 72 && buffer.getByte(1) == 79 && buffer.getByte(2) == 82 && buffer.getByte(3) == 78 && buffer.getByte(4) == 69 && buffer.getByte(5) == 84 && buffer.getByte(6) == 81) {
            buffer.readBytes(7);
        }
    }

    public String toString() {
        return "CoreProtocolManager(server=" + this.server + ")";
    }

    private class LocalChannelHandler
    implements ChannelHandler {
        private final Configuration config;
        private final ConnectionEntry entry;
        private final Channel channel0;
        private final Acceptor acceptorUsed;
        private final CoreRemotingConnection rc;

        public LocalChannelHandler(Configuration config, ConnectionEntry entry, Channel channel0, Acceptor acceptorUsed, CoreRemotingConnection rc) {
            this.config = config;
            this.entry = entry;
            this.channel0 = channel0;
            this.acceptorUsed = acceptorUsed;
            this.rc = rc;
        }

        public void handlePacket(Packet packet) {
            if (packet.getType() == 10) {
                Ping ping = (Ping)packet;
                if (this.config.getConnectionTTLOverride() == -1L) {
                    this.entry.ttl = ping.getConnectionTTL();
                }
                this.channel0.send(packet);
            } else if (packet.getType() == 112 || packet.getType() == 113) {
                SubscribeClusterTopologyUpdatesMessage msg = (SubscribeClusterTopologyUpdatesMessage)packet;
                if (packet.getType() == 113) {
                    this.channel0.getConnection().setClientVersion(((SubscribeClusterTopologyUpdatesMessageV2)msg).getClientVersion());
                }
                final ClusterTopologyListener listener = new ClusterTopologyListener(){

                    public void nodeUP(final TopologyMember topologyMember, final boolean last) {
                        try {
                            final Pair connectorPair = new Pair((Object)topologyMember.getLive(), (Object)topologyMember.getBackup());
                            final String nodeID = topologyMember.getNodeId();
                            ((LocalChannelHandler)LocalChannelHandler.this).entry.connectionExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    if (LocalChannelHandler.this.channel0.supports((byte)122)) {
                                        LocalChannelHandler.this.channel0.send((Packet)new ClusterTopologyChangeMessage_V3(topologyMember.getUniqueEventID(), nodeID, topologyMember.getBackupGroupName(), topologyMember.getScaleDownGroupName(), connectorPair, last));
                                    } else if (LocalChannelHandler.this.channel0.supports((byte)114)) {
                                        LocalChannelHandler.this.channel0.send((Packet)new ClusterTopologyChangeMessage_V2(topologyMember.getUniqueEventID(), nodeID, topologyMember.getBackupGroupName(), connectorPair, last));
                                    } else {
                                        LocalChannelHandler.this.channel0.send((Packet)new ClusterTopologyChangeMessage(nodeID, connectorPair, last));
                                    }
                                }
                            });
                        }
                        catch (RejectedExecutionException rejectedExecutionException) {
                            // empty catch block
                        }
                    }

                    public void nodeDown(final long uniqueEventID, final String nodeID) {
                        try {
                            ((LocalChannelHandler)LocalChannelHandler.this).entry.connectionExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    if (LocalChannelHandler.this.channel0.supports((byte)114)) {
                                        LocalChannelHandler.this.channel0.send((Packet)new ClusterTopologyChangeMessage_V2(uniqueEventID, nodeID));
                                    } else {
                                        LocalChannelHandler.this.channel0.send((Packet)new ClusterTopologyChangeMessage(nodeID));
                                    }
                                }
                            });
                        }
                        catch (RejectedExecutionException ignored) {
                            // empty catch block
                        }
                    }

                    public String toString() {
                        return "Remote Proxy on channel " + Integer.toHexString(System.identityHashCode(this));
                    }
                };
                if (this.acceptorUsed.getClusterConnection() != null) {
                    this.acceptorUsed.getClusterConnection().addClusterTopologyListener(listener);
                    this.rc.addCloseListener(new CloseListener(){

                        public void connectionClosed() {
                            LocalChannelHandler.this.acceptorUsed.getClusterConnection().removeClusterTopologyListener(listener);
                        }
                    });
                } else {
                    this.entry.connectionExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            String nodeId = CoreProtocolManager.this.server.getNodeID().toString();
                            Pair emptyConfig = new Pair(null, null);
                            if (LocalChannelHandler.this.channel0.supports((byte)114)) {
                                LocalChannelHandler.this.channel0.send((Packet)new ClusterTopologyChangeMessage_V2(System.currentTimeMillis(), nodeId, null, emptyConfig, true));
                            } else {
                                LocalChannelHandler.this.channel0.send((Packet)new ClusterTopologyChangeMessage(nodeId, emptyConfig, true));
                            }
                        }
                    });
                }
            }
        }

        private Pair<TransportConfiguration, TransportConfiguration> getPair(TransportConfiguration conn, boolean isBackup) {
            if (isBackup) {
                return new Pair(null, (Object)conn);
            }
            return new Pair((Object)conn, null);
        }
    }
}

