/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster;

import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.config.ClusterConnectionConfiguration;
import org.hornetq.core.config.ConfigurationUtils;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.Packet;
import org.hornetq.core.protocol.core.impl.ChannelImpl;
import org.hornetq.core.protocol.core.impl.wireformat.BackupRegistrationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.BackupRequestMessage;
import org.hornetq.core.protocol.core.impl.wireformat.BackupResponseMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterConnectMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ClusterConnectReplyMessage;
import org.hornetq.core.protocol.core.impl.wireformat.NodeAnnounceMessage;
import org.hornetq.core.protocol.core.impl.wireformat.QuorumVoteMessage;
import org.hornetq.core.protocol.core.impl.wireformat.QuorumVoteReplyMessage;
import org.hornetq.core.protocol.core.impl.wireformat.ScaleDownAnnounceMessage;
import org.hornetq.core.server.HornetQMessageBundle;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.cluster.qourum.QuorumVoteHandler;
import org.hornetq.core.server.cluster.qourum.Vote;

public class ClusterControl
implements AutoCloseable {
    private Channel clusterChannel;
    private final ClientSessionFactoryInternal sessionFactory;
    private final HornetQServer server;
    private final String clusterUser;
    private final String clusterPassword;

    public ClusterControl(ClientSessionFactoryInternal sessionFactory, HornetQServer server) {
        this.sessionFactory = sessionFactory;
        this.server = server;
        this.clusterUser = server.getConfiguration().getClusterUser();
        this.clusterPassword = server.getConfiguration().getClusterPassword();
    }

    public void authorize() throws HornetQException {
        CoreRemotingConnection connection = (CoreRemotingConnection)this.sessionFactory.getConnection();
        this.clusterChannel = connection.getChannel(ChannelImpl.CHANNEL_ID.CLUSTER.id, -1);
        ClusterConnectReplyMessage packet = (ClusterConnectReplyMessage)this.clusterChannel.sendBlocking((Packet)new ClusterConnectMessage(this.clusterUser, this.clusterPassword), (byte)126);
        if (!packet.isAuthorized()) {
            throw HornetQMessageBundle.BUNDLE.unableToValidateClusterUser(this.clusterUser);
        }
    }

    public void announceReplicatingBackupToLive(boolean attemptingFailBack, String replicationClusterName) throws HornetQException {
        ClusterConnectionConfiguration config = ConfigurationUtils.getReplicationClusterConfiguration(this.server.getConfiguration(), replicationClusterName);
        if (config == null) {
            HornetQServerLogger.LOGGER.announceBackupNoClusterConnections();
            throw new HornetQException("lacking cluster connection");
        }
        TransportConfiguration connector = this.server.getConfiguration().getConnectorConfigurations().get(config.getConnectorName());
        if (connector == null) {
            HornetQServerLogger.LOGGER.announceBackupNoConnector(config.getConnectorName());
            throw new HornetQException("lacking cluster connection");
        }
        this.clusterChannel.send((Packet)new BackupRegistrationMessage(connector, this.clusterUser, this.clusterPassword, attemptingFailBack));
    }

    public void sendNodeAnnounce(long currentEventID, String nodeID, String backupGroupName, String scaleDownGroupName, boolean isBackup, TransportConfiguration config, TransportConfiguration backupConfig) {
        this.clusterChannel.send((Packet)new NodeAnnounceMessage(currentEventID, nodeID, backupGroupName, scaleDownGroupName, isBackup, config, backupConfig));
    }

    public Channel createReplicationChannel() {
        CoreRemotingConnection connection = (CoreRemotingConnection)this.sessionFactory.getConnection();
        return connection.getChannel(ChannelImpl.CHANNEL_ID.REPLICATION.id, -1);
    }

    public ClientSessionFactoryInternal getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public void close() {
        this.sessionFactory.close();
    }

    public Vote sendQuorumVote(SimpleString handler, Vote vote) {
        try {
            QuorumVoteReplyMessage replyMessage = (QuorumVoteReplyMessage)this.clusterChannel.sendBlocking((Packet)new QuorumVoteMessage(handler, vote), (byte)-3);
            QuorumVoteHandler voteHandler = this.server.getClusterManager().getQuorumManager().getVoteHandler(replyMessage.getHandler());
            replyMessage.decodeRest(voteHandler);
            return replyMessage.getVote();
        }
        catch (HornetQException e) {
            return null;
        }
    }

    public boolean requestReplicatedBackup(int backupSize, SimpleString nodeID) {
        BackupRequestMessage backupRequestMessage = new BackupRequestMessage(backupSize, nodeID);
        return this.requestBackup(backupRequestMessage);
    }

    private boolean requestBackup(BackupRequestMessage backupRequestMessage) {
        BackupResponseMessage packet;
        try {
            packet = (BackupResponseMessage)this.clusterChannel.sendBlocking((Packet)backupRequestMessage, (byte)-1);
        }
        catch (HornetQException e) {
            return false;
        }
        return packet.isBackupStarted();
    }

    public boolean requestSharedStoreBackup(int backupSize, String journalDirectory, String bindingsDirectory, String largeMessagesDirectory, String pagingDirectory) {
        BackupRequestMessage backupRequestMessage = new BackupRequestMessage(backupSize, journalDirectory, bindingsDirectory, largeMessagesDirectory, pagingDirectory);
        return this.requestBackup(backupRequestMessage);
    }

    public void announceScaleDown(SimpleString targetNodeId, SimpleString scaledDownNodeId) {
        ScaleDownAnnounceMessage announceMessage = new ScaleDownAnnounceMessage(targetNodeId, scaledDownNodeId);
        this.clusterChannel.send((Packet)announceMessage);
    }
}

