/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.qourum;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQExceptionType;
import org.hornetq.core.client.impl.ClientSessionFactoryInternal;
import org.hornetq.core.client.impl.Topology;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.protocol.core.CoreRemotingConnection;
import org.hornetq.core.protocol.core.impl.wireformat.ReplicationLiveIsStoppingMessage;
import org.hornetq.core.remoting.FailureListener;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.cluster.qourum.Quorum;
import org.hornetq.core.server.cluster.qourum.QuorumManager;
import org.hornetq.core.server.cluster.qourum.QuorumVoteServerConnect;

public class SharedNothingBackupQuorum
implements Quorum,
FailureListener {
    private QuorumManager quorumManager;
    private String targetServerID = "";
    private final NodeManager nodeManager;
    private final StorageManager storageManager;
    private final ScheduledExecutorService scheduledPool;
    private CountDownLatch latch;
    private ClientSessionFactoryInternal sessionFactory;
    private CoreRemotingConnection connection;
    public static final int WAIT_TIME_AFTER_FIRST_LIVE_STOPPING_MSG = 60;
    private volatile BACKUP_ACTIVATION signal;
    private static final int LATCH_TIMEOUT = 30;
    private static final int RECONNECT_ATTEMPTS = 5;
    private final Object decisionGuard = new Object();

    public SharedNothingBackupQuorum(StorageManager storageManager, NodeManager nodeManager, ScheduledExecutorService scheduledPool) {
        this.storageManager = storageManager;
        this.scheduledPool = scheduledPool;
        this.latch = new CountDownLatch(1);
        this.nodeManager = nodeManager;
    }

    @Override
    public String getName() {
        return "SharedNothingBackupQuorum";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decideOnAction(Topology topology) {
        Object object = this.decisionGuard;
        synchronized (object) {
            block7: {
                if (this.signal == BACKUP_ACTIVATION.FAIL_OVER) {
                    return;
                }
                if (!this.isLiveDown()) {
                    try {
                        this.sessionFactory.connect(5, false);
                        return;
                    }
                    catch (HornetQException e) {
                        if (e.getType() == HornetQExceptionType.NOT_CONNECTED) break block7;
                        HornetQServerLogger.LOGGER.errorReConnecting((Exception)((Object)e));
                    }
                }
            }
            this.signal = BACKUP_ACTIVATION.FAIL_OVER;
        }
        this.latch.countDown();
    }

    public void liveIDSet(String liveID) {
        this.targetServerID = liveID;
        this.nodeManager.setNodeID(liveID);
    }

    @Override
    public void setQuorumManager(QuorumManager quorumManager) {
        this.quorumManager = quorumManager;
    }

    @Override
    public void nodeDown(Topology topology, long eventUID, String nodeID) {
        if (this.targetServerID.equals(nodeID)) {
            this.decideOnAction(topology);
        }
    }

    @Override
    public void nodeUp(Topology topology) {
    }

    public void connectionFailed(HornetQException exception, boolean failedOver) {
        this.decideOnAction(this.sessionFactory.getServerLocator().getTopology());
    }

    public void connectionFailed(HornetQException me, boolean failedOver, String scaleDownTargetNodeID) {
        this.connectionFailed(me, failedOver);
    }

    @Override
    public void close() {
        this.causeExit(BACKUP_ACTIVATION.STOP);
    }

    public void setSessionFactory(ClientSessionFactoryInternal sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.connection = (CoreRemotingConnection)sessionFactory.getConnection();
        this.connection.addFailureListener((FailureListener)this);
    }

    public synchronized void failOver(ReplicationLiveIsStoppingMessage.LiveStopping finalMessage) {
        this.removeListener();
        this.signal = BACKUP_ACTIVATION.FAIL_OVER;
        if (finalMessage == ReplicationLiveIsStoppingMessage.LiveStopping.FAIL_OVER) {
            this.latch.countDown();
        }
        if (finalMessage == ReplicationLiveIsStoppingMessage.LiveStopping.STOP_CALLED) {
            final CountDownLatch localLatch = this.latch;
            this.scheduledPool.schedule(new Runnable(){

                @Override
                public void run() {
                    localLatch.countDown();
                }
            }, 60L, TimeUnit.SECONDS);
        }
    }

    public void notifyRegistrationFailed() {
        this.signal = BACKUP_ACTIVATION.FAILURE_REPLICATING;
        this.latch.countDown();
    }

    public void notifyAlreadyReplicating() {
        this.signal = BACKUP_ACTIVATION.ALREADY_REPLICATING;
        this.latch.countDown();
    }

    private void removeListener() {
        if (this.connection != null) {
            this.connection.removeFailureListener((FailureListener)this);
        }
    }

    public BACKUP_ACTIVATION waitForStatusChange() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            return BACKUP_ACTIVATION.STOP;
        }
        return this.signal;
    }

    public synchronized void causeExit(BACKUP_ACTIVATION explicitSignal) {
        this.removeListener();
        this.signal = explicitSignal;
        this.latch.countDown();
    }

    public synchronized void reset() {
        this.latch = new CountDownLatch(1);
    }

    private boolean isLiveDown() {
        int size = this.quorumManager.getMaxClusterSize() - 1;
        QuorumVoteServerConnect quorumVote = new QuorumVoteServerConnect(size, this.storageManager);
        this.quorumManager.vote(quorumVote);
        try {
            quorumVote.await(30, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.quorumManager.voteComplete(quorumVote);
        return quorumVote.getDecision();
    }

    public static enum BACKUP_ACTIVATION {
        FAIL_OVER,
        FAILURE_REPLICATING,
        ALREADY_REPLICATING,
        STOP;

    }
}

