/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileLock;
import org.hornetq.core.asyncio.impl.AsynchronousFileImpl;
import org.hornetq.core.server.impl.FileLockNodeManager;

public final class AIOFileLockNodeManager
extends FileLockNodeManager {
    public AIOFileLockNodeManager(String directory, boolean replicatingBackup) {
        super(directory, replicatingBackup);
    }

    public AIOFileLockNodeManager(String directory, boolean replicatingBackup, long lockAcquisitionTimeout) {
        super(directory, replicatingBackup);
        this.lockAcquisitionTimeout = lockAcquisitionTimeout;
    }

    @Override
    protected FileLock tryLock(int lockPos) throws Exception {
        File file = this.newFileForRegionLock(lockPos);
        int handle = AsynchronousFileImpl.openFile((String)file.getAbsolutePath());
        if (handle < 0) {
            throw new IOException("couldn't open file " + file.getAbsolutePath());
        }
        FileLock lock = AsynchronousFileImpl.lock((int)handle);
        if (lock == null) {
            AsynchronousFileImpl.closeFile((int)handle);
        }
        return lock;
    }

    @Override
    protected FileLock lock(int liveLockPos) throws Exception {
        long start = System.currentTimeMillis();
        File file = this.newFileForRegionLock(liveLockPos);
        while (!this.interrupted) {
            int handle = AsynchronousFileImpl.openFile((String)file.getAbsolutePath());
            if (handle < 0) {
                throw new IOException("couldn't open file " + file.getAbsolutePath());
            }
            FileLock lockFile = AsynchronousFileImpl.lock((int)handle);
            if (lockFile != null) {
                return lockFile;
            }
            AsynchronousFileImpl.closeFile((int)handle);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                return null;
            }
            if (this.lockAcquisitionTimeout == -1L || System.currentTimeMillis() - start <= this.lockAcquisitionTimeout) continue;
            throw new Exception("timed out waiting for lock");
        }
        return null;
    }

    protected File newFileForRegionLock(int liveLockPos) {
        File file = this.newFile("server." + liveLockPos + ".lock");
        return file;
    }
}

