/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.impl.QueueImpl;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperationAbstract;
import org.hornetq.core.transaction.impl.TransactionImpl;

public class RefsOperation
extends TransactionOperationAbstract {
    private final StorageManager storageManager;
    private Queue queue;
    List<MessageReference> refsToAck = new ArrayList<MessageReference>();
    List<ServerMessage> pagedMessagesToPostACK = null;
    protected boolean ignoreRedeliveryCheck = false;

    public RefsOperation(Queue queue, StorageManager storageManager) {
        this.queue = queue;
        this.storageManager = storageManager;
    }

    public void setIgnoreRedeliveryCheck() {
        this.ignoreRedeliveryCheck = true;
    }

    synchronized void addAck(MessageReference ref) {
        this.refsToAck.add(ref);
        if (ref.isPaged()) {
            if (this.pagedMessagesToPostACK == null) {
                this.pagedMessagesToPostACK = new ArrayList<ServerMessage>();
            }
            this.pagedMessagesToPostACK.add(ref.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterRollback(Transaction tx) {
        HashMap<QueueImpl, LinkedList<MessageReference>> queueMap = new HashMap<QueueImpl, LinkedList<MessageReference>>();
        long timeBase = System.currentTimeMillis();
        ArrayList<MessageReference> ackedRefs = new ArrayList<MessageReference>();
        for (MessageReference messageReference : this.refsToAck) {
            messageReference.setConsumerId(null);
            if (HornetQServerLogger.LOGGER.isTraceEnabled()) {
                HornetQServerLogger.LOGGER.trace("rolling back " + messageReference);
            }
            try {
                if (messageReference.isAlreadyAcked()) {
                    ackedRefs.add(messageReference);
                }
                if (!messageReference.getQueue().checkRedelivery(messageReference, timeBase, this.ignoreRedeliveryCheck)) continue;
                LinkedList<MessageReference> toCancel = (LinkedList<MessageReference>)queueMap.get(messageReference.getQueue());
                if (toCancel == null) {
                    toCancel = new LinkedList<MessageReference>();
                    queueMap.put((QueueImpl)messageReference.getQueue(), toCancel);
                }
                toCancel.addFirst(messageReference);
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.errorCheckingDLQ(e);
            }
        }
        for (Map.Entry entry : queueMap.entrySet()) {
            QueueImpl queue;
            LinkedList refs = (LinkedList)entry.getValue();
            QueueImpl queueImpl = queue = (QueueImpl)entry.getKey();
            synchronized (queueImpl) {
                queue.postRollback(refs);
            }
        }
        if (!ackedRefs.isEmpty()) {
            try {
                TransactionImpl ackedTX = new TransactionImpl(this.storageManager);
                for (MessageReference ref : ackedRefs) {
                    ServerMessage message = ref.getMessage();
                    if (message.isDurable()) {
                        int durableRefCount = message.incrementDurableRefCount();
                        if (durableRefCount == 1) {
                            this.storageManager.storeMessageTransactional(ackedTX.getID(), message);
                        }
                        Queue queue = ref.getQueue();
                        this.storageManager.storeReferenceTransactional(ackedTX.getID(), queue.getID(), message.getMessageID());
                        ackedTX.setContainsPersistent();
                    }
                    message.incrementRefCount();
                }
                ackedTX.commit(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterCommit(Transaction tx) {
        for (MessageReference ref : this.refsToAck) {
            Queue queue = ref.getQueue();
            synchronized (queue) {
                this.queue.postAcknowledge(ref);
            }
        }
        if (this.pagedMessagesToPostACK != null) {
            for (ServerMessage msg : this.pagedMessagesToPostACK) {
                try {
                    msg.decrementRefCount();
                }
                catch (Exception e) {
                    HornetQServerLogger.LOGGER.warn(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public synchronized List<MessageReference> getRelatedMessageReferences() {
        LinkedList<MessageReference> listRet = new LinkedList<MessageReference>();
        listRet.addAll(listRet);
        return listRet;
    }

    @Override
    public synchronized List<MessageReference> getListOnConsumer(long consumerID) {
        LinkedList<MessageReference> list = new LinkedList<MessageReference>();
        for (MessageReference ref : this.refsToAck) {
            if (ref.getConsumerId() == null || !ref.getConsumerId().equals(consumerID)) continue;
            list.add(ref);
        }
        return list;
    }

    public List<MessageReference> getReferencesToAcknowledge() {
        return this.refsToAck;
    }
}

