/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.HornetQServerLogger;
import org.hornetq.core.server.NodeManager;
import org.hornetq.core.server.QueueFactory;
import org.hornetq.core.server.cluster.ha.ScaleDownPolicy;
import org.hornetq.core.server.cluster.ha.SharedStoreSlavePolicy;
import org.hornetq.core.server.group.GroupingHandler;
import org.hornetq.core.server.impl.Activation;
import org.hornetq.core.server.impl.BackupRecoveryJournalLoader;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.core.server.impl.JournalLoader;
import org.hornetq.core.server.management.ManagementService;

public final class SharedStoreBackupActivation
extends Activation {
    private SharedStoreSlavePolicy sharedStoreSlavePolicy;
    private HornetQServerImpl hornetQServer;
    private final Object failbackCheckerGuard = new Object();
    private boolean cancelFailBackChecker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedStoreBackupActivation(HornetQServerImpl server, SharedStoreSlavePolicy sharedStoreSlavePolicy) {
        this.hornetQServer = server;
        this.sharedStoreSlavePolicy = sharedStoreSlavePolicy;
        Object object = this.failbackCheckerGuard;
        synchronized (object) {
            this.cancelFailBackChecker = false;
        }
    }

    @Override
    public void run() {
        try {
            boolean scalingDown;
            this.hornetQServer.getNodeManager().startBackup();
            boolean bl = scalingDown = this.sharedStoreSlavePolicy.getScaleDownPolicy() != null;
            if (!this.hornetQServer.initialisePart1(scalingDown)) {
                return;
            }
            this.hornetQServer.getBackupManager().start();
            this.hornetQServer.setState(HornetQServerImpl.SERVER_STATE.STARTED);
            HornetQServerLogger.LOGGER.backupServerStarted(this.hornetQServer.getVersion().getFullVersion(), this.hornetQServer.getNodeManager().getNodeId());
            this.hornetQServer.getNodeManager().awaitLiveNode();
            this.sharedStoreSlavePolicy.getSharedStoreMasterPolicy().setSharedStoreSlavePolicy(this.sharedStoreSlavePolicy);
            this.hornetQServer.setHAPolicy(this.sharedStoreSlavePolicy.getSharedStoreMasterPolicy());
            this.hornetQServer.getBackupManager().activated();
            if (this.hornetQServer.getState() != HornetQServerImpl.SERVER_STATE.STARTED) {
                return;
            }
            this.hornetQServer.initialisePart2(scalingDown);
            if (scalingDown) {
                HornetQServerLogger.LOGGER.backupServerScaledDown();
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SharedStoreBackupActivation.this.hornetQServer.stop();
                            if (SharedStoreBackupActivation.this.sharedStoreSlavePolicy.isRestartBackup()) {
                                SharedStoreBackupActivation.this.hornetQServer.start();
                            }
                        }
                        catch (Exception e) {
                            HornetQServerLogger.LOGGER.serverRestartWarning();
                        }
                    }
                });
                t.start();
                return;
            }
            HornetQServerLogger.LOGGER.backupServerIsLive();
            this.hornetQServer.getNodeManager().releaseBackup();
            if (this.sharedStoreSlavePolicy.isAllowAutoFailBack()) {
                this.startFailbackChecker();
            }
        }
        catch (InterruptedException e) {
        }
        catch (ClosedChannelException e) {
        }
        catch (Exception e) {
            if (!(e.getCause() instanceof InterruptedException)) {
                HornetQServerLogger.LOGGER.initializationError(e);
            }
        }
        catch (Throwable e) {
            HornetQServerLogger.LOGGER.initializationError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        if (!restarting) {
            Object object = this.failbackCheckerGuard;
            synchronized (object) {
                this.cancelFailBackChecker = true;
            }
        }
        NodeManager nodeManagerInUse = this.hornetQServer.getNodeManager();
        if (this.hornetQServer.getHAPolicy().isBackup()) {
            this.hornetQServer.interrupBackupThread(nodeManagerInUse);
            if (nodeManagerInUse != null) {
                nodeManagerInUse.stopBackup();
            }
        } else if (nodeManagerInUse != null) {
            if (this.sharedStoreSlavePolicy.isFailoverOnServerShutdown() || permanently) {
                nodeManagerInUse.crashLiveServer();
            } else {
                nodeManagerInUse.pauseLiveServer();
            }
        }
    }

    @Override
    public JournalLoader createJournalLoader(PostOffice postOffice, PagingManager pagingManager, StorageManager storageManager, QueueFactory queueFactory, NodeManager nodeManager, ManagementService managementService, GroupingHandler groupingHandler, Configuration configuration, HornetQServer parentServer) throws HornetQException {
        if (this.sharedStoreSlavePolicy.getScaleDownPolicy() != null) {
            return new BackupRecoveryJournalLoader(postOffice, pagingManager, storageManager, queueFactory, nodeManager, managementService, groupingHandler, configuration, parentServer, ScaleDownPolicy.getScaleDownConnector(this.sharedStoreSlavePolicy.getScaleDownPolicy(), this.hornetQServer), this.hornetQServer.getClusterManager().getClusterController());
        }
        return super.createJournalLoader(postOffice, pagingManager, storageManager, queueFactory, nodeManager, managementService, groupingHandler, configuration, parentServer);
    }

    private void startFailbackChecker() {
        this.hornetQServer.getScheduledPool().scheduleAtFixedRate(new FailbackChecker(), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private class FailbackChecker
    implements Runnable {
        private boolean restarting = false;

        private FailbackChecker() {
        }

        @Override
        public void run() {
            try {
                if (!this.restarting && SharedStoreBackupActivation.this.hornetQServer.getNodeManager().isAwaitingFailback()) {
                    HornetQServerLogger.LOGGER.awaitFailBack();
                    this.restarting = true;
                    Thread t = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                HornetQServerLogger.LOGGER.debug(SharedStoreBackupActivation.this.hornetQServer + "::Stopping live node in favor of failback");
                                SharedStoreBackupActivation.this.hornetQServer.stop(true, false, true);
                                Thread.sleep(SharedStoreBackupActivation.this.sharedStoreSlavePolicy.getFailbackDelay());
                                Object object = SharedStoreBackupActivation.this.failbackCheckerGuard;
                                synchronized (object) {
                                    if (SharedStoreBackupActivation.this.cancelFailBackChecker || !SharedStoreBackupActivation.this.sharedStoreSlavePolicy.isRestartBackup()) {
                                        return;
                                    }
                                    SharedStoreBackupActivation.this.hornetQServer.setHAPolicy(SharedStoreBackupActivation.this.sharedStoreSlavePolicy);
                                    HornetQServerLogger.LOGGER.debug(SharedStoreBackupActivation.this.hornetQServer + "::Starting backup node now after failback");
                                    SharedStoreBackupActivation.this.hornetQServer.start();
                                }
                            }
                            catch (Exception e) {
                                HornetQServerLogger.LOGGER.serverRestartWarning();
                            }
                        }
                    });
                    t.start();
                }
            }
            catch (Exception e) {
                HornetQServerLogger.LOGGER.serverRestartWarning(e);
            }
        }
    }
}

