/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.tools;

import org.hornetq.tools.PrintData;
import org.hornetq.tools.PrintPages;
import org.hornetq.tools.XmlDataExporter;
import org.hornetq.tools.XmlDataImporter;

public class Main {
    private static final String USAGE = "Use: java -jar " + Main.getJarName();
    private static final String IMPORT = "import";
    private static final String EXPORT = "export";
    private static final String PRINT_DATA = "print-data";
    private static final String PRINT_PAGES = "print-pages";
    private static final String OPTIONS = " [import|export|print-data|print-pages]";

    public static void main(String[] arg) throws Exception {
        if (arg.length == 0) {
            System.out.println(USAGE + OPTIONS);
            System.exit(-1);
        }
        if (EXPORT.equals(arg[0])) {
            if (arg.length != 5) {
                System.out.println(USAGE + " " + EXPORT + " <bindings-directory> <journal-directory> <paging-directory> <large-messages-directory>");
                System.exit(-1);
            } else {
                XmlDataExporter xmlDataExporter = new XmlDataExporter(System.out, arg[1], arg[2], arg[3], arg[4]);
                xmlDataExporter.writeXMLData();
            }
        } else if (IMPORT.equals(arg[0])) {
            if (arg.length != 6) {
                System.out.println(USAGE + " " + IMPORT + " <input-file> <host> <port> <transactional> <application-server-compatibility>");
                System.exit(-1);
            } else {
                XmlDataImporter xmlDataImporter = new XmlDataImporter(arg[1], arg[2], arg[3], Boolean.parseBoolean(arg[4]), Boolean.parseBoolean(arg[5]));
                xmlDataImporter.processXml();
            }
        } else if (PRINT_DATA.equals(arg[0])) {
            if (arg.length != 3) {
                System.err.println(USAGE + " " + PRINT_DATA + " <bindings-directory> <journal-directory>");
                System.exit(-1);
            }
            PrintData.printData(arg[1], arg[2]);
        } else if (PRINT_PAGES.equals(arg[0])) {
            if (arg.length != 3) {
                System.err.println(USAGE + " " + PRINT_PAGES + " <paging-directory> <journal-directory>");
                System.exit(-1);
            }
            PrintPages.printPages(arg[1], arg[2]);
        } else {
            System.out.println(USAGE + OPTIONS);
        }
    }

    protected static String getJarName() {
        Class<Main> klass = Main.class;
        String url = klass.getResource('/' + klass.getName().replace('.', '/') + ".class").toString();
        String jarName = url.substring(0, url.lastIndexOf(33));
        return jarName.substring(jarName.lastIndexOf(47) + 1);
    }
}

