/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.packet;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.EntityJid;

public class MUCUser
implements ExtensionElement {
    public static final String ELEMENT = "x";
    public static final String NAMESPACE = "http://jabber.org/protocol/muc#user";
    private final Set<Status> statusCodes = new HashSet<Status>(4);
    private Invite invite;
    private Decline decline;
    private MUCItem item;
    private String password;
    private Destroy destroy;

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML(String enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this);
        xml.rightAngleBracket();
        xml.optElement((Element)this.getInvite());
        xml.optElement((Element)this.getDecline());
        xml.optElement((Element)this.getItem());
        xml.optElement("password", this.getPassword());
        xml.append(this.statusCodes);
        xml.optElement((Element)this.getDestroy());
        xml.closeElement((NamedElement)this);
        return xml;
    }

    public Invite getInvite() {
        return this.invite;
    }

    public Decline getDecline() {
        return this.decline;
    }

    public MUCItem getItem() {
        return this.item;
    }

    public String getPassword() {
        return this.password;
    }

    public Set<Status> getStatus() {
        return this.statusCodes;
    }

    public boolean hasStatus() {
        return !this.statusCodes.isEmpty();
    }

    public Destroy getDestroy() {
        return this.destroy;
    }

    public void setInvite(Invite invite) {
        this.invite = invite;
    }

    public void setDecline(Decline decline) {
        this.decline = decline;
    }

    public void setItem(MUCItem item) {
        this.item = item;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void addStatusCodes(Set<Status> statusCodes) {
        this.statusCodes.addAll(statusCodes);
    }

    public void addStatusCode(Status status) {
        this.statusCodes.add(status);
    }

    public void setDestroy(Destroy destroy) {
        this.destroy = destroy;
    }

    @Deprecated
    public static MUCUser getFrom(Stanza packet) {
        return MUCUser.from(packet);
    }

    public static MUCUser from(Stanza packet) {
        return (MUCUser)packet.getExtension(ELEMENT, NAMESPACE);
    }

    public static final class Status
    implements NamedElement {
        public static final String ELEMENT = "status";
        private static final Map<Integer, Status> statusMap = new HashMap<Integer, Status>(8);
        public static final Status PRESENCE_TO_SELF_110 = Status.create(110);
        public static final Status ROOM_CREATED_201 = Status.create(201);
        public static final Status BANNED_301 = Status.create(301);
        public static final Status NEW_NICKNAME_303 = Status.create(303);
        public static final Status KICKED_307 = Status.create(307);
        public static final Status REMOVED_AFFIL_CHANGE_321 = Status.create(321);
        private final Integer code;

        public static Status create(String string) {
            Integer integer = Integer.valueOf(string);
            return Status.create(integer);
        }

        public static Status create(Integer i) {
            Status status = statusMap.get(i);
            if (status == null) {
                status = new Status(i);
                statusMap.put(i, status);
            }
            return status;
        }

        private Status(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public XmlStringBuilder toXML(String enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
            xml.attribute("code", this.getCode());
            xml.closeEmptyElement();
            return xml;
        }

        public String toString() {
            return this.code.toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof Status) {
                Status otherStatus = (Status)other;
                return this.code.equals(otherStatus.getCode());
            }
            return false;
        }

        public int hashCode() {
            return this.code;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Decline
    implements NamedElement {
        public static final String ELEMENT = "decline";
        private final String reason;
        private final EntityBareJid from;
        private final EntityBareJid to;

        public Decline(String reason, EntityBareJid to) {
            this(reason, null, to);
        }

        public Decline(String reason, EntityBareJid from, EntityBareJid to) {
            this.reason = reason;
            this.from = from;
            this.to = to;
        }

        public EntityBareJid getFrom() {
            return this.from;
        }

        public String getReason() {
            return this.reason;
        }

        public EntityBareJid getTo() {
            return this.to;
        }

        public XmlStringBuilder toXML(String enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
            xml.optAttribute("to", (CharSequence)this.getTo());
            xml.optAttribute("from", (CharSequence)this.getFrom());
            xml.rightAngleBracket();
            xml.optElement("reason", this.getReason());
            xml.closeElement((NamedElement)this);
            return xml;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Invite
    implements NamedElement {
        public static final String ELEMENT = "invite";
        private final String reason;
        private final EntityJid from;
        private final EntityBareJid to;

        public Invite(String reason, EntityFullJid from) {
            this(reason, (EntityJid)from, null);
        }

        public Invite(String reason, EntityBareJid to) {
            this(reason, null, to);
        }

        public Invite(String reason, EntityJid from, EntityBareJid to) {
            this.reason = reason;
            this.from = from;
            this.to = to;
        }

        public EntityJid getFrom() {
            return this.from;
        }

        public String getReason() {
            return this.reason;
        }

        public EntityBareJid getTo() {
            return this.to;
        }

        public XmlStringBuilder toXML(String enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
            xml.optAttribute("to", (CharSequence)this.getTo());
            xml.optAttribute("from", (CharSequence)this.getFrom());
            xml.rightAngleBracket();
            xml.optElement("reason", this.getReason());
            xml.closeElement((NamedElement)this);
            return xml;
        }

        public String getElementName() {
            return ELEMENT;
        }
    }
}

