/*
 * Decompiled with CFR 0.152.
 */
package org.impalaframework.osgi.test;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.impalaframework.exception.InvalidStateException;
import org.impalaframework.module.ModuleDefinitionSource;
import org.impalaframework.module.RootModuleDefinition;
import org.impalaframework.util.ObjectUtils;
import org.impalaframework.util.serialize.ClassLoaderAwareSerializationStreamFactory;
import org.impalaframework.util.serialize.SerializationHelper;
import org.impalaframework.util.serialize.SerializationStreamFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.util.BundleDelegatingClassLoader;

public class InjectableModuleDefinitionSource
implements ModuleDefinitionSource {
    private static Log logger = LogFactory.getLog(InjectableModuleDefinitionSource.class);
    private RootModuleDefinition rootModuleDefinition;
    private BundleContext bundleContext;

    public InjectableModuleDefinitionSource(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void inject(Object o) {
        if (o == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Capturing root module definition from " + o));
        }
        if (!(o instanceof Serializable)) {
            throw new InvalidStateException("Attempting to inject non-serializable module definition class '" + o.getClass().getName() + "'");
        }
        Object clone = this.clone(o);
        try {
            this.rootModuleDefinition = (RootModuleDefinition)ObjectUtils.cast((Object)clone, RootModuleDefinition.class);
        }
        catch (ClassCastException e) {
            logger.error((Object)("Error converting to root module definition object " + o + " with class loader " + o.getClass().getClassLoader()));
            throw e;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Captured root module definition " + this.rootModuleDefinition));
        }
    }

    Object clone(Object o) {
        BundleDelegatingClassLoader classLoader = BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)this.bundleContext.getBundle());
        SerializationStreamFactory streamFactory = this.newStreamFactory((ClassLoader)classLoader);
        SerializationHelper helper = new SerializationHelper(streamFactory);
        Object clone = helper.clone((Serializable)o);
        return clone;
    }

    SerializationStreamFactory newStreamFactory(ClassLoader classLoader) {
        return new ClassLoaderAwareSerializationStreamFactory(classLoader);
    }

    public RootModuleDefinition getModuleDefinition() {
        return this.rootModuleDefinition;
    }
}

