/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.hotrod.impl.counter.operation.BaseCounterOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class SetOperation
extends BaseCounterOperation<Long> {
    private static final Log commonsLog = (Log)LogFactory.getLog(SetOperation.class, Log.class);
    private final long value;

    public SetOperation(OperationContext operationContext, String counterName, long value, boolean useConsistentHash) {
        super(operationContext, (short)127, (short)128, counterName, useConsistentHash);
        this.value = value;
    }

    @Override
    protected void executeOperation(Channel channel) {
        ByteBuf buf = this.getHeaderAndCounterNameBufferAndRead(channel, 8);
        buf.writeLong(this.value);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        this.checkStatus(status);
        this.assertBoundaries(status);
        assert (status == 0);
        this.complete(buf.readLong());
    }

    private void assertBoundaries(short status) {
        if (status == 4) {
            if (this.value > 0L) {
                throw commonsLog.counterOurOfBounds("Upper bound");
            }
            throw commonsLog.counterOurOfBounds("Lower bound");
        }
    }
}

