/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transport.netty;

import io.netty.buffer.ByteBuf;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;

public class Intrinsics {
    public static int vInt(ByteBuf buf) {
        return ByteBufUtil.readMaybeVInt(buf);
    }

    public static long vLong(ByteBuf buf) {
        buf.markReaderIndex();
        if (buf.readableBytes() > 0) {
            byte b = buf.readByte();
            long i = b & 0x7F;
            int shift = 7;
            while ((b & 0x80) != 0) {
                if (buf.readableBytes() == 0) {
                    buf.resetReaderIndex();
                    return Long.MIN_VALUE;
                }
                b = buf.readByte();
                i |= ((long)b & 0x7FL) << shift;
                shift += 7;
            }
            return i;
        }
        buf.resetReaderIndex();
        return Long.MIN_VALUE;
    }

    public static long long_(ByteBuf buf) {
        if (buf.readableBytes() >= 8) {
            return buf.readLong();
        }
        return 0L;
    }

    public static byte byte_(ByteBuf buffer) {
        if (buffer.isReadable()) {
            return buffer.readByte();
        }
        return 0;
    }

    public static short uByte(ByteBuf buffer) {
        if (buffer.isReadable()) {
            return buffer.readUnsignedByte();
        }
        return 0;
    }

    public static short vShort(ByteBuf buffer) {
        if (buffer.readableBytes() >= 2) {
            return buffer.readShort();
        }
        return 0;
    }

    public static int uShort(ByteBuf buf) {
        if (buf.readableBytes() >= 2) {
            return buf.readUnsignedShort();
        }
        return 0;
    }

    public static byte[] array(ByteBuf buf) {
        buf.markReaderIndex();
        return ByteBufUtil.readMaybeArray(buf);
    }

    public static String string(ByteBuf buf) {
        return ByteBufUtil.readString(buf);
    }
}

