/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.cache.CacheManager;
import javax.cache.spi.CachingProvider;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.jcache.AbstractJCache;
import org.infinispan.jcache.AbstractJCacheManager;
import org.infinispan.jcache.embedded.ConfigurationAdapter;
import org.infinispan.jcache.embedded.JCache;
import org.infinispan.jcache.embedded.SecurityActions;
import org.infinispan.jcache.embedded.logging.Log;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.util.logging.LogFactory;

public class JCacheManager
extends AbstractJCacheManager {
    private static final Log log = (Log)LogFactory.getLog(JCacheManager.class, Log.class);
    public static final String CACHE_CONFIGURATION_FUNCTION = Configuration.class.getName() + "-Function";
    public static final String GLOBAL_CONFIGURATION_CONSUMER = GlobalConfigurationBuilder.class.getName() + "-Consumer";
    private final EmbeddedCacheManager cm;
    private final InternalCacheRegistry icr;

    public JCacheManager(URI uri, ClassLoader classLoader, CachingProvider provider, Properties properties) {
        super(uri, classLoader, provider, properties, false);
        if (classLoader == null) {
            throw new IllegalArgumentException("Classloader cannot be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Invalid CacheManager URI " + uri);
        }
        ConfigurationBuilderHolder cbh = properties != null && properties.containsKey(ConfigurationBuilderHolder.class.getName()) ? (ConfigurationBuilderHolder)properties.get(ConfigurationBuilderHolder.class.getName()) : (properties != null && properties.containsKey(GlobalConfigurationBuilder.class.getName()) ? new ConfigurationBuilderHolder(classLoader, (GlobalConfigurationBuilder)properties.get(GlobalConfigurationBuilder.class.getName())) : new ConfigurationBuilderHolder(classLoader));
        this.loadConfigurationFromURI(cbh);
        GlobalConfigurationBuilder globalBuilder = cbh.getGlobalConfigurationBuilder();
        if (properties != null && properties.containsKey(GLOBAL_CONFIGURATION_CONSUMER)) {
            Consumer consumer = (Consumer)properties.get(GLOBAL_CONFIGURATION_CONSUMER);
            consumer.accept(globalBuilder);
        }
        String cacheManagerName = "uri=" + uri + "/classloader=" + classLoader.toString() + "/provider=" + provider.toString();
        globalBuilder.classLoader(classLoader).cacheManagerName(cacheManagerName).cacheContainer().statistics(true).jmx().enabled(true);
        this.cm = new DefaultCacheManager(cbh, true);
        this.icr = (InternalCacheRegistry)SecurityActions.getGlobalComponentRegistry(this.cm).getComponent(InternalCacheRegistry.class);
        this.registerPredefinedCaches();
    }

    public JCacheManager(URI uri, EmbeddedCacheManager cacheManager, CachingProvider provider) {
        super(uri, null, provider, null, true);
        this.cm = cacheManager;
        this.icr = (InternalCacheRegistry)SecurityActions.getGlobalComponentRegistry(this.cm).getComponent(InternalCacheRegistry.class);
        this.registerPredefinedCaches();
    }

    private void registerPredefinedCaches() {
        Set cacheNames = this.cm.getCacheNames();
        for (String cacheName : cacheNames) {
            if (this.icr.isInternalCache(cacheName)) continue;
            this.registerPredefinedCache(cacheName, new JCache(this.cm.getCache(cacheName).getAdvancedCache(), (CacheManager)this, ConfigurationAdapter.create()));
        }
    }

    private void loadConfigurationFromURI(ConfigurationBuilderHolder cbh) {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        try (InputStream configurationStream = this.getURI().isAbsolute() ? fileLookup.lookupFileStrict(this.getURI(), cbh.getClassLoader()) : fileLookup.lookupFileStrict(this.getURI().toString(), cbh.getClassLoader());){
            Properties properties = new Properties(System.getProperties());
            if (this.properties != null) {
                properties.putAll((Map<?, ?>)this.properties);
            }
            new ParserRegistry(cbh.getClassLoader(), false, properties).parse(configurationStream, cbh, null, MediaType.fromExtension((String)this.getURI().toString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)ReflectionUtil.unwrapAny(clazz, (Object[])new Object[]{this, this.cm});
    }

    public ClassLoader getClassLoader() {
        return this.cm.getCacheManagerConfiguration().classLoader();
    }

    protected void delegateLogIsClosed() {
        throw log.cacheManagerClosed(this.cm.getStatus());
    }

    protected void delegateStop() {
        this.cm.stop();
    }

    protected Iterable<String> delegateCacheNames() {
        HashSet<String> cacheNames = new HashSet<String>();
        for (String cacheName : this.cm.getCacheNames()) {
            if (this.icr.isInternalCache(cacheName)) continue;
            cacheNames.add(cacheName);
        }
        return Collections.unmodifiableSet(cacheNames);
    }

    protected boolean delegateIsClosed() {
        return this.cm.getStatus().isTerminated();
    }

    protected <K, V> void delegateRemoveCache(AbstractJCache<K, V> jcache) {
        String cacheName = jcache.getName();
        this.cm.administration().removeCache(cacheName);
    }

    protected <K, V, C extends javax.cache.configuration.Configuration<K, V>> AbstractJCache<K, V> create(String cacheName, C configuration) {
        this.checkNotInternalCache(cacheName);
        Configuration baseConfig = null;
        if (this.properties != null && this.properties.containsKey(CACHE_CONFIGURATION_FUNCTION)) {
            Function f = (Function)this.properties.get(CACHE_CONFIGURATION_FUNCTION);
            baseConfig = (Configuration)f.apply(cacheName);
        }
        if (baseConfig == null) {
            baseConfig = this.cm.getCacheConfiguration(cacheName);
        }
        ConfigurationAdapter adapter = ConfigurationAdapter.create(configuration);
        this.cm.defineConfiguration(cacheName, adapter.build(baseConfig));
        AdvancedCache ispnCache = this.cm.getCache(cacheName).getAdvancedCache();
        if (!ispnCache.getStatus().allowInvocations()) {
            ispnCache.start();
        }
        return new JCache(ispnCache, (CacheManager)this, adapter);
    }

    protected <K, V, I extends BasicCache<K, V>> AbstractJCache<K, V> create(I ispnCache) {
        this.checkNotInternalCache(ispnCache.getName());
        return new JCache((AdvancedCache)ispnCache, (CacheManager)this, ConfigurationAdapter.create());
    }

    private void checkNotInternalCache(String cacheName) {
        if (this.icr.isInternalCache(cacheName)) {
            throw new IllegalArgumentException("Cache name " + cacheName + "is not allowed as it clashes with an internal cache");
        }
    }
}

