/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.CacheValue;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.jcache.annotation.AggregatedParameterMetaData;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextImpl;
import org.infinispan.jcache.annotation.CacheLookupHelper;
import org.infinispan.jcache.annotation.CollectionsHelper;
import org.infinispan.jcache.annotation.Contracts;
import org.infinispan.jcache.annotation.MethodMetaData;
import org.infinispan.jcache.annotation.ParameterMetaData;
import org.infinispan.jcache.logging.Log;
import org.infinispan.util.KeyValuePair;

@ApplicationScoped
public class CacheKeyInvocationContextFactory {
    private static final Log log = (Log)LogFactory.getLog(CacheKeyInvocationContextFactory.class, Log.class);
    private BeanManager beanManager;
    private ConcurrentMap<KeyValuePair<Method, Class<?>>, MethodMetaData<? extends Annotation>> methodMetaDataCache;

    @Inject
    public CacheKeyInvocationContextFactory(BeanManager beanManager) {
        this.beanManager = beanManager;
        this.methodMetaDataCache = new ConcurrentHashMap();
    }

    protected CacheKeyInvocationContextFactory() {
    }

    public <A extends Annotation> CacheKeyInvocationContextImpl<A> getCacheKeyInvocationContext(InvocationContext invocationContext) {
        Contracts.assertNotNull(invocationContext, "invocationContext parameter must not be null");
        MethodMetaData<? extends Annotation> methodMetaData = this.getMethodMetaData(invocationContext.getMethod(), invocationContext.getTarget().getClass());
        return new CacheKeyInvocationContextImpl<Annotation>(invocationContext, methodMetaData);
    }

    private MethodMetaData<? extends Annotation> getMethodMetaData(Method method, Class<?> targetClass) {
        KeyValuePair methodKey = new KeyValuePair((Object)method, targetClass);
        MethodMetaData<CacheResult> methodMetaData = (MethodMetaData<CacheResult>)this.methodMetaDataCache.get(methodKey);
        if (methodMetaData == null) {
            MethodMetaData<CacheResult> newMethodMetaData;
            String exceptionCacheName;
            CacheResult cacheAnnotation;
            AggregatedParameterMetaData aggregatedParameterMetaData;
            String cacheName;
            CacheResolverFactory cacheResolverFactory;
            CacheKeyGenerator cacheKeyGenerator;
            CacheDefaults cacheDefaultsAnnotation = this.getCacheDefaults(targetClass);
            if (method.isAnnotationPresent(CacheResult.class)) {
                CacheResult cacheResultAnnotation = method.getAnnotation(CacheResult.class);
                cacheKeyGenerator = CacheLookupHelper.getCacheKeyGenerator(this.beanManager, cacheResultAnnotation.cacheKeyGenerator(), cacheDefaultsAnnotation);
                cacheResolverFactory = CacheLookupHelper.getCacheResolverFactory(this.beanManager, cacheResultAnnotation.cacheResolverFactory(), cacheDefaultsAnnotation);
                cacheName = CacheLookupHelper.getCacheName(method, cacheResultAnnotation.cacheName(), cacheDefaultsAnnotation, true);
                aggregatedParameterMetaData = this.getAggregatedParameterMetaData(method, false);
                cacheAnnotation = cacheResultAnnotation;
            } else if (method.isAnnotationPresent(CacheRemove.class)) {
                CacheRemove cacheRemoveEntryAnnotation = method.getAnnotation(CacheRemove.class);
                cacheKeyGenerator = CacheLookupHelper.getCacheKeyGenerator(this.beanManager, cacheRemoveEntryAnnotation.cacheKeyGenerator(), cacheDefaultsAnnotation);
                cacheResolverFactory = CacheLookupHelper.getCacheResolverFactory(this.beanManager, cacheRemoveEntryAnnotation.cacheResolverFactory(), cacheDefaultsAnnotation);
                cacheName = CacheLookupHelper.getCacheName(method, cacheRemoveEntryAnnotation.cacheName(), cacheDefaultsAnnotation, false);
                aggregatedParameterMetaData = this.getAggregatedParameterMetaData(method, false);
                cacheAnnotation = cacheRemoveEntryAnnotation;
                if (cacheName.isEmpty()) {
                    throw log.cacheRemoveEntryMethodWithoutCacheName(method.getName());
                }
            } else if (method.isAnnotationPresent(CacheRemoveAll.class)) {
                CacheRemoveAll cacheRemoveAllAnnotation = method.getAnnotation(CacheRemoveAll.class);
                cacheKeyGenerator = null;
                cacheResolverFactory = CacheLookupHelper.getCacheResolverFactory(this.beanManager, cacheRemoveAllAnnotation.cacheResolverFactory(), cacheDefaultsAnnotation);
                cacheName = CacheLookupHelper.getCacheName(method, cacheRemoveAllAnnotation.cacheName(), cacheDefaultsAnnotation, false);
                aggregatedParameterMetaData = this.getAggregatedParameterMetaData(method, false);
                cacheAnnotation = cacheRemoveAllAnnotation;
                if (cacheName.isEmpty()) {
                    throw log.cacheRemoveAllMethodWithoutCacheName(method.getName());
                }
            } else if (method.isAnnotationPresent(CachePut.class)) {
                CachePut cachePutAnnotation = method.getAnnotation(CachePut.class);
                cacheKeyGenerator = CacheLookupHelper.getCacheKeyGenerator(this.beanManager, cachePutAnnotation.cacheKeyGenerator(), cacheDefaultsAnnotation);
                cacheResolverFactory = CacheLookupHelper.getCacheResolverFactory(this.beanManager, cachePutAnnotation.cacheResolverFactory(), cacheDefaultsAnnotation);
                cacheName = CacheLookupHelper.getCacheName(method, cachePutAnnotation.cacheName(), cacheDefaultsAnnotation, true);
                aggregatedParameterMetaData = this.getAggregatedParameterMetaData(method, true);
                cacheAnnotation = cachePutAnnotation;
            } else {
                throw log.methodWithoutCacheAnnotation(method.getName());
            }
            MethodMetaData<CacheResult> tmpMethodMetaData = new MethodMetaData<CacheResult>(method, aggregatedParameterMetaData, CollectionsHelper.asSet(method.getAnnotations()), cacheKeyGenerator, null, null, cacheAnnotation, cacheName);
            CacheResolver cacheResolver = null;
            if (cacheResolverFactory != null) {
                cacheResolver = cacheResolverFactory.getCacheResolver(tmpMethodMetaData);
            }
            CacheResolver exceptionCacheResolver = null;
            if (cacheResolverFactory != null && cacheAnnotation instanceof CacheResult && (exceptionCacheName = cacheAnnotation.exceptionCacheName()).trim().length() != 0) {
                exceptionCacheResolver = cacheResolverFactory.getExceptionCacheResolver(tmpMethodMetaData);
            }
            if ((methodMetaData = this.methodMetaDataCache.putIfAbsent(methodKey, newMethodMetaData = new MethodMetaData<CacheResult>(method, aggregatedParameterMetaData, CollectionsHelper.asSet(method.getAnnotations()), cacheKeyGenerator, cacheResolver, exceptionCacheResolver, cacheAnnotation, cacheName))) == null) {
                methodMetaData = newMethodMetaData;
            }
        }
        return methodMetaData;
    }

    private CacheDefaults getCacheDefaults(Class<?> targetClass) {
        CacheDefaults cacheDefaultsAnnotation = null;
        for (Class<?> clazz = targetClass; cacheDefaultsAnnotation == null && clazz != null; clazz = clazz.getSuperclass()) {
            cacheDefaultsAnnotation = clazz.getAnnotation(CacheDefaults.class);
        }
        return cacheDefaultsAnnotation;
    }

    private AggregatedParameterMetaData getAggregatedParameterMetaData(Method method, boolean cacheValueAllowed) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<ParameterMetaData> parameters = new ArrayList<ParameterMetaData>();
        ArrayList<ParameterMetaData> keyParameters = new ArrayList<ParameterMetaData>();
        ParameterMetaData valueParameter = null;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Set<Annotation> annotations = CollectionsHelper.asSet(parameterAnnotations[i]);
            ParameterMetaData parameterMetaData = new ParameterMetaData(parameterTypes[i], i, annotations);
            for (Annotation oneAnnotation : annotations) {
                Class<? extends Annotation> type = oneAnnotation.annotationType();
                if (CacheKey.class.equals(type)) {
                    keyParameters.add(parameterMetaData);
                    continue;
                }
                if (!cacheValueAllowed || !CacheValue.class.equals(type)) continue;
                if (valueParameter != null) {
                    throw log.cachePutMethodWithMoreThanOneCacheValueParameter(method.getName());
                }
                valueParameter = parameterMetaData;
            }
            parameters.add(parameterMetaData);
        }
        if (cacheValueAllowed && valueParameter == null) {
            if (parameters.size() > 1) {
                throw log.cachePutMethodWithoutCacheValueParameter(method.getName());
            }
            valueParameter = (ParameterMetaData)parameters.get(0);
        }
        if (keyParameters.isEmpty()) {
            keyParameters.addAll(parameters);
        }
        if (valueParameter != null && keyParameters.size() > 1) {
            keyParameters.remove(valueParameter);
        }
        return new AggregatedParameterMetaData(parameters, keyParameters, valueParameter);
    }
}

