/*
 * Decompiled with CFR 0.152.
 */
package org.infinitest.toolkit;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComparabilityTestSupport<T extends Comparable<T>> {
    private T less;
    private T equal1;
    private T equal2;
    private T greater;

    protected abstract T less() throws Exception;

    protected abstract T equal() throws Exception;

    protected abstract T greater() throws Exception;

    @Before
    public final void initializeHarness() throws Exception {
        this.less = this.less();
        this.equal1 = this.equal();
        this.equal2 = this.equal();
        this.greater = this.greater();
        Assert.assertNotNull((String)"createLessInstance() returned null", this.less);
        Assert.assertNotNull((String)"createEqualInstance() returned null", this.equal1);
        Assert.assertNotNull((String)"2nd createEqualInstance() returned null", this.equal2);
        Assert.assertNotNull((String)"createGreaterInstance() returned null", this.greater);
        Assert.assertEquals((String)"less and equal1 of different classes", this.less.getClass(), this.equal1.getClass());
        Assert.assertEquals((String)"less and equal2 of different classes", this.less.getClass(), this.equal2.getClass());
        Assert.assertEquals((String)"less and greater of different classes", this.less.getClass(), this.greater.getClass());
        this.checkForEquality(this.equal1, this.equal2);
    }

    protected void checkForEquality(T first, T second) {
        Assert.assertNotSame((String)"1st equal instance same as 2nd", first, second);
        Assert.assertEquals((String)"1st equal not equal to 2nd", first, second);
    }

    @Test
    public final void reverseOfComparisonShouldGiveResultOfOppositeSign() {
        Assert.assertEquals((String)"less vs. equal1", (double)Math.signum(this.less.compareTo(this.equal1)), (double)(-Math.signum(this.equal1.compareTo(this.less))), (double)0.0);
        Assert.assertEquals((String)"less vs. equal2", (double)Math.signum(this.less.compareTo(this.equal2)), (double)(-Math.signum(this.equal2.compareTo(this.less))), (double)0.0);
        Assert.assertEquals((String)"less vs. greater", (double)Math.signum(this.less.compareTo(this.greater)), (double)(-Math.signum(this.greater.compareTo(this.less))), (double)0.0);
        Assert.assertEquals((String)"equal1 vs. equal2", (double)Math.signum(this.equal1.compareTo(this.equal2)), (double)(-Math.signum(this.equal2.compareTo(this.equal1))), (double)0.0);
        Assert.assertEquals((String)"equal1 vs. greater", (double)Math.signum(this.equal1.compareTo(this.greater)), (double)(-Math.signum(this.greater.compareTo(this.equal1))), (double)0.0);
        Assert.assertEquals((String)"equal2 vs. greater", (double)Math.signum(this.equal2.compareTo(this.greater)), (double)(-Math.signum(this.greater.compareTo(this.equal2))), (double)0.0);
    }

    @Test
    public final void twoObjectsWhichCompareLikeToAnotherObjectShouldGiveResultOfSameSign() {
        Assert.assertEquals((String)"equal vs. less", (double)Math.signum(this.equal1.compareTo(this.less)), (double)Math.signum(this.equal2.compareTo(this.less)), (double)0.0);
        Assert.assertEquals((String)"equal vs. greater", (double)Math.signum(this.equal1.compareTo(this.greater)), (double)Math.signum(this.equal2.compareTo(this.greater)), (double)0.0);
    }

    @Test
    public final void comparisonShouldGiveCorrectRelativeValue() {
        Assert.assertThat(this.less, (Matcher)Matchers.lessThan(this.equal1));
        Assert.assertThat(this.less, (Matcher)Matchers.lessThan(this.equal2));
        Assert.assertThat(this.greater, (Matcher)Matchers.greaterThan(this.less));
        Assert.assertEquals((long)0L, (long)this.equal1.compareTo(this.equal2));
        Assert.assertThat(this.greater, (Matcher)Matchers.greaterThan(this.equal1));
        Assert.assertThat(this.greater, (Matcher)Matchers.greaterThan(this.equal2));
    }
}

