/*
 * Decompiled with CFR 0.152.
 */
package org.infinitest.toolkit;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.SerializationUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.infinitest.toolkit.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoldenMaster {
    private final File directory;

    private GoldenMaster(File aDirectory) {
        if (!aDirectory.exists()) {
            throw new IllegalArgumentException(aDirectory + " does not exist");
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException(aDirectory + " is not a directory");
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException(aDirectory + " cannot be read");
        }
        if (!aDirectory.canWrite()) {
            throw new IllegalArgumentException(aDirectory + " cannot be written to");
        }
        this.directory = aDirectory;
    }

    public static GoldenMaster at(String directoryPath) {
        return GoldenMaster.at(new File(directoryPath));
    }

    public static GoldenMaster at(File aDirectory) {
        return new GoldenMaster(aDirectory);
    }

    public Matcher<Serializable> approving() {
        final Key key = this.makeKey();
        return new BaseMatcher<Serializable>(){

            public boolean matches(Object target) {
                try {
                    GoldenMaster.this.add(key, (Serializable)target);
                    return false;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }

            public void describeTo(Description description) {
                description.appendText("Manually verify that the recorded golden master for key [").appendValue((Object)key).appendText("] meets your expectations.").appendText(" Change the approving() call to approved() when you are satisfied.");
            }
        };
    }

    public Matcher<Serializable> approved() throws IOException {
        final Key key = this.makeKey();
        final Object master = this.get(key);
        return new BaseMatcher<Serializable>(){

            public boolean matches(Object target) {
                if (master == null) {
                    return false;
                }
                return master.getClass().isArray() ? ArrayUtils.arraysAreEqual(target, master) : ObjectUtils.equals((Object)target, (Object)master);
            }

            public void describeTo(Description description) {
                if (master == null) {
                    description.appendText("that there be a golden master for key [").appendValue((Object)key).appendText("]");
                } else {
                    description.appendText("a string that matches the golden master for key [").appendValue((Object)key).appendText("], namely: [").appendValue(master).appendText("]");
                }
            }
        };
    }

    void reset() throws IOException {
        FileUtils.cleanDirectory((File)this.directory);
    }

    Key key() {
        return new Key(this.directory, new Throwable().getStackTrace()[1]);
    }

    private Key makeKey() {
        return new Key(this.directory, new Throwable().getStackTrace()[2]);
    }

    private Object get(Key key) throws IOException {
        File file = key.toFile();
        if (!file.exists()) {
            return null;
        }
        byte[] pickled = FileUtils.readFileToByteArray((File)file);
        return SerializationUtils.deserialize((byte[])pickled);
    }

    private void add(Key key, Serializable master) throws IOException {
        byte[] pickled = SerializationUtils.serialize((Serializable)master);
        FileUtils.writeByteArrayToFile((File)key.toFile(), (byte[])pickled);
    }

    public static class Key {
        private final File root;
        private final String className;
        private final String methodName;

        Key(File root, StackTraceElement caller) {
            this.root = root;
            this.className = caller.getClassName().replace('.', File.separatorChar);
            this.methodName = caller.getMethodName();
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || !this.getClass().equals(that.getClass())) {
                return false;
            }
            Key other = (Key)that;
            return this.root.equals(other.root) && this.className.equals(other.className) && this.methodName.equals(other.methodName);
        }

        public int hashCode() {
            return this.root.hashCode() ^ this.className.hashCode() ^ this.methodName.hashCode();
        }

        public String toString() {
            return this.root.getAbsolutePath() + File.separatorChar + this.className + File.separatorChar + this.methodName;
        }

        File toFile() {
            File dir = new File(this.root, this.className);
            dir.mkdirs();
            return new File(dir, this.methodName);
        }
    }
}

