/*
 * Decompiled with CFR 0.152.
 */
package org.infinitest.toolkit;

import java.util.ArrayList;
import java.util.Collection;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SameContentsMatcher
extends BaseMatcher<Collection<?>> {
    private final Collection<?> comparand;

    SameContentsMatcher(Collection<?> comparand) {
        this.comparand = comparand;
    }

    public boolean matches(Object target) {
        if (target == null) {
            return this.comparand == null;
        }
        return target instanceof Collection && SameContentsMatcher.haveSameContents((Collection)target, this.comparand);
    }

    public void describeTo(Description description) {
        description.appendText("a collection that has the same contents as ").appendValue(this.comparand);
    }

    private static boolean haveSameContents(Collection<?> first, Collection<?> second) {
        if (second == null) {
            return false;
        }
        if (first.size() != second.size()) {
            return false;
        }
        ArrayList copyOfFirst = new ArrayList(first);
        for (Object each : second) {
            copyOfFirst.remove(each);
        }
        return copyOfFirst.isEmpty();
    }
}

