/*
 * Decompiled with CFR 0.152.
 */
package org.infinitest.toolkit;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StrictCloneabilityTestSupport<T extends Cloneable> {
    private T original;
    private T copy;
    private final Set<Class<?>> immutableClasses = new HashSet();

    @Before
    public final void initializeHarness() throws Exception {
        this.original = this.instance();
        Assert.assertNotNull((String)"instance() returned null", this.original);
        this.copy = this.copy(this.original);
        this.immutableClasses.addAll(this.coreImmutableClasses());
        this.immutableClasses.addAll(this.classesToTreatAsImmutable());
    }

    @Test
    public final void copyShouldBeOfSameClassAsOriginal() {
        Assert.assertEquals(this.original.getClass(), this.copy.getClass());
    }

    @Test
    public final void copyShouldNotBeIdenticalToOriginal() {
        Assert.assertNotSame(this.original, this.copy);
    }

    @Test
    public final void copyShouldBeEquivalentToOriginal() {
        Assert.assertEquals(this.original, this.copy);
    }

    @Test
    public final void copyShouldHaveObjectFieldsWhichAreNotSameAsOriginal() throws Exception {
        for (Class<?> clazz = this.original.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            this.compareFieldsFrom(clazz);
        }
    }

    protected abstract T instance() throws Exception;

    protected abstract T copy(T var1) throws Exception;

    protected Collection<Class<?>> classesToTreatAsImmutable() {
        return Collections.emptySet();
    }

    private boolean isImmutable(Class<?> fieldClass) {
        return fieldClass.isPrimitive() || this.immutableClasses.contains(fieldClass);
    }

    private Set<Class<?>> coreImmutableClasses() {
        HashSet immutables = new HashSet();
        Collections.addAll(immutables, String.class, Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class, BigInteger.class, BigDecimal.class);
        return immutables;
    }

    private void compareFieldsFrom(Class<?> clazz) throws Exception {
        for (Field each : clazz.getDeclaredFields()) {
            this.compareField(each);
        }
    }

    private void compareField(Field field) throws Exception {
        Class<?> fieldClass = field.getType();
        if (this.isImmutable(fieldClass)) {
            return;
        }
        field.setAccessible(true);
        String fieldName = field.getDeclaringClass().getName() + '#' + field.getName();
        Object originalValue = field.get(this.original);
        Object copyValue = field.get(this.copy);
        Assert.assertNotSame((String)fieldName, (Object)originalValue, (Object)copyValue);
        if (fieldClass.isArray()) {
            this.compareElementsOfArray(fieldName, originalValue, copyValue);
        } else if (List.class.isAssignableFrom(fieldClass)) {
            this.compareElementsOfList(fieldName, (List)originalValue, (List)copyValue);
        } else if (Map.class.isAssignableFrom(fieldClass)) {
            this.compareValuesOfMap(fieldName, (Map)originalValue, (Map)copyValue);
        }
    }

    private void compareElementsOfArray(String fieldName, Object originalArray, Object copyArray) {
        int length = Array.getLength(originalArray);
        for (int i = 0; i < length; ++i) {
            Object originalElement = Array.get(originalArray, i);
            Object copyElement = Array.get(copyArray, i);
            if (this.isImmutable(originalElement.getClass())) continue;
            Assert.assertNotSame((String)(fieldName + " element " + i), (Object)originalElement, (Object)copyElement);
        }
    }

    private void compareElementsOfList(String fieldName, List<?> originalList, List<?> copyList) {
        int length = originalList.size();
        for (int i = 0; i < length; ++i) {
            Object originalElement = originalList.get(i);
            Object copyElement = copyList.get(i);
            if (this.isImmutable(originalElement.getClass())) continue;
            Assert.assertNotSame((String)(fieldName + " element " + i), originalElement, copyElement);
        }
    }

    private void compareValuesOfMap(String fieldName, Map<?, ?> originalMap, Map<?, ?> copyMap) {
        for (Object key : originalMap.keySet()) {
            Object originalValue = originalMap.get(key);
            Object copyValue = copyMap.get(key);
            if (this.isImmutable(originalValue.getClass())) continue;
            Assert.assertNotSame((String)(fieldName + " key " + key), originalValue, copyValue);
        }
    }
}

