/*
 * Decompiled with CFR 0.152.
 */
package org.infinitest.toolkit;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.infinitest.toolkit.UnmodifiableCollectionTestSupport;
import org.infinitest.toolkit.runners.EnclosedInners;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=EnclosedInners.class)
public abstract class UnmodifiableMapTestSupport<K, V> {
    private Map<K, V> entries;
    private K containedKey;
    private V containedValue;

    @Before
    public final void initializeHarness() {
        this.entries = this.newMap();
        this.containedKey = this.containedKey();
        this.containedValue = this.containedValue();
        Assert.assertFalse((String)"need a non-empty map", (boolean)this.entries.isEmpty());
        Assert.assertTrue((String)"need a key that is in the map", (boolean)this.entries.containsKey(this.containedKey));
        Assert.assertTrue((String)"need a value that is in the map", (boolean)this.entries.containsValue(this.containedValue));
    }

    @Test(expected=UnsupportedOperationException.class)
    public final void shouldPreventPut() {
        this.entries.put(this.newKey(), null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public final void shouldPreventPutAll() {
        Map<K, Object> singletonMap = Collections.singletonMap(this.newKey(), null);
        this.entries.putAll(singletonMap);
    }

    @Test(expected=UnsupportedOperationException.class)
    public final void shouldPreventClear() {
        this.entries.clear();
    }

    @Test(expected=UnsupportedOperationException.class)
    public final void shouldPreventRemove() {
        this.entries.remove(this.containedKey);
    }

    protected abstract Map<K, V> newMap();

    protected abstract K newKey();

    protected abstract K containedKey();

    protected abstract V containedValue();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntriesTest
    extends UnmodifiableCollectionTestSupport<Map.Entry<K, V>> {
        EntriesTest() {
        }

        @Override
        protected Map.Entry<K, V> containedItem() {
            return Maps.immutableEntry((Object)UnmodifiableMapTestSupport.this.containedKey, (Object)UnmodifiableMapTestSupport.this.containedValue);
        }

        @Override
        protected Collection<Map.Entry<K, V>> newCollection() {
            return UnmodifiableMapTestSupport.this.entries.entrySet();
        }

        @Override
        protected Map.Entry<K, V> newItem() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValuesTest
    extends UnmodifiableCollectionTestSupport<V> {
        ValuesTest() {
        }

        @Override
        protected V containedItem() {
            return UnmodifiableMapTestSupport.this.containedValue;
        }

        @Override
        protected Collection<V> newCollection() {
            return UnmodifiableMapTestSupport.this.entries.values();
        }

        @Override
        protected V newItem() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeySetTest
    extends UnmodifiableCollectionTestSupport<K> {
        KeySetTest() {
        }

        @Override
        protected K containedItem() {
            return UnmodifiableMapTestSupport.this.containedKey;
        }

        @Override
        protected Collection<K> newCollection() {
            return UnmodifiableMapTestSupport.this.entries.keySet();
        }

        @Override
        protected K newItem() {
            return UnmodifiableMapTestSupport.this.newKey();
        }
    }
}

