/*
 * Decompiled with CFR 0.152.
 */
package org.infinitest.toolkit.filter;

import java.util.List;
import org.infinitest.toolkit.filter.TestType;
import org.infinitest.toolkit.filter.Type;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTypeFilter
extends Filter {
    private final Class<?> clazz;
    private final List<String> typesToMatch;

    TestTypeFilter(Class<?> clazz, List<String> testTypeProperty) {
        this.clazz = clazz;
        this.typesToMatch = testTypeProperty;
    }

    public boolean shouldRun(Description description) {
        boolean shouldRunMethod = this.shouldRunMethod(description);
        if (!shouldRunMethod) {
            System.out.println("Skipping test method " + description.getDisplayName() + ".  Allowed types: " + this.typesToMatch);
        }
        return shouldRunMethod;
    }

    private boolean shouldRunMethod(Description description) {
        if (this.typesToMatch.contains(TestType.ALL.name())) {
            return true;
        }
        Type type = (Type)description.getAnnotation(Type.class);
        if (type == null) {
            return this.shouldRunClass();
        }
        return this.annotationMatch(type);
    }

    public boolean shouldRunClass() {
        return this.typesToMatch.contains(TestType.ALL.name()) || this.classAnnotationMatch();
    }

    private boolean classAnnotationMatch() {
        Type type = this.clazz.getAnnotation(Type.class);
        if (type == null) {
            return this.typesToMatch.contains(TestType.UNIT.name());
        }
        return this.annotationMatch(type);
    }

    private boolean annotationMatch(Type type) {
        return this.typesToMatch.contains(this.typeString(type));
    }

    private String typeString(Type type) {
        if (type.name().equals("")) {
            return type.value().name();
        }
        return type.name().trim().toUpperCase();
    }

    public String describe() {
        return "Filters test methods based on the value of their " + Type.class.getSimpleName() + " annotation and the value of the aystem property [" + "org.infinitest.filter.types" + "].";
    }
}

