/*
 * Decompiled with CFR 0.152.
 */
package org.infinitest.toolkit.internal.reflection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassUtilities {
    private static final Map<Class<?>, Class<?>> objectToPrimitiveMap = new HashMap(13);
    private static final Map<Class<?>, Set<Class<?>>> primitiveWideningsMap;

    private ClassUtilities() {
    }

    static Class<?> classForNameOrPrimitive(String name, ClassLoader loader) throws ClassNotFoundException {
        if (name == null || "".equals(name) || "null".equals(name) || "void".equals(name)) {
            return Void.TYPE;
        }
        if ("boolean".equals(name)) {
            return Boolean.TYPE;
        }
        if ("byte".equals(name)) {
            return Byte.TYPE;
        }
        if ("char".equals(name)) {
            return Character.TYPE;
        }
        if ("double".equals(name)) {
            return Double.TYPE;
        }
        if ("float".equals(name)) {
            return Float.TYPE;
        }
        if ("int".equals(name)) {
            return Integer.TYPE;
        }
        if ("long".equals(name)) {
            return Long.TYPE;
        }
        if ("short".equals(name)) {
            return Short.TYPE;
        }
        return Class.forName(name, false, loader);
    }

    static boolean classIsAccessible(Class<?> aClass) {
        return aClass != null && Modifier.isPublic(aClass.getModifiers());
    }

    static boolean compatibleClasses(Class<?>[] formals, Class<?>[] actuals) {
        if (formals.length != actuals.length) {
            return false;
        }
        for (int i = 0; i < formals.length; ++i) {
            Class<?> actualPrimEquiv;
            Class<?> formalPrimEquiv;
            if (!(actuals[i] == null || Void.TYPE.equals(actuals[i]) ? formals[i].isPrimitive() : !formals[i].isAssignableFrom(actuals[i]) && !ClassUtilities.primitiveIsAssignableFrom(formalPrimEquiv = ClassUtilities.primitiveEquivalentOf(formals[i]), actualPrimEquiv = ClassUtilities.primitiveEquivalentOf(actuals[i])))) continue;
            return false;
        }
        return true;
    }

    static Method getAccessibleMethodFrom(Class<?> aClass, String methodName, Class<?>[] parameterTypes) {
        int i;
        Method overriddenMethod;
        Class<?> superclass = aClass.getSuperclass();
        if (ClassUtilities.classIsAccessible(superclass)) {
            try {
                overriddenMethod = superclass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException ignored) {
                overriddenMethod = null;
            }
            if (overriddenMethod != null) {
                return overriddenMethod;
            }
        }
        Class<?>[] interfaces = aClass.getInterfaces();
        for (i = 0; i < interfaces.length; ++i) {
            if (!ClassUtilities.classIsAccessible(interfaces[i])) continue;
            try {
                overriddenMethod = interfaces[i].getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException ignored) {
                overriddenMethod = null;
            }
            if (overriddenMethod == null) continue;
            return overriddenMethod;
        }
        if (superclass != null && (overriddenMethod = ClassUtilities.getAccessibleMethodFrom(superclass, methodName, parameterTypes)) != null) {
            return overriddenMethod;
        }
        for (i = 0; i < interfaces.length; ++i) {
            overriddenMethod = ClassUtilities.getAccessibleMethodFrom(interfaces[i], methodName, parameterTypes);
            if (overriddenMethod == null) continue;
            return overriddenMethod;
        }
        return null;
    }

    static Class<?> primitiveEquivalentOf(Class<?> aClass) {
        return aClass.isPrimitive() ? aClass : objectToPrimitiveMap.get(aClass);
    }

    static boolean primitiveIsAssignableFrom(Class<?> assigned, Class<?> assignee) {
        if (assigned == null || assignee == null) {
            return false;
        }
        if (!assigned.isPrimitive() || !assignee.isPrimitive()) {
            return false;
        }
        if (assigned.equals(assignee)) {
            return true;
        }
        Set<Class<?>> wideningSet = primitiveWideningsMap.get(assignee);
        if (wideningSet == null) {
            return false;
        }
        return wideningSet.contains(assigned);
    }

    static {
        objectToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        objectToPrimitiveMap.put(Byte.class, Byte.TYPE);
        objectToPrimitiveMap.put(Character.class, Character.TYPE);
        objectToPrimitiveMap.put(Double.class, Double.TYPE);
        objectToPrimitiveMap.put(Float.class, Float.TYPE);
        objectToPrimitiveMap.put(Integer.class, Integer.TYPE);
        objectToPrimitiveMap.put(Long.class, Long.TYPE);
        objectToPrimitiveMap.put(Short.class, Short.TYPE);
        primitiveWideningsMap = new HashMap(11);
        HashSet<Class<Number>> set = new HashSet<Class<Number>>();
        set.add(Short.TYPE);
        set.add(Integer.TYPE);
        set.add(Long.TYPE);
        set.add(Float.TYPE);
        set.add(Double.TYPE);
        primitiveWideningsMap.put(Byte.TYPE, set);
        set = new HashSet();
        set.add(Integer.TYPE);
        set.add(Long.TYPE);
        set.add(Float.TYPE);
        set.add(Double.TYPE);
        primitiveWideningsMap.put(Short.TYPE, set);
        primitiveWideningsMap.put(Character.TYPE, set);
        set = new HashSet();
        set.add(Long.TYPE);
        set.add(Float.TYPE);
        set.add(Double.TYPE);
        primitiveWideningsMap.put(Integer.TYPE, set);
        set = new HashSet();
        set.add(Float.TYPE);
        set.add(Double.TYPE);
        primitiveWideningsMap.put(Long.TYPE, set);
        set = new HashSet();
        set.add(Double.TYPE);
        primitiveWideningsMap.put(Float.TYPE, set);
        new ClassUtilities();
    }
}

