/*
 * Decompiled with CFR 0.152.
 */
package org.infinitest.toolkit.runners;

import java.lang.reflect.Constructor;
import java.util.List;
import org.infinitest.toolkit.internal.reflection.MethodFinder;
import org.infinitest.toolkit.runners.Enclosure;
import org.infinitest.toolkit.runners.RunEnclosedThenEnclosingAfters;
import org.infinitest.toolkit.runners.RunEnclosingThenEnclosedBefores;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlockJUnit4InnerClassRunner
extends BlockJUnit4ClassRunner {
    private final TestClass enclosing;

    BlockJUnit4InnerClassRunner(Class<?> enclosing, Class<?> enclosed) throws InitializationError {
        super(enclosed);
        this.enclosing = new TestClass(enclosing);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        this.validatePublicVoidNoArgMethods(BeforeClass.class, true, errors);
        this.validatePublicVoidNoArgMethods(AfterClass.class, true, errors);
        this.validateInstanceMethods(errors);
    }

    protected Enclosure createTest() throws Exception {
        Object enclosingInstance = this.enclosing.getOnlyConstructor().newInstance(new Object[0]);
        Class innerClass = this.getTestClass().getJavaClass();
        MethodFinder methodFinder = MethodFinder.methodFinderFor(innerClass);
        Constructor innerCtor = methodFinder.findConstructor(new Class[]{this.enclosing.getJavaClass()});
        innerCtor.setAccessible(true);
        Object enclosedInstance = innerCtor.newInstance(enclosingInstance);
        return new Enclosure(enclosingInstance, enclosedInstance);
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return super.methodInvoker(method, Enclosure.enclosed(test));
    }

    protected Statement possiblyExpectingExceptions(FrameworkMethod method, Object test, Statement next) {
        return super.possiblyExpectingExceptions(method, Enclosure.enclosed(test), next);
    }

    protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        return super.withPotentialTimeout(method, Enclosure.enclosed(test), next);
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        return new RunEnclosingThenEnclosedBefores(statement, Enclosure.enclosing(target), this.enclosing, Enclosure.enclosed(target), this.getTestClass());
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        return new RunEnclosedThenEnclosingAfters(statement, Enclosure.enclosed(target), this.getTestClass(), Enclosure.enclosing(target), this.enclosing);
    }
}

