/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.pac4j.authentication.handler.support;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.DefaultHandlerResult;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.support.pac4j.authentication.handler.support.AbstractClientAuthenticationHandler;
import org.jasig.cas.support.pac4j.authentication.principal.ClientCredential;
import org.pac4j.core.client.Clients;
import org.pac4j.core.profile.UserProfile;

public class ClientAuthenticationHandler
extends AbstractClientAuthenticationHandler {
    private boolean typedIdUsed = true;

    public ClientAuthenticationHandler(Clients theClients) {
        super(theClients);
    }

    @Override
    protected HandlerResult createResult(ClientCredential credentials, UserProfile profile) throws GeneralSecurityException, PreventedException {
        String id = this.typedIdUsed ? profile.getTypedId() : profile.getId();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            credentials.setUserProfile(profile);
            credentials.setTypedIdUsed(this.typedIdUsed);
            return new DefaultHandlerResult((AuthenticationHandler)this, (CredentialMetaData)new BasicCredentialMetaData((Credential)credentials), this.principalFactory.createPrincipal(id, profile.getAttributes()));
        }
        throw new FailedLoginException("No identifier found for this user profile: " + profile);
    }

    public boolean isTypedIdUsed() {
        return this.typedIdUsed;
    }

    public void setTypedIdUsed(boolean typedIdUsed) {
        this.typedIdUsed = typedIdUsed;
    }
}

