/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.pac4j.web.flow;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.support.pac4j.authentication.principal.ClientCredential;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.web.support.WebUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.Mechanism;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.RequiresHttpAction;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.ProfileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class ClientAction
extends AbstractAction {
    public static final String SERVICE = "service";
    public static final String THEME = "theme";
    public static final String LOCALE = "locale";
    public static final String METHOD = "method";
    private static final Set<Mechanism> SUPPORTED_PROTOCOLS = ImmutableSet.of((Object)Mechanism.CAS_PROTOCOL, (Object)Mechanism.OAUTH_PROTOCOL, (Object)Mechanism.OPENID_PROTOCOL, (Object)Mechanism.SAML_PROTOCOL, (Object)Mechanism.OPENID_CONNECT_PROTOCOL);
    private final Logger logger = LoggerFactory.getLogger(ClientAction.class);
    @NotNull
    private final Clients clients;
    @NotNull
    private final CentralAuthenticationService centralAuthenticationService;

    public ClientAction(CentralAuthenticationService theCentralAuthenticationService, Clients theClients) {
        this.centralAuthenticationService = theCentralAuthenticationService;
        this.clients = theClients;
        ProfileHelper.setKeepRawData((boolean)true);
    }

    protected Event doExecute(RequestContext context) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
        HttpSession session = request.getSession();
        J2EContext webContext = new J2EContext(request, response);
        String clientName = request.getParameter(this.clients.getClientNameParameter());
        this.logger.debug("clientName: {}", (Object)clientName);
        if (StringUtils.isNotBlank((CharSequence)clientName)) {
            Credentials credentials;
            BaseClient client = (BaseClient)this.clients.findClient(clientName);
            this.logger.debug("client: {}", (Object)client);
            Mechanism mechanism = client.getMechanism();
            if (!SUPPORTED_PROTOCOLS.contains(mechanism)) {
                throw new TechnicalException("Only CAS, OAuth, OpenID and SAML protocols are supported: " + client);
            }
            try {
                credentials = client.getCredentials((WebContext)webContext);
                this.logger.debug("credentials: {}", (Object)credentials);
            }
            catch (RequiresHttpAction e) {
                this.logger.debug("requires http action: {}", (Throwable)e);
                response.flushBuffer();
                ExternalContext externalContext = ExternalContextHolder.getExternalContext();
                externalContext.recordResponseComplete();
                return new Event((Object)this, "stop");
            }
            Service service = (Service)session.getAttribute(SERVICE);
            context.getFlowScope().put(SERVICE, (Object)service);
            this.logger.debug("retrieve service: {}", (Object)service);
            if (service != null) {
                request.setAttribute(SERVICE, (Object)service.getId());
            }
            this.restoreRequestAttribute(request, session, THEME);
            this.restoreRequestAttribute(request, session, LOCALE);
            this.restoreRequestAttribute(request, session, METHOD);
            if (credentials != null) {
                TicketGrantingTicket tgt = this.centralAuthenticationService.createTicketGrantingTicket(new Credential[]{new ClientCredential(credentials)});
                WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (TicketGrantingTicket)tgt);
                return this.success();
            }
        }
        this.prepareForLoginPage(context);
        return this.error();
    }

    protected void prepareForLoginPage(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
        HttpSession session = request.getSession();
        J2EContext webContext = new J2EContext(request, response);
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        this.logger.debug("save service: {}", (Object)service);
        session.setAttribute(SERVICE, (Object)service);
        this.saveRequestParameter(request, session, THEME);
        this.saveRequestParameter(request, session, LOCALE);
        this.saveRequestParameter(request, session, METHOD);
        for (Client client : this.clients.findAllClients()) {
            String key = client.getName() + "Url";
            BaseClient baseClient = (BaseClient)client;
            String redirectionUrl = baseClient.getRedirectionUrl((WebContext)webContext);
            this.logger.debug("{} -> {}", (Object)key, (Object)redirectionUrl);
            context.getFlowScope().put(key, (Object)redirectionUrl);
        }
    }

    private void restoreRequestAttribute(HttpServletRequest request, HttpSession session, String name) {
        String value = (String)session.getAttribute(name);
        request.setAttribute(name, (Object)value);
    }

    private void saveRequestParameter(HttpServletRequest request, HttpSession session, String name) {
        String value = request.getParameter(name);
        if (value != null) {
            session.setAttribute(name, (Object)value);
        }
    }
}

