/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.ticket.AbstractTicketException;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@Component(value="ticketGrantingTicketCheckAction")
public class TicketGrantingTicketCheckAction
extends AbstractAction {
    public static final String NOT_EXISTS = "notExists";
    public static final String INVALID = "invalid";
    public static final String VALID = "valid";
    @NotNull
    private final CentralAuthenticationService centralAuthenticationService;

    @Autowired
    public TicketGrantingTicketCheckAction(@Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    protected Event doExecute(RequestContext requestContext) throws Exception {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
        if (!StringUtils.hasText((String)tgtId)) {
            return new Event((Object)this, NOT_EXISTS);
        }
        String eventId = INVALID;
        try {
            Ticket ticket = this.centralAuthenticationService.getTicket(tgtId, Ticket.class);
            if (ticket != null && !ticket.isExpired()) {
                eventId = VALID;
            }
        }
        catch (AbstractTicketException e) {
            this.logger.trace((Object)"Could not retrieve ticket id {} from registry.", (Throwable)e);
        }
        return new Event((Object)this, eventId);
    }
}

