/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.report;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.util.ISOStandardDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller(value="singleSignOnSessionsReportController")
public final class SingleSignOnSessionsReportController {
    private static final String VIEW_SSO_SESSIONS = "monitoring/viewSsoSessions";
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleSignOnSessionsReportController.class);
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;

    private Collection<Map<String, Object>> getActiveSsoSessions(SsoSessionReportOptions option) {
        ArrayList<Map<String, Object>> activeSessions = new ArrayList<Map<String, Object>>();
        ISOStandardDateFormat dateFormat = new ISOStandardDateFormat();
        for (Ticket ticket : this.getNonExpiredTicketGrantingTickets()) {
            TicketGrantingTicket tgt = (TicketGrantingTicket)ticket;
            if (option == SsoSessionReportOptions.DIRECT && tgt.getProxiedBy() != null) continue;
            Authentication authentication = tgt.getAuthentication();
            Principal principal = authentication.getPrincipal();
            HashMap<String, Object> sso = new HashMap<String, Object>(SsoSessionAttributeKeys.values().length);
            sso.put(SsoSessionAttributeKeys.AUTHENTICATED_PRINCIPAL.toString(), principal.getId());
            sso.put(SsoSessionAttributeKeys.AUTHENTICATION_DATE.toString(), authentication.getAuthenticationDate());
            sso.put(SsoSessionAttributeKeys.AUTHENTICATION_DATE_FORMATTED.toString(), dateFormat.format(authentication.getAuthenticationDate()));
            sso.put(SsoSessionAttributeKeys.NUMBER_OF_USES.toString(), tgt.getCountOfUses());
            sso.put(SsoSessionAttributeKeys.TICKET_GRANTING_TICKET.toString(), tgt.getId());
            sso.put(SsoSessionAttributeKeys.PRINCIPAL_ATTRIBUTES.toString(), principal.getAttributes());
            sso.put(SsoSessionAttributeKeys.AUTHENTICATION_ATTRIBUTES.toString(), authentication.getAttributes());
            if (option != SsoSessionReportOptions.DIRECT) {
                if (tgt.getProxiedBy() != null) {
                    sso.put(SsoSessionAttributeKeys.IS_PROXIED.toString(), Boolean.TRUE);
                    sso.put(SsoSessionAttributeKeys.PROXIED_BY.toString(), tgt.getProxiedBy().getId());
                } else {
                    sso.put(SsoSessionAttributeKeys.IS_PROXIED.toString(), Boolean.FALSE);
                }
            }
            sso.put(SsoSessionAttributeKeys.AUTHENTICATED_SERVICES.toString(), tgt.getServices());
            activeSessions.add(sso);
        }
        return activeSessions;
    }

    private Collection<Ticket> getNonExpiredTicketGrantingTickets() {
        return this.centralAuthenticationService.getTickets((Predicate)new Predicate<Ticket>(){

            public boolean apply(@Nullable Ticket ticket) {
                if (ticket instanceof TicketGrantingTicket) {
                    return !ticket.isExpired();
                }
                return false;
            }
        });
    }

    @RequestMapping(value={"/statistics/ssosessions/getSsoSessions"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getSsoSessions(@RequestParam(defaultValue="ALL") String type) {
        HashMap<String, Object> sessionsMap = new HashMap<String, Object>(1);
        SsoSessionReportOptions option = SsoSessionReportOptions.valueOf(type);
        Collection<Map<String, Object>> activeSsoSessions = this.getActiveSsoSessions(option);
        sessionsMap.put("activeSsoSessions", activeSsoSessions);
        long totalTicketGrantingTickets = 0L;
        long totalProxyGrantingTickets = 0L;
        long totalUsageCount = 0L;
        HashSet<String> uniquePrincipals = new HashSet<String>();
        for (Map<String, Object> activeSsoSession : activeSsoSessions) {
            if (activeSsoSession.containsKey(SsoSessionAttributeKeys.IS_PROXIED.toString())) {
                Boolean isProxied = Boolean.valueOf(activeSsoSession.get(SsoSessionAttributeKeys.IS_PROXIED.toString()).toString());
                if (isProxied.booleanValue()) {
                    ++totalProxyGrantingTickets;
                } else {
                    ++totalTicketGrantingTickets;
                    String principal = activeSsoSession.get(SsoSessionAttributeKeys.AUTHENTICATED_PRINCIPAL.toString()).toString();
                    uniquePrincipals.add(principal);
                }
            } else {
                ++totalTicketGrantingTickets;
                String principal = activeSsoSession.get(SsoSessionAttributeKeys.AUTHENTICATED_PRINCIPAL.toString()).toString();
                uniquePrincipals.add(principal);
            }
            totalUsageCount += Long.parseLong(activeSsoSession.get(SsoSessionAttributeKeys.NUMBER_OF_USES.toString()).toString());
        }
        sessionsMap.put("totalProxyGrantingTickets", totalProxyGrantingTickets);
        sessionsMap.put("totalTicketGrantingTickets", totalTicketGrantingTickets);
        sessionsMap.put("totalTickets", totalTicketGrantingTickets + totalProxyGrantingTickets);
        sessionsMap.put("totalPrincipals", uniquePrincipals.size());
        sessionsMap.put("totalUsageCount", totalUsageCount);
        return sessionsMap;
    }

    @RequestMapping(value={"/statistics/ssosessions/destroySsoSession"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> destroySsoSession(@RequestParam String ticketGrantingTicket) {
        HashMap<String, Object> sessionsMap = new HashMap<String, Object>(1);
        try {
            this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicket);
            sessionsMap.put("status", 200);
            sessionsMap.put("ticketGrantingTicket", ticketGrantingTicket);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            sessionsMap.put("status", 500);
            sessionsMap.put("ticketGrantingTicket", ticketGrantingTicket);
            sessionsMap.put("message", e.getMessage());
        }
        return sessionsMap;
    }

    @RequestMapping(value={"/statistics/ssosessions/destroySsoSessions"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> destroySsoSessions(@RequestParam(defaultValue="ALL") String type) {
        HashMap<String, Object> sessionsMap = new HashMap<String, Object>();
        HashMap<String, String> failedTickets = new HashMap<String, String>();
        SsoSessionReportOptions option = SsoSessionReportOptions.valueOf(type);
        Collection<Map<String, Object>> collection = this.getActiveSsoSessions(option);
        for (Map<String, Object> sso : collection) {
            String ticketGrantingTicket = sso.get(SsoSessionAttributeKeys.TICKET_GRANTING_TICKET.toString()).toString();
            try {
                this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicket);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                failedTickets.put(ticketGrantingTicket, e.getMessage());
            }
        }
        if (failedTickets.isEmpty()) {
            sessionsMap.put("status", 200);
        } else {
            sessionsMap.put("status", 500);
            sessionsMap.put("failedTicketGrantingTickets", failedTickets);
        }
        return sessionsMap;
    }

    @RequestMapping(value={"/statistics/ssosessions"}, method={RequestMethod.GET})
    public ModelAndView showSsoSessions() throws Exception {
        return new ModelAndView(VIEW_SSO_SESSIONS);
    }

    private static enum SsoSessionAttributeKeys {
        AUTHENTICATED_PRINCIPAL("authenticated_principal"),
        PRINCIPAL_ATTRIBUTES("principal_attributes"),
        AUTHENTICATION_DATE("authentication_date"),
        AUTHENTICATION_DATE_FORMATTED("authentication_date_formatted"),
        TICKET_GRANTING_TICKET("ticket_granting_ticket"),
        AUTHENTICATION_ATTRIBUTES("authentication_attributes"),
        PROXIED_BY("proxied_by"),
        AUTHENTICATED_SERVICES("authenticated_services"),
        IS_PROXIED("is_proxied"),
        NUMBER_OF_USES("number_of_uses");

        private final String attributeKey;

        private SsoSessionAttributeKeys(String attributeKey) {
            this.attributeKey = attributeKey;
        }

        public String toString() {
            return this.attributeKey;
        }
    }

    private static enum SsoSessionReportOptions {
        ALL("all"),
        PROXIED("proxied"),
        DIRECT("direct");

        private final String type;

        private SsoSessionReportOptions(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.type;
        }
    }
}

