/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.report;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.servlets.HealthCheckServlet;
import com.codahale.metrics.servlets.MetricsServlet;
import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Queue;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;

@Controller(value="statisticsController")
@RequestMapping(value={"/statistics"})
public final class StatisticsController
implements ServletContextAware {
    private static final int NUMBER_OF_MILLISECONDS_IN_A_DAY = 86400000;
    private static final int NUMBER_OF_MILLISECONDS_IN_AN_HOUR = 3600000;
    private static final int NUMBER_OF_MILLISECONDS_IN_A_MINUTE = 60000;
    private static final int NUMBER_OF_MILLISECONDS_IN_A_SECOND = 1000;
    private static final int NUMBER_OF_BYTES_IN_A_KILOBYTE = 1024;
    private static final String MONITORING_VIEW_STATISTICS = "monitoring/viewStatistics";
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Date upTimeStartDate = new Date();
    @Value(value="${host.name:cas01.example.org}")
    private String casTicketSuffix;
    @Autowired
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="metrics")
    private MetricRegistry metricsRegistry;
    @Autowired
    @Qualifier(value="healthCheckMetrics")
    private HealthCheckRegistry healthCheckRegistry;

    @RequestMapping(method={RequestMethod.GET})
    protected ModelAndView handleRequestInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ModelAndView modelAndView = new ModelAndView(MONITORING_VIEW_STATISTICS);
        modelAndView.addObject("startTime", (Object)this.upTimeStartDate);
        double difference = System.currentTimeMillis() - this.upTimeStartDate.getTime();
        modelAndView.addObject("upTime", (Object)this.calculateUptime(difference, new LinkedList<Integer>(Arrays.asList(86400000, 3600000, 60000, 1000, 1)), new LinkedList<String>(Arrays.asList("day", "hour", "minute", "second", "millisecond"))));
        modelAndView.addObject("totalMemory", (Object)StatisticsController.convertToMegaBytes(Runtime.getRuntime().totalMemory()));
        modelAndView.addObject("maxMemory", (Object)StatisticsController.convertToMegaBytes(Runtime.getRuntime().maxMemory()));
        modelAndView.addObject("freeMemory", (Object)StatisticsController.convertToMegaBytes(Runtime.getRuntime().freeMemory()));
        modelAndView.addObject("availableProcessors", (Object)Runtime.getRuntime().availableProcessors());
        modelAndView.addObject("serverHostName", (Object)httpServletRequest.getServerName());
        modelAndView.addObject("serverIpAddress", (Object)httpServletRequest.getLocalAddr());
        modelAndView.addObject("casTicketSuffix", (Object)this.casTicketSuffix);
        int unexpiredTgts = 0;
        int unexpiredSts = 0;
        int expiredTgts = 0;
        int expiredSts = 0;
        try {
            Collection tickets = this.centralAuthenticationService.getTickets(Predicates.alwaysTrue());
            for (Ticket ticket : tickets) {
                if (ticket instanceof ServiceTicket) {
                    if (ticket.isExpired()) {
                        ++expiredSts;
                        continue;
                    }
                    ++unexpiredSts;
                    continue;
                }
                if (ticket.isExpired()) {
                    ++expiredTgts;
                    continue;
                }
                ++unexpiredTgts;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.logger.trace("The ticket registry doesn't support this information.");
        }
        modelAndView.addObject("unexpiredTgts", (Object)unexpiredTgts);
        modelAndView.addObject("unexpiredSts", (Object)unexpiredSts);
        modelAndView.addObject("expiredTgts", (Object)expiredTgts);
        modelAndView.addObject("expiredSts", (Object)expiredSts);
        modelAndView.addObject("pageTitle", (Object)modelAndView.getViewName());
        return modelAndView;
    }

    private static double convertToMegaBytes(double bytes) {
        return bytes / 1024.0 / 1024.0;
    }

    protected String calculateUptime(double difference, Queue<Integer> calculations, Queue<String> labels) {
        if (calculations.isEmpty()) {
            return "";
        }
        int value = calculations.remove();
        double time = Math.floor(difference / (double)value);
        double newDifference = difference - time * (double)value;
        String currentLabel = labels.remove();
        String label = time == 0.0 || time > 1.0 ? String.valueOf(currentLabel) + 's' : currentLabel;
        return String.valueOf(Integer.toString((int)time)) + ' ' + label + ' ' + this.calculateUptime(newDifference, calculations, labels);
    }

    public void setServletContext(ServletContext servletContext) {
        servletContext.setAttribute(MetricsServlet.METRICS_REGISTRY, (Object)this.metricsRegistry);
        servletContext.setAttribute(MetricsServlet.SHOW_SAMPLES, (Object)Boolean.TRUE);
        servletContext.setAttribute(HealthCheckServlet.HEALTH_CHECK_REGISTRY, (Object)this.healthCheckRegistry);
    }
}

