/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.javalite.common.Util;
import org.javalite.http.HttpException;

public abstract class Request<T extends Request> {
    protected final HttpURLConnection connection;
    private boolean connected;
    protected boolean redirect;
    protected final String url;

    public Request(String url, int connectTimeout, int readTimeout) {
        try {
            this.url = url;
            this.connection = (HttpURLConnection)new URL(url).openConnection();
            this.connection.setConnectTimeout(connectTimeout);
            this.connection.setReadTimeout(readTimeout);
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + url, e);
        }
    }

    public T header(String name, String value) {
        this.connection.setRequestProperty(name, value);
        return (T)this;
    }

    public T redirect(boolean redirect) {
        this.redirect = redirect;
        return (T)this;
    }

    public InputStream getInputStream() {
        try {
            return this.connection.getInputStream();
        }
        catch (SocketTimeoutException e) {
            throw new HttpException("Failed URL: " + this.url + ", waited for: " + this.connection.getConnectTimeout() + " milliseconds", e);
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + this.url, e);
        }
    }

    public Map<String, List<String>> headers() {
        this.connect();
        return this.connection.getHeaderFields();
    }

    public int responseCode() {
        try {
            this.connect();
            return this.connection.getResponseCode();
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + this.url, e);
        }
    }

    public String responseMessage() {
        try {
            this.connect();
            return this.connection.getResponseMessage();
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + this.url, e);
        }
    }

    public byte[] bytes() {
        this.connect();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        try {
            int count;
            InputStream in = this.connection.getInputStream();
            while ((count = in.read(bytes)) != -1) {
                bout.write(bytes, 0, count);
            }
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + this.url, e);
        }
        finally {
            this.dispose();
        }
        return bout.toByteArray();
    }

    public String text() {
        try {
            this.connect();
            String string = this.responseCode() >= 400 ? Util.read(this.connection.getErrorStream()) : Util.read(this.connection.getInputStream());
            return string;
        }
        catch (IOException e) {
            throw new HttpException("Failed URL: " + this.url, e);
        }
        finally {
            this.dispose();
        }
    }

    public String text(String encoding) {
        try {
            this.connect();
            String string = this.responseCode() >= 400 ? Util.read(this.connection.getErrorStream()) : Util.read(this.connection.getInputStream(), encoding);
            return string;
        }
        catch (IOException e) {
            throw new HttpException("Failed URL: " + this.url, e);
        }
        finally {
            this.dispose();
        }
    }

    public void dispose() {
        byte[] bytes = new byte[1024];
        try (InputStream in = this.connection.getInputStream();){
            if (in != null) {
                while (in.read(bytes) > 0) {
                }
            }
        }
        catch (Exception ignore) {
            try (InputStream errorStream = this.connection.getErrorStream();){
                if (errorStream != null) {
                    while (errorStream.read(bytes) > 0) {
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected T connect() {
        if (!this.connected) {
            T t = this.doConnect();
            this.connected = true;
            return t;
        }
        return (T)this;
    }

    protected abstract T doConnect();

    public T basic(String user, String password) {
        this.connection.setRequestProperty("Authorization", "Basic " + Util.toBase64((user + ":" + password).getBytes()));
        return (T)this;
    }
}

