/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.javers.common.collections.Function;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.json.typeadapter.date.DateTypeCoreAdapters;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.api.SnapshotIdentifier;
import org.javers.repository.mongo.model.MongoHeadId;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoRepository
implements JaversRepository {
    private static final Logger logger = LoggerFactory.getLogger(MongoRepository.class);
    private static final int DESC = -1;
    private static final int ASC = 1;
    public static final String SNAPSHOTS = "jv_snapshots";
    public static final String COMMIT_ID = "commitMetadata.id";
    public static final String COMMIT_DATE = "commitMetadata.commitDate";
    public static final String GLOBAL_ID_KEY = "globalId_key";
    public static final String GLOBAL_ID_ENTITY = "globalId.entity";
    public static final String GLOBAL_ID_OWNER_ID_ENTITY = "globalId.ownerId.entity";
    public static final String GLOBAL_ID_FRAGMENT = "globalId.fragment";
    public static final String GLOBAL_ID_VALUE_OBJECT = "globalId.valueObject";
    public static final String SNAPSHOT_VERSION = "version";
    public static final String CHANGED_PROPERTIES = "changedProperties";
    public static final String OBJECT_ID = "_id";
    private MongoDatabase mongo;
    private JsonConverter jsonConverter;

    public MongoRepository(MongoDatabase mongo) {
        this.mongo = mongo;
    }

    MongoRepository(MongoDatabase mongo, JsonConverter jsonConverter) {
        this.mongo = mongo;
        this.jsonConverter = jsonConverter;
    }

    public void persist(Commit commit) {
        this.persistSnapshots(commit);
        this.persistHeadId(commit);
    }

    void clean() {
        this.snapshotsCollection().deleteMany((Bson)new Document());
        this.headCollection().deleteMany((Bson)new Document());
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, QueryParams queryParams) {
        return this.queryForSnapshots((Bson)this.createIdQuery(globalId), (Optional<QueryParams>)Optional.of((Object)queryParams));
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        return this.getLatest((Bson)this.createIdQuery(globalId));
    }

    public List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        return this.queryForSnapshots(this.createSnapshotIdentifiersQuery(snapshotIdentifiers), (Optional<QueryParams>)Optional.empty());
    }

    public List<CdoSnapshot> getValueObjectStateHistory(EntityType ownerEntity, String path, QueryParams queryParams) {
        BasicDBObject query = new BasicDBObject(GLOBAL_ID_OWNER_ID_ENTITY, (Object)ownerEntity.getName());
        query.append(GLOBAL_ID_FRAGMENT, (Object)path);
        return this.queryForSnapshots((Bson)query, (Optional<QueryParams>)Optional.of((Object)queryParams));
    }

    public List<CdoSnapshot> getPropertyStateHistory(GlobalId globalId, String propertyName, QueryParams queryParams) {
        BasicDBObject query = this.createIdQuery(globalId);
        query.append(CHANGED_PROPERTIES, (Object)propertyName);
        return this.queryForSnapshots((Bson)query, (Optional<QueryParams>)Optional.of((Object)queryParams));
    }

    public List<CdoSnapshot> getPropertyStateHistory(ManagedType givenClass, String propertyName, QueryParams queryParams) {
        BasicDBObject query = this.createGlobalIdClassQuery(givenClass);
        query.append(CHANGED_PROPERTIES, (Object)propertyName);
        return this.queryForSnapshots((Bson)query, (Optional<QueryParams>)Optional.of((Object)queryParams));
    }

    public List<CdoSnapshot> getStateHistory(ManagedType givenClass, QueryParams queryParams) {
        BasicDBObject query = this.createGlobalIdClassQuery(givenClass);
        return this.queryForSnapshots((Bson)query, (Optional<QueryParams>)Optional.of((Object)queryParams));
    }

    public CommitId getHeadId() {
        Document headId = (Document)this.headCollection().find().first();
        if (headId == null) {
            return null;
        }
        return new MongoHeadId(headId).toCommitId();
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    public void ensureSchema() {
        Object stringCommitId;
        MongoCollection<Document> snapshots = this.snapshotsCollection();
        snapshots.createIndex((Bson)new BasicDBObject(GLOBAL_ID_KEY, (Object)1));
        snapshots.createIndex((Bson)new BasicDBObject(GLOBAL_ID_ENTITY, (Object)1));
        snapshots.createIndex((Bson)new BasicDBObject(GLOBAL_ID_VALUE_OBJECT, (Object)1));
        snapshots.createIndex((Bson)new BasicDBObject(GLOBAL_ID_OWNER_ID_ENTITY, (Object)1));
        snapshots.createIndex((Bson)new BasicDBObject(CHANGED_PROPERTIES, (Object)1));
        this.headCollection();
        Document doc = (Document)snapshots.find().first();
        if (doc != null && (stringCommitId = ((Map)doc.get((Object)"commitMetadata")).get("id")) instanceof String) {
            logger.info("executing db migration script, from JaVers 1.1 to 1.2 ...");
            Document update = new Document("eval", (Object)"function() { \n    db.jv_snapshots.find().forEach( \n      function(snapshot) { \n        snapshot.commitMetadata.id = Number(snapshot.commitMetadata.id); \n        db.jv_snapshots.save(snapshot); } \n    );     return 'ok'; \n}");
            Document ret = this.mongo.runCommand((Bson)update);
            logger.info("result: \n " + ret.toJson());
        }
    }

    private BasicDBObject createIdQuery(GlobalId id) {
        return new BasicDBObject(GLOBAL_ID_KEY, (Object)id.value());
    }

    private Bson createVersionQuery(Long version) {
        return new BasicDBObject(SNAPSHOT_VERSION, (Object)version);
    }

    private Bson createSnapshotIdentifiersQuery(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        List descFilters = Lists.transform(new ArrayList<SnapshotIdentifier>(snapshotIdentifiers), (Function)new Function<SnapshotIdentifier, Bson>(){

            public Bson apply(SnapshotIdentifier snapshotIdentifier) {
                return Filters.and((Bson[])new Bson[]{MongoRepository.this.createIdQuery(snapshotIdentifier.getGlobalId()), MongoRepository.this.createVersionQuery(snapshotIdentifier.getVersion())});
            }
        });
        return Filters.or((Iterable)descFilters);
    }

    private BasicDBObject createGlobalIdClassQuery(ManagedType givenClass) {
        String cName = givenClass.getName();
        BasicDBObject query = null;
        if (givenClass instanceof EntityType) {
            query = new BasicDBObject(GLOBAL_ID_ENTITY, (Object)cName);
        }
        if (givenClass instanceof ValueObjectType) {
            query = new BasicDBObject(GLOBAL_ID_VALUE_OBJECT, (Object)cName);
        }
        return query;
    }

    private CdoSnapshot readFromDBObject(Document dbObject) {
        return (CdoSnapshot)this.jsonConverter.fromJson(dbObject.toJson(), CdoSnapshot.class);
    }

    private Document writeToDBObject(CdoSnapshot snapshot) {
        Validate.conditionFulfilled((this.jsonConverter != null ? 1 : 0) != 0, (String)"MongoRepository: jsonConverter is null");
        Document dbObject = Document.parse((String)this.jsonConverter.toJson((Object)snapshot));
        dbObject.append(GLOBAL_ID_KEY, (Object)snapshot.getGlobalId().value());
        return dbObject;
    }

    private MongoCollection<Document> snapshotsCollection() {
        return this.mongo.getCollection(SNAPSHOTS);
    }

    private MongoCollection<Document> headCollection() {
        return this.mongo.getCollection("jv_head_id");
    }

    private void persistSnapshots(Commit commit) {
        MongoCollection<Document> collection = this.snapshotsCollection();
        for (CdoSnapshot snapshot : commit.getSnapshots()) {
            collection.insertOne((Object)this.writeToDBObject(snapshot));
        }
    }

    private void persistHeadId(Commit commit) {
        MongoCollection<Document> headIdCollection = this.headCollection();
        Document oldHead = (Document)headIdCollection.find().first();
        MongoHeadId newHeadId = new MongoHeadId(commit.getId());
        if (oldHead == null) {
            headIdCollection.insertOne((Object)newHeadId.toDocument());
        } else {
            headIdCollection.updateOne(this.objectIdFiler(oldHead), (Bson)newHeadId.getUpdateCommand());
        }
    }

    private Bson objectIdFiler(Document document) {
        return Filters.eq((String)OBJECT_ID, (Object)document.getObjectId((Object)OBJECT_ID));
    }

    private MongoCursor<Document> getMongoSnapshotsCursor(Bson query, Optional<QueryParams> queryParams) {
        FindIterable findIterable = this.snapshotsCollection().find(this.applyQueryParams(query, queryParams)).sort((Bson)new Document(COMMIT_ID, (Object)-1));
        return this.applyQueryParams((FindIterable<Document>)findIterable, queryParams).iterator();
    }

    private Bson applyQueryParams(Bson query, Optional<QueryParams> queryParams) {
        if (queryParams.isPresent()) {
            QueryParams params = (QueryParams)queryParams.get();
            if (params.from().isPresent()) {
                query = this.addFromDateFiler(query, (LocalDateTime)params.from().get());
            }
            if (params.to().isPresent()) {
                query = this.addToDateFilter(query, (LocalDateTime)params.to().get());
            }
            if (params.commitId().isPresent()) {
                query = this.addCommitIdFilter(query, (CommitId)params.commitId().get());
            }
            if (params.version().isPresent()) {
                query = this.addVersionFilter(query, (Long)params.version().get());
            }
        }
        return query;
    }

    private FindIterable<Document> applyQueryParams(FindIterable<Document> findIterable, Optional<QueryParams> queryParams) {
        if (queryParams.isPresent()) {
            QueryParams params = (QueryParams)queryParams.get();
            findIterable = findIterable.limit(params.limit()).skip(params.skip());
        }
        return findIterable;
    }

    private Bson addFromDateFiler(Bson query, LocalDateTime from) {
        return Filters.and((Bson[])new Bson[]{query, Filters.gte((String)COMMIT_DATE, (Object)DateTypeCoreAdapters.serialize((LocalDateTime)from))});
    }

    private Bson addToDateFilter(Bson query, LocalDateTime to) {
        return Filters.and((Bson[])new Bson[]{query, Filters.lte((String)COMMIT_DATE, (Object)DateTypeCoreAdapters.serialize((LocalDateTime)to))});
    }

    private Bson addCommitIdFilter(Bson query, CommitId commitId) {
        return Filters.and((Bson[])new Bson[]{query, new BasicDBObject(COMMIT_ID, (Object)commitId.valueAsNumber().doubleValue())});
    }

    private Bson addVersionFilter(Bson query, Long version) {
        return Filters.and((Bson[])new Bson[]{query, this.createVersionQuery(version)});
    }

    private Optional<CdoSnapshot> getLatest(Bson idQuery) {
        QueryParams queryParams = QueryParamsBuilder.withLimit((int)1).build();
        MongoCursor<Document> mongoLatest = this.getMongoSnapshotsCursor(idQuery, (Optional<QueryParams>)Optional.of((Object)queryParams));
        if (!mongoLatest.hasNext()) {
            return Optional.empty();
        }
        Document dbObject = this.getOne(mongoLatest);
        return Optional.of((Object)this.readFromDBObject(dbObject));
    }

    private List<CdoSnapshot> queryForSnapshots(Bson query, Optional<QueryParams> queryParams) {
        ArrayList<CdoSnapshot> snapshots = new ArrayList<CdoSnapshot>();
        try (MongoCursor<Document> mongoSnapshots = this.getMongoSnapshotsCursor(query, queryParams);){
            while (mongoSnapshots.hasNext()) {
                Document dbObject = (Document)mongoSnapshots.next();
                snapshots.add(this.readFromDBObject(dbObject));
            }
            ArrayList<CdoSnapshot> arrayList = snapshots;
            return arrayList;
        }
    }

    private <T> T getOne(MongoCursor<T> mongoCursor) {
        try {
            Object object = mongoCursor.next();
            return (T)object;
        }
        finally {
            mongoCursor.close();
        }
    }
}

