/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.ant;

import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.jbehave.ant.AbstractScenarioTask;
import org.jbehave.scenario.RunnableScenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioRunnerTask
extends AbstractScenarioTask {
    private boolean batch;

    public void execute() throws BuildException {
        if (this.skipScenarios()) {
            this.log("Skipped running scenarios", 2);
            return;
        }
        HashMap<String, Throwable> failedScenarios = new HashMap<String, Throwable>();
        for (RunnableScenario scenario : this.scenarios()) {
            String scenarioName = scenario.getClass().getName();
            try {
                this.log("Running scenario " + scenarioName);
                scenario.runScenario();
            }
            catch (Throwable e) {
                String message = "Failure in running scenario " + scenarioName;
                if (this.batch) {
                    failedScenarios.put(scenarioName, e);
                    continue;
                }
                if (this.ignoreFailure()) {
                    this.log(message, e, 1);
                    continue;
                }
                throw new BuildException(message, e);
            }
        }
        if (this.batch && failedScenarios.size() > 0) {
            String message = "Failure in runing scenarios: " + this.format(failedScenarios);
            if (this.ignoreFailure()) {
                this.log(message, 1);
            } else {
                throw new BuildException(message);
            }
        }
    }

    private String format(Map<String, Throwable> failedScenarios) {
        StringBuffer sb = new StringBuffer();
        for (String scenarioName : failedScenarios.keySet()) {
            Throwable cause = failedScenarios.get(scenarioName);
            sb.append("\n");
            sb.append(scenarioName);
            sb.append(": ");
            sb.append(cause.getMessage());
        }
        return sb.toString();
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
    }
}

