/*
 * Decompiled with CFR 0.152.
 */
package org.jbehave.ant;

import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jbehave.scenario.RunnableScenario;
import org.jbehave.scenario.ScenarioClassLoader;
import org.jbehave.scenario.parser.ScenarioClassNameFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScenarioTask
extends Task {
    private static final String TEST_SCOPE = "test";
    private String sourceDirectory = "src/main/java";
    private String testSourceDirectory = "src/test/java";
    private String scope = "compile";
    private List<String> scenarioClassNames = new ArrayList<String>();
    private List<String> scenarioIncludes = new ArrayList<String>();
    private List<String> scenarioExcludes = new ArrayList<String>();
    private boolean classLoaderInjected = true;
    private boolean skip = false;
    private boolean ignoreFailure = false;
    private ScenarioClassNameFinder finder = new ScenarioClassNameFinder();

    private boolean isSourceTestScope() {
        return TEST_SCOPE.equals(this.scope);
    }

    private String rootSourceDirectory() {
        if (this.isSourceTestScope()) {
            return this.testSourceDirectory;
        }
        return this.sourceDirectory;
    }

    private List<String> findScenarioClassNames() {
        this.log("Searching for scenario class names including " + this.scenarioIncludes + " and excluding " + this.scenarioExcludes, 4);
        List scenarioClassNames = this.finder.listScenarioClassNames(this.rootSourceDirectory(), null, this.scenarioIncludes, this.scenarioExcludes);
        this.log("Found scenario class names: " + scenarioClassNames, 4);
        return scenarioClassNames;
    }

    private ScenarioClassLoader createScenarioClassLoader() throws MalformedURLException {
        return new ScenarioClassLoader(this.classpathElements());
    }

    private List<String> classpathElements() {
        List<Object> classpathElements = Arrays.asList(new Object[0]);
        return classpathElements;
    }

    protected boolean ignoreFailure() {
        return this.ignoreFailure;
    }

    protected boolean skipScenarios() {
        return this.skip;
    }

    protected List<RunnableScenario> scenarios() throws BuildException {
        List<String> names = this.scenarioClassNames;
        if (names == null || names.isEmpty()) {
            names = this.findScenarioClassNames();
        }
        if (names.isEmpty()) {
            this.log("No scenarios to run.", 2);
        }
        ScenarioClassLoader classLoader = null;
        try {
            classLoader = this.createScenarioClassLoader();
        }
        catch (Exception e) {
            throw new BuildException("Failed to create scenario class loader", (Throwable)e);
        }
        ArrayList<RunnableScenario> scenarios = new ArrayList<RunnableScenario>();
        for (String name : names) {
            try {
                if (this.isScenarioAbstract(classLoader, name)) continue;
                scenarios.add(this.scenarioFor(classLoader, name));
            }
            catch (Exception e) {
                throw new BuildException("Failed to instantiate scenario '" + name + "'", (Throwable)e);
            }
        }
        return scenarios;
    }

    private boolean isScenarioAbstract(ScenarioClassLoader classLoader, String name) throws ClassNotFoundException {
        return Modifier.isAbstract(classLoader.loadClass(name).getModifiers());
    }

    private RunnableScenario scenarioFor(ScenarioClassLoader classLoader, String name) {
        if (this.classLoaderInjected) {
            try {
                return classLoader.newScenario(name, new Class[]{ClassLoader.class});
            }
            catch (RuntimeException e) {
                throw new RuntimeException("JBehave is trying to instantiate your Scenario class '" + name + "' with a ClassLoader as a parameter.  " + "If this is wrong, change the Ant configuration for the plugin to include " + "<classLoaderInjected>false</classLoaderInjected>", e);
            }
        }
        return classLoader.newScenario(name, new Class[0]);
    }

    public void setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void setTestSourceDirectory(String testSourceDirectory) {
        this.testSourceDirectory = testSourceDirectory;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setScenarioClassNames(String scenarioClassNamesCSV) {
        this.scenarioClassNames = Arrays.asList(scenarioClassNamesCSV.split(","));
    }

    public void setScenarioIncludes(String scenarioIncludesCSV) {
        this.scenarioIncludes = Arrays.asList(scenarioIncludesCSV.split(","));
    }

    public void setScenarioExcludes(String scenarioExcludesCSV) {
        this.scenarioExcludes = Arrays.asList(scenarioExcludesCSV.split(","));
    }

    public void setclassLoaderInjected(boolean classLoaderInjected) {
        this.classLoaderInjected = classLoaderInjected;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }
}

