/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency.policy.mock;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.test.support.MockClassLoaderHelper;
import org.jboss.classloader.test.support.MockClassLoaderPolicy;
import org.jboss.classloading.plugins.visitor.DefaultResourceContext;
import org.jboss.classloading.spi.dependency.policy.ClassLoaderPolicyModule;
import org.jboss.classloading.spi.dependency.policy.mock.MockClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.Capability;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaDataFactory;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.classloading.spi.visitor.ResourceVisitor;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockClassLoaderPolicyModule
extends ClassLoaderPolicyModule
implements KernelControllerContextAware {
    private static final long serialVersionUID = 1L;

    public MockClassLoaderPolicyModule(MockClassLoadingMetaData classLoadingMetaData, String contextName) {
        super(classLoadingMetaData, contextName);
    }

    private static Collection<String> toCollection(String[] strings) {
        if (strings == null || strings.length == 0) {
            return Collections.emptySet();
        }
        return Arrays.asList(strings);
    }

    protected URL getURL(String path) {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            throw new IllegalStateException("ClassLoader has not been constructed for " + this.getContextName());
        }
        return classLoader.getResource(path);
    }

    @Override
    public void visit(ResourceVisitor visitor, ResourceFilter filter, ResourceFilter recurseFilter, URL ... urls) {
        MockClassLoadingMetaData mclmd = this.getClassLoadingMetaData();
        String[] paths = mclmd.getPaths();
        if (paths != null && paths.length > 0) {
            ClassLoader classLoader = this.getClassLoader();
            if (classLoader == null) {
                throw new IllegalStateException("ClassLoader has not been constructed for " + this.getContextName());
            }
            Collection<String> included = MockClassLoaderPolicyModule.toCollection(mclmd.getIncludedClasses());
            ClassFilter includedFilter = this.getIncluded();
            Collection<String> excluded = MockClassLoaderPolicyModule.toCollection(mclmd.getExcludedClasses());
            ClassFilter excludedFilter = this.getExcluded();
            for (String path : paths) {
                if (!included.isEmpty() && !included.contains(path) || includedFilter != null && !includedFilter.matchesResourcePath(path) || !excluded.isEmpty() && excluded.contains(path) || excludedFilter != null && excludedFilter.matchesResourcePath(path)) continue;
                DefaultResourceContext context = new DefaultResourceContext(this.getURL(path), path, classLoader);
                if (filter != null && !filter.accepts(context)) continue;
                visitor.visit(context);
            }
        }
    }

    @Override
    protected List<Capability> determineCapabilities() {
        List<Capability> capabilities = super.determineCapabilities();
        if (capabilities != null) {
            return capabilities;
        }
        ClassLoadingMetaDataFactory factory = ClassLoadingMetaDataFactory.getInstance();
        capabilities = new CopyOnWriteArrayList<Capability>();
        Object version = this.getVersion();
        Capability capability = factory.createModule(this.getName(), version);
        capabilities.add(capability);
        MockClassLoadingMetaData metadata = this.getClassLoadingMetaData();
        String[] exported = metadata.getExportedPackages();
        if (exported != null) {
            for (String packageName : exported) {
                capability = factory.createPackage(packageName, version);
                capabilities.add(capability);
            }
        }
        return capabilities;
    }

    public void setKernelControllerContext(KernelControllerContext context) throws Exception {
        this.setControllerContext((ControllerContext)context);
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
        this.setControllerContext(null);
    }

    @Override
    protected MockClassLoadingMetaData getClassLoadingMetaData() {
        return (MockClassLoadingMetaData)super.getClassLoadingMetaData();
    }

    public MockClassLoaderPolicy getPolicy() {
        return (MockClassLoaderPolicy)super.getPolicy();
    }

    protected MockClassLoaderPolicy determinePolicy() {
        MockClassLoadingMetaData metaData = this.getClassLoadingMetaData();
        MockClassLoaderPolicy policy = MockClassLoaderHelper.createMockClassLoaderPolicy((String)this.getContextName());
        policy.setPrefix(metaData.getPrefix());
        policy.setPackageNames(this.getPackageNames());
        policy.setPaths(metaData.getPaths());
        policy.setIncluded(metaData.getIncludedClasses());
        policy.setExcluded(metaData.getExcludedClasses());
        policy.setImportAll(this.isImportAll());
        policy.setDelegates(this.getDelegates());
        return policy;
    }
}

