/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency;

import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.metadata.Requirement;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.logging.Logger;
import org.jboss.util.JBossStringBuilder;

public class RequirementDependencyItem
extends AbstractDependencyItem {
    private static final Logger log = Logger.getLogger(RequirementDependencyItem.class);
    private Module module;
    private Requirement requirement;

    public RequirementDependencyItem(Module module, Requirement requirement, ControllerState state) {
        this(module, requirement, state, ControllerState.INSTALLED);
    }

    public RequirementDependencyItem(Module module, Requirement requirement, ControllerState whenRequired, ControllerState dependentState) {
        super((Object)(module != null ? module.getContextName() : null), null, whenRequired, dependentState);
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        if (requirement == null) {
            throw new IllegalArgumentException("Null requirement");
        }
        this.module = module;
        this.requirement = requirement;
    }

    public Module getModule() {
        return this.module;
    }

    public Requirement getRequirement() {
        return this.requirement;
    }

    public boolean resolve(Controller controller) {
        Requirement requirement = this.getRequirement();
        Module module = this.getModule().resolveModule(this, true);
        if (module == null) {
            this.setResolved(requirement.isOptional() || requirement.isDynamic());
            return this.isResolved();
        }
        if (module == this.module) {
            String iDependOn = module.getContextName();
            ControllerContext context = controller.getContext((Object)iDependOn, null);
            this.setIDependOn(context.getName());
            this.addDependsOnMe(controller, context);
            this.setResolved(true);
            return this.isResolved();
        }
        String iDependOn = module.getContextName();
        ControllerContext context = controller.getContext((Object)iDependOn, this.getDependentState());
        if (context != null) {
            this.setIDependOn(context.getName());
            this.addDependsOnMe(controller, context);
            this.setResolved(true);
            if (module.getClassLoadingSpace() == null) {
                log.warn((Object)(this.getModule() + " resolved " + this.getRequirement() + " to " + module + " which has import-all=true. Cannot check its consistency."));
            }
            return this.isResolved();
        }
        this.setResolved(false);
        return this.isResolved();
    }

    public boolean unresolved(Controller controller) {
        this.setIDependOn(null);
        this.setResolved(false);
        return true;
    }

    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        buffer.append(" requirement=").append((Object)this.getRequirement());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName()).append(" ").append((Object)this.getRequirement());
    }

    public String toHumanReadableString() {
        return this.getRequirement().toString();
    }
}

