/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency;

import org.jboss.classloader.spi.ClassFoundEvent;
import org.jboss.classloader.spi.ClassFoundHandler;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloader.spi.filter.ClassFilter;
import org.jboss.classloader.spi.filter.ClassFilterUtils;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.policy.ClassLoaderPolicyModule;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ControllerStateModel;
import org.jboss.logging.Logger;

public class LifeCycle {
    private static final Logger log = Logger.getLogger(LifeCycle.class);
    private Module module;
    private boolean lazyStart = false;
    private boolean lazyResolve = false;
    private LazyStartHandler lazyStartHandler;
    private ClassFilter lazyStartFilter = ClassFilterUtils.EVERYTHING;

    public LifeCycle(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        this.module = module;
    }

    public Module getModule() {
        return this.module;
    }

    public boolean isLazyStart() {
        return this.lazyStart;
    }

    public void setLazyStart(boolean lazyStart) {
        this.lazyStart = lazyStart;
        if (lazyStart) {
            this.setUpLazyStart();
        }
    }

    public ClassFilter getLazyStartFilter() {
        return this.lazyStartFilter;
    }

    public void setLazyStartFilter(ClassFilter lazyStartFilter) {
        if (lazyStartFilter == null) {
            lazyStartFilter = ClassFilterUtils.EVERYTHING;
        }
        this.lazyStartFilter = lazyStartFilter;
    }

    public boolean isResolved() {
        return this.module.getClassLoader() != null;
    }

    public boolean isLazyResolve() {
        return this.lazyResolve;
    }

    public void setLazyResolve(boolean lazyResolve) {
        this.lazyResolve = lazyResolve;
    }

    public boolean resolve() throws Exception {
        return true;
    }

    public boolean resolve(LifeCycle ... lifecycles) throws Exception {
        if (lifecycles == null || lifecycles.length == 0) {
            return true;
        }
        boolean result = true;
        for (LifeCycle lifecycle : lifecycles) {
            if (lifecycle.isResolved() || lifecycle.resolve()) continue;
            result = false;
        }
        return result;
    }

    public void unresolve() throws Exception {
    }

    public void unresolve(LifeCycle ... lifecycles) throws Exception {
        if (lifecycles == null || lifecycles.length == 0) {
            return;
        }
        for (LifeCycle lifecycle : lifecycles) {
            if (!lifecycle.isResolved()) continue;
            lifecycle.unresolve();
        }
    }

    public void resolved() {
    }

    public void unresolved() {
    }

    public void bounce() throws Exception {
    }

    public void bounce(LifeCycle ... lifecycles) throws Exception {
        if (lifecycles == null || lifecycles.length == 0) {
            return;
        }
        for (LifeCycle lifecycle : lifecycles) {
            lifecycle.bounce();
        }
    }

    public boolean isStarted() {
        ControllerContext context = this.module.getControllerContext();
        if (context == null) {
            return false;
        }
        Controller controller = context.getController();
        ControllerStateModel model = controller.getStates();
        return !model.isBeforeState(context.getState(), ControllerState.INSTALLED);
    }

    public void start() throws Exception {
    }

    public void start(LifeCycle ... lifecycles) throws Exception {
        if (lifecycles == null || lifecycles.length == 0) {
            return;
        }
        for (LifeCycle lifecycle : lifecycles) {
            if (lifecycle.isStarted()) continue;
            lifecycle.start();
        }
    }

    public void stop() throws Exception {
    }

    public void stop(LifeCycle ... lifecycles) throws Exception {
        if (lifecycles == null || lifecycles.length == 0) {
            return;
        }
        for (LifeCycle lifecycle : lifecycles) {
            if (!lifecycle.isResolved()) continue;
            lifecycle.stop();
        }
    }

    protected void setUpLazyStart() {
        if (!this.isResolved() || this.isStarted()) {
            return;
        }
        if (this.lazyStartHandler != null) {
            return;
        }
        if (!(this.module instanceof ClassLoaderPolicyModule)) {
            throw new IllegalStateException("Cannot do lazy start for " + this.module);
        }
        ClassLoaderPolicy policy = ((ClassLoaderPolicyModule)this.module).getPolicy();
        this.lazyStartHandler = new LazyStartHandler(policy);
    }

    protected void removeLazyStart() {
        if (this.lazyStartHandler == null) {
            return;
        }
        this.lazyStartHandler.cleanup();
        this.lazyStartHandler = null;
    }

    void fireResolved() {
        if (this.isLazyStart()) {
            this.setUpLazyStart();
        }
        this.resolved();
    }

    void fireUnresolved() {
        this.removeLazyStart();
        this.unresolved();
    }

    public String toString() {
        return this.getClass().getName() + "{" + this.getModule() + "}";
    }

    private class LazyStartHandler
    implements ClassFoundHandler {
        ClassLoaderPolicy policy;

        public LazyStartHandler(ClassLoaderPolicy policy) {
            this.policy = policy;
            policy.addClassFoundHandler((ClassFoundHandler)this);
        }

        public void classFound(ClassFoundEvent event) {
            if (!LifeCycle.this.getLazyStartFilter().matchesClassName(event.getClassName())) {
                return;
            }
            LifeCycle.this.removeLazyStart();
            if (!LifeCycle.this.isStarted()) {
                try {
                    LifeCycle.this.start();
                }
                catch (Throwable t) {
                    log.warn((Object)("Error in lazy start for " + this), t);
                }
            }
        }

        public void cleanup() {
            this.policy.removeClassFoundHandler((ClassFoundHandler)this);
        }
    }
}

