/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices11.wsba.client;

import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices11.ServiceRegistry;
import com.arjuna.webservices11.SoapFault11;
import com.arjuna.webservices11.wsaddr.AddressingHelper;
import com.arjuna.webservices11.wsaddr.EndpointHelper;
import com.arjuna.webservices11.wsaddr.NativeEndpointReference;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsba.client.WSBAClient;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.jboss.ws.api.addressing.MAP;
import org.jboss.ws.api.addressing.MAPBuilder;
import org.jboss.ws.api.addressing.MAPBuilderFactory;
import org.jboss.ws.api.addressing.MAPEndpoint;
import org.oasis_open.docs.ws_tx.wsba._2006._06.BusinessAgreementWithCoordinatorCompletionParticipantPortType;
import org.oasis_open.docs.ws_tx.wsba._2006._06.NotificationType;
import org.oasis_open.docs.ws_tx.wsba._2006._06.StatusType;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class CoordinatorCompletionParticipantClient {
    private static final CoordinatorCompletionParticipantClient CLIENT = new CoordinatorCompletionParticipantClient();
    private String completeAction = null;
    private String closeAction = null;
    private String cancelAction = null;
    private String compensateAction = null;
    private String failedAction = null;
    private String exitedAction = null;
    private String notCompletedAction = null;
    private String getStatusAction = null;
    private String statusAction = null;
    private MAPEndpoint coordinatorCompletionCoordinator = null;
    private MAPEndpoint secureCoordinatorCompletionCoordinator = null;

    private CoordinatorCompletionParticipantClient() {
        MAPBuilder builder = MAPBuilderFactory.getInstance().getBuilderInstance();
        this.completeAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/Complete";
        this.closeAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/Close";
        this.cancelAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/Cancel";
        this.compensateAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/Compensate";
        this.failedAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/Failed";
        this.exitedAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/Exited";
        this.notCompletedAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/NotCompleted";
        this.getStatusAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/GetStatus";
        this.statusAction = "http://docs.oasis-open.org/ws-tx/wsba/2006/06/Status";
        String coordinatorCompletionCoordinatorURIString = ServiceRegistry.getRegistry().getServiceURI("BusinessAgreementWithCoordinatorCompletionCoordinatorService", false);
        String secureCoordinatorCompletionCoordinatorURIString = ServiceRegistry.getRegistry().getServiceURI("BusinessAgreementWithCoordinatorCompletionCoordinatorService", true);
        this.coordinatorCompletionCoordinator = builder.newEndpoint(coordinatorCompletionCoordinatorURIString);
        this.secureCoordinatorCompletionCoordinator = builder.newEndpoint(secureCoordinatorCompletionCoordinatorURIString);
    }

    public void sendComplete(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(endpoint, map);
        AddressingHelper.installFromFaultTo(map, coordinator, identifier);
        BusinessAgreementWithCoordinatorCompletionParticipantPortType port = this.getPort(endpoint, map, this.completeAction);
        NotificationType complete = new NotificationType();
        port.completeOperation(complete);
    }

    public void sendClose(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(endpoint, map);
        AddressingHelper.installFromFaultTo(map, coordinator, identifier);
        BusinessAgreementWithCoordinatorCompletionParticipantPortType port = this.getPort(endpoint, map, this.closeAction);
        NotificationType close = new NotificationType();
        port.closeOperation(close);
    }

    public void sendCancel(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(endpoint, map);
        AddressingHelper.installFromFaultTo(map, coordinator, identifier);
        BusinessAgreementWithCoordinatorCompletionParticipantPortType port = this.getPort(endpoint, map, this.cancelAction);
        NotificationType cancel = new NotificationType();
        port.cancelOperation(cancel);
    }

    public void sendCompensate(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(endpoint, map);
        AddressingHelper.installFromFaultTo(map, coordinator, identifier);
        BusinessAgreementWithCoordinatorCompletionParticipantPortType port = this.getPort(endpoint, map, this.compensateAction);
        NotificationType compensate = new NotificationType();
        port.compensateOperation(compensate);
    }

    public void sendFailed(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(endpoint, map);
        AddressingHelper.installFaultTo(map, coordinator, identifier);
        BusinessAgreementWithCoordinatorCompletionParticipantPortType port = this.getPort(endpoint, map, this.failedAction);
        NotificationType failed = new NotificationType();
        port.failedOperation(failed);
    }

    public void sendExited(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(endpoint, map);
        AddressingHelper.installFaultTo(map, coordinator, identifier);
        BusinessAgreementWithCoordinatorCompletionParticipantPortType port = this.getPort(endpoint, map, this.exitedAction);
        NotificationType exit = new NotificationType();
        port.exitedOperation(exit);
    }

    public void sendNotCompleted(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(endpoint, map);
        AddressingHelper.installFaultTo(map, coordinator, identifier);
        BusinessAgreementWithCoordinatorCompletionParticipantPortType port = this.getPort(endpoint, map, this.notCompletedAction);
        NotificationType notCompleted = new NotificationType();
        port.notCompleted(notCompleted);
    }

    public void sendGetStatus(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(endpoint, map);
        AddressingHelper.installFromFaultTo(map, coordinator, identifier);
        BusinessAgreementWithCoordinatorCompletionParticipantPortType port = this.getPort(endpoint, map, this.getStatusAction);
        NotificationType getStatus = new NotificationType();
        port.getStatusOperation(getStatus);
    }

    public void sendStatus(W3CEndpointReference endpoint, MAP map, InstanceIdentifier identifier, QName state) throws SoapFault, IOException {
        MAPEndpoint coordinator = this.getCoordinator(endpoint, map);
        AddressingHelper.installFromFaultTo(map, coordinator, identifier);
        BusinessAgreementWithCoordinatorCompletionParticipantPortType port = this.getPort(endpoint, map, this.statusAction);
        StatusType status = new StatusType();
        status.setState(state);
        port.statusOperation(status);
    }

    public void sendSoapFault(SoapFault11 soapFault, W3CEndpointReference endpoint, MAP map, String faultAction) throws SoapFault, IOException {
        AddressingHelper.installNoneReplyTo(map);
        map.setAction(faultAction);
        BusinessAgreementWithCoordinatorCompletionParticipantPortType port = this.getPort(endpoint, map, faultAction);
        Fault fault = soapFault.toFault();
        port.soapFault(fault);
    }

    MAPEndpoint getCoordinator(W3CEndpointReference endpoint, MAP map) {
        String address;
        if (endpoint != null) {
            NativeEndpointReference nativeRef = EndpointHelper.transform(NativeEndpointReference.class, (EndpointReference)endpoint);
            address = nativeRef.getAddress();
        } else {
            address = map.getTo();
        }
        if (address.startsWith("https")) {
            return this.secureCoordinatorCompletionCoordinator;
        }
        return this.coordinatorCompletionCoordinator;
    }

    public static CoordinatorCompletionParticipantClient getClient() {
        return CLIENT;
    }

    private BusinessAgreementWithCoordinatorCompletionParticipantPortType getPort(W3CEndpointReference participant, MAP map, String action) {
        AddressingHelper.installNoneReplyTo(map);
        if (participant != null) {
            return WSBAClient.getCoordinatorCompletionParticipantPort(participant, action, map);
        }
        return WSBAClient.getCoordinatorCompletionParticipantPort(action, map);
    }
}

