/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.bootstrap.standalone;

import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BeanXMLDeployer;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.util.CollectionsFactory;

public class StandaloneBootstrap
extends BasicBootstrap {
    protected BeanXMLDeployer deployer;
    protected List deployments = CollectionsFactory.createCopyOnWriteList();
    protected String[] args;

    public static void main(String[] args) throws Exception {
        StandaloneBootstrap bootstrap = new StandaloneBootstrap(args);
        bootstrap.run();
    }

    public StandaloneBootstrap(String[] args) throws Exception {
        this.args = args;
    }

    public void bootstrap() throws Throwable {
        URL url;
        super.bootstrap();
        this.deployer = new BeanXMLDeployer(this.getKernel());
        Runtime.getRuntime().addShutdownHook(new Shutdown());
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> e = cl.getResources("jboss-beans.xml");
        while (e.hasMoreElements()) {
            url = e.nextElement();
            this.deploy(url);
        }
        e = cl.getResources("META-INF/jboss-beans.xml");
        while (e.hasMoreElements()) {
            url = e.nextElement();
            this.deploy(url);
        }
        this.deployer.validate();
    }

    protected void deploy(URL url) throws Throwable {
        this.log.debug((Object)("Deploying " + url));
        KernelDeployment deployment = this.deployer.deploy(url);
        this.deployments.add(deployment);
        this.log.debug((Object)("Deployed " + url));
    }

    protected void undeploy(KernelDeployment deployment) {
        this.log.debug((Object)("Undeploying " + deployment.getName()));
        this.deployments.remove(deployment);
        try {
            this.deployer.undeploy(deployment);
            this.log.debug((Object)("Undeployed " + deployment.getName()));
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during undeployment: " + deployment.getName()), t);
        }
    }

    protected class Shutdown
    extends Thread {
        protected Shutdown() {
        }

        public void run() {
            StandaloneBootstrap.this.log.info((Object)"Shutting down");
            ListIterator iterator = StandaloneBootstrap.this.deployments.listIterator(StandaloneBootstrap.this.deployments.size());
            while (iterator.hasPrevious()) {
                KernelDeployment deployment = (KernelDeployment)iterator.previous();
                StandaloneBootstrap.this.undeploy(deployment);
            }
        }
    }
}

