/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.LogManager;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.modules.ClassPathModuleFinder;
import org.jboss.modules.DefaultBootModuleLoaderHolder;
import org.jboss.modules.DelegatingModuleLoader;
import org.jboss.modules.DependencyTreeViewer;
import org.jboss.modules.FileSystemClassPathModuleFinder;
import org.jboss.modules.LocalModuleFinder;
import org.jboss.modules.ModularContentHandlerFactory;
import org.jboss.modules.ModularURLStreamHandlerProvider;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleLoggerFinder;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.ModulesPolicy;
import org.jboss.modules.PreMain;
import org.jboss.modules.PropertyWriteAction;
import org.jboss.modules.SecurityActions;
import org.jboss.modules.StartTimeHolder;
import org.jboss.modules.log.JDKModuleLogger;
import org.jboss.modules.log.StreamModuleLogger;

public final class Main {
    private static final String[] NO_STRINGS;
    static volatile Instrumentation instrumentation;
    private static final String JAR_NAME;
    private static final String VERSION_STRING;

    private Main() {
    }

    private static void usage() {
        System.out.println("Usage: java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] <module-spec> [args...]");
        System.out.println("       java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] -jar <jar-name> [args...]");
        System.out.println("       java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] -cp <class-path> <class-name> [args...]");
        System.out.println("       java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] -class <class-name> [args...]");
        System.out.println("where <module-spec> is a valid module specification string");
        System.out.println("and options include:");
        System.out.println("    -help         Display this message");
        System.out.println("    -mp, -modulepath <search path of directories>");
        System.out.println("                  A list of directories, separated by '" + File.pathSeparator + "', where modules may be located");
        System.out.println("                  If not specified, the value of the \"module.path\" system property is used");
        System.out.println("    -class        Specify that the final argument is a");
        System.out.println("                  class to load from the class path; not compatible with -jar");
        System.out.println("    -cp,-classpath <search path of archives or directories>");
        System.out.println("                  A search path for class files; implies -class");
        System.out.println("    -dep,-dependencies <module-spec>[,<module-spec>,...]");
        System.out.println("                  A list of module dependencies to add to the class path;");
        System.out.println("                  requires -class or -cp");
        System.out.println("    -deptree      Print the dependency tree of the given module instead of running it");
        System.out.println("    -debuglog     Enable debug mode output to System.out during bootstrap before any logging manager is installed");
        System.out.println("    -jar          Specify that the final argument is the name of a");
        System.out.println("                  JAR file to run as a module; not compatible with -class");
        System.out.println("    -javaagent:agent.jar");
        System.out.println("                  Add a Java agent that can load modules");
        System.out.println("    -secmgr       Run with a security manager installed; not compatible with -secmgrmodule");
        System.out.println("    -secmgrmodule <module-spec>");
        System.out.println("                  Run with a security manager module; not compatible with -secmgr");
        System.out.println("    -add-provider <module-name>[/<class-name>]");
        System.out.println("                  Add a security provider of the given module and class (can be given more than once)");
        System.out.println("    -version      Print version and exit\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        String mbeanServerBuilderName;
        String logManagerName;
        Module module;
        String className;
        String moduleName;
        ModuleLoader loader;
        int argsLen = args.length;
        String deps = null;
        String[] moduleArgs = NO_STRINGS;
        String modulePath = null;
        String classpath = null;
        boolean jar = false;
        boolean classpathDefined = false;
        boolean classDefined = false;
        boolean depTree = false;
        String nameArgument = null;
        boolean defaultSecMgr = false;
        String secMgrModule = null;
        boolean debuglog = false;
        ArrayList<String> agentJars = new ArrayList<String>();
        ArrayList<String> addedProviders = new ArrayList<String>();
        for (int i = 0; i < argsLen; ++i) {
            String arg = args[i];
            try {
                if (arg.charAt(0) == '-') {
                    if ("-version".equals(arg)) {
                        System.out.println("JBoss Modules version " + Main.getVersionString());
                        return;
                    }
                    if ("-help".equals(arg)) {
                        Main.usage();
                        return;
                    }
                    if ("-modulepath".equals(arg) || "-mp".equals(arg)) {
                        if (modulePath != null) {
                            System.err.println("Module path may only be specified once");
                            System.exit(1);
                        }
                        modulePath = args[++i];
                        System.setProperty("module.path", modulePath);
                        continue;
                    }
                    if ("-deptree".equals(arg)) {
                        if (depTree) {
                            System.err.println("-deptree may only be specified once");
                            System.exit(1);
                        }
                        if (jar) {
                            System.err.println("-deptree may not be specified with -jar");
                            System.exit(1);
                        }
                        if (classDefined) {
                            System.err.println("-deptree may not be specified with -class");
                            System.exit(1);
                        }
                        if (classpathDefined) {
                            System.err.println("-deptree may not be specified with -classpath");
                            System.exit(1);
                        }
                        depTree = true;
                        continue;
                    }
                    if ("-debuglog".equals(arg)) {
                        debuglog = true;
                        continue;
                    }
                    if ("-jar".equals(arg)) {
                        if (jar) {
                            System.err.println("-jar flag may only be specified once");
                            System.exit(1);
                        }
                        if (classpathDefined) {
                            System.err.println("-cp/-classpath may not be specified with -jar");
                            System.exit(1);
                        }
                        if (classDefined) {
                            System.err.println("-class may not be specified with -jar");
                            System.exit(1);
                        }
                        if (depTree) {
                            System.err.println("-deptree may not be specified with -jar");
                            System.exit(1);
                        }
                        jar = true;
                        continue;
                    }
                    if ("-cp".equals(arg) || "-classpath".equals(arg)) {
                        if (classpathDefined) {
                            System.err.println("-cp or -classpath may only be specified once.");
                            System.exit(1);
                        }
                        if (classDefined) {
                            System.err.println("-class may not be specified with -cp/classpath");
                            System.exit(1);
                        }
                        if (jar) {
                            System.err.println("-cp/-classpath may not be specified with -jar");
                            System.exit(1);
                        }
                        if (depTree) {
                            System.err.println("-deptree may not be specified with -classpath");
                            System.exit(1);
                        }
                        classpathDefined = true;
                        classpath = args[++i];
                        AccessController.doPrivileged(new PropertyWriteAction("java.class.path", classpath));
                        continue;
                    }
                    if ("-dep".equals(arg) || "-dependencies".equals(arg)) {
                        if (deps != null) {
                            System.err.println("-dep or -dependencies may only be specified once.");
                            System.exit(1);
                        }
                        deps = args[++i];
                        continue;
                    }
                    if ("-class".equals(arg)) {
                        if (classDefined) {
                            System.err.println("-class flag may only be specified once");
                            System.exit(1);
                        }
                        if (classpathDefined) {
                            System.err.println("-class may not be specified with -cp/classpath");
                            System.exit(1);
                        }
                        if (jar) {
                            System.err.println("-class may not be specified with -jar");
                            System.exit(1);
                        }
                        if (depTree) {
                            System.err.println("-deptree may not be specified with -class");
                            System.exit(1);
                        }
                        classDefined = true;
                        continue;
                    }
                    if ("-secmgr".equals(arg)) {
                        if (defaultSecMgr) {
                            System.err.println("-secmgr may only be specified once");
                            System.exit(1);
                        }
                        if (secMgrModule != null) {
                            System.err.println("-secmgr may not be specified when -secmgrmodule is given");
                            System.exit(1);
                        }
                        defaultSecMgr = true;
                        continue;
                    }
                    if ("-secmgrmodule".equals(arg)) {
                        if (secMgrModule != null) {
                            System.err.println("-secmgrmodule may only be specified once");
                            System.exit(1);
                        }
                        if (defaultSecMgr) {
                            System.err.println("-secmgrmodule may not be specified when -secmgr is given");
                            System.exit(1);
                        }
                        secMgrModule = args[++i];
                        continue;
                    }
                    if ("-add-provider".equals(arg)) {
                        addedProviders.add(args[++i]);
                        continue;
                    }
                    if (arg.startsWith("-javaagent:")) {
                        agentJars.add(arg.substring(11));
                        continue;
                    }
                    System.err.printf("Invalid option '%s'%n", arg);
                    Main.usage();
                    System.exit(1);
                    continue;
                }
                nameArgument = arg;
                int cnt = argsLen - i - 1;
                moduleArgs = new String[cnt];
                System.arraycopy(args, i + 1, moduleArgs, 0, cnt);
                break;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.printf("Argument expected for option '%s'%n", arg);
                Main.usage();
                System.exit(1);
            }
        }
        if (deps != null && !classDefined && !classpathDefined) {
            System.err.println("-deps may only be specified when -cp/-classpath or -class is in use");
            System.exit(1);
        }
        if (nameArgument == null) {
            if (classDefined || classpathDefined) {
                System.err.println("No class name specified");
            } else if (jar) {
                System.err.println("No JAR specified");
            } else {
                System.err.println("No module specified");
            }
            Main.usage();
            System.exit(1);
        }
        ModuleLoader environmentLoader = DefaultBootModuleLoaderHolder.INSTANCE;
        Path rootPath = Paths.get("", new String[0]).toAbsolutePath();
        if (jar) {
            loader = new ModuleLoader(new FileSystemClassPathModuleFinder(environmentLoader));
            moduleName = rootPath.resolve(nameArgument).normalize().toString();
            className = null;
        } else if (classpathDefined || classDefined) {
            String[] items;
            if (classpath != null) {
                AccessController.doPrivileged(new PropertyWriteAction("java.class.path", classpath));
                items = classpath.split(Pattern.quote(File.pathSeparator));
            } else {
                items = NO_STRINGS;
            }
            for (int i = 0; i < items.length; ++i) {
                items[i] = rootPath.resolve(items[i]).normalize().toString();
            }
            loader = new DelegatingModuleLoader(environmentLoader, new ClassPathModuleFinder(environmentLoader, items, deps, nameArgument));
            moduleName = "<classpath>";
            className = null;
        } else {
            loader = environmentLoader;
            int idx = nameArgument.lastIndexOf(47);
            if (idx != -1) {
                moduleName = nameArgument.substring(0, idx);
                className = nameArgument.substring(idx + 1);
            } else {
                moduleName = nameArgument;
                className = null;
            }
        }
        Module.initBootModuleLoader(environmentLoader);
        if (depTree) {
            DependencyTreeViewer.print(new PrintWriter(System.out), nameArgument, LocalModuleFinder.getRepoRoots(true));
            System.exit(0);
        }
        if (debuglog) {
            Module.setModuleLogger(new StreamModuleLogger(System.out));
        }
        if (moduleName == null) {
            return;
        }
        try {
            module = loader.loadModule(moduleName);
        }
        catch (ModuleNotFoundException e) {
            e.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        int actualVersion = Runtime.version().feature();
        String requireJavaVersion = module.getProperty("jboss.require-java-version", Integer.toString(actualVersion));
        Pattern versionPattern = Pattern.compile("(?:1\\.)?(\\d+)");
        Matcher requireMatcher = versionPattern.matcher(requireJavaVersion);
        if (requireMatcher.matches() && Integer.parseInt(requireMatcher.group(1)) > actualVersion) {
            System.err.printf("This application requires Java specification version %s or later to run (this Java virtual machine implements specification version %s)%n", requireJavaVersion, actualVersion);
            System.exit(1);
        }
        ModularURLStreamHandlerProvider.addHandlerModule(module);
        ModularContentHandlerFactory.addHandlerModule(module);
        SecurityManager existingSecMgr = System.getSecurityManager();
        if (existingSecMgr != null) {
            System.err.println("An existing security manager was detected.  You must use the -secmgr switch to start with a security manager.");
            System.exit(1);
            return;
        }
        try {
            Iterator<Policy> iterator = module.loadService(Policy.class).iterator();
            if (iterator.hasNext()) {
                Policy.setPolicy(iterator.next());
            }
        }
        catch (Exception iterator) {
            // empty catch block
        }
        ModulesPolicy policy = new ModulesPolicy(Policy.getPolicy());
        Policy.setPolicy(policy);
        if (secMgrModule != null) {
            Module loadedModule;
            try {
                loadedModule = environmentLoader.loadModule(secMgrModule);
            }
            catch (ModuleNotFoundException e) {
                e.printStackTrace(System.err);
                System.exit(1);
                return;
            }
            Iterator<SecurityManager> iterator = ServiceLoader.load(SecurityManager.class, loadedModule.getClassLoaderPrivate()).iterator();
            if (iterator.hasNext()) {
                System.setSecurityManager(iterator.next());
            } else {
                System.err.println("No security manager found in module " + secMgrModule);
                System.exit(1);
            }
        }
        if (defaultSecMgr) {
            Iterator<SecurityManager> iterator = module.loadService(SecurityManager.class).iterator();
            if (iterator.hasNext()) {
                System.setSecurityManager(iterator.next());
            } else {
                System.setSecurityManager(new SecurityManager());
            }
        }
        ModuleClassLoader bootClassLoader = module.getClassLoaderPrivate();
        SecurityActions.setContextClassLoader(bootClassLoader);
        String serviceName = Main.getServiceName(bootClassLoader, "java.util.prefs.PreferencesFactory");
        if (serviceName != null) {
            String old = System.setProperty("java.util.prefs.PreferencesFactory", serviceName);
            try {
                Preferences.systemRoot();
            }
            finally {
                if (old == null) {
                    System.clearProperty("java.util.prefs.PreferencesFactory");
                } else {
                    System.setProperty("java.util.prefs.PreferencesFactory", old);
                }
            }
        }
        if ((logManagerName = Main.getServiceName(bootClassLoader, "java.util.logging.LogManager")) != null) {
            System.setProperty("java.util.logging.manager", logManagerName);
            if (LogManager.getLogManager().getClass() == LogManager.class) {
                System.err.println("WARNING: Failed to load the specified log manager class " + logManagerName);
            } else {
                Module.setModuleLogger(new JDKModuleLogger());
            }
        }
        ModuleLoggerFinder.activate(bootClassLoader);
        if (!agentJars.isEmpty()) {
            Instrumentation instrumentation = Main.instrumentation;
            if (instrumentation == null) {
                System.err.println("Not started in agent mode (self-attach not supported yet)");
                Main.usage();
                System.exit(1);
            }
            ModuleLoader agentLoader = new ModuleLoader(new FileSystemClassPathModuleFinder(loader));
            for (String agentJarArg : agentJars) {
                Manifest manifest;
                Module agentModule;
                String agentArgs;
                String agentJar;
                int i = agentJarArg.indexOf(61);
                if (i > 0) {
                    agentJar = agentJarArg.substring(0, i);
                    agentArgs = agentJarArg.length() > i + 1 ? agentJarArg.substring(i + 1) : "";
                } else {
                    agentJar = agentJarArg;
                    agentArgs = "";
                }
                try {
                    agentModule = agentLoader.loadModule(new File(agentJar).getAbsolutePath());
                }
                catch (ModuleLoadException ex) {
                    System.err.printf("Cannot load agent JAR %s: %s", agentJar, ex);
                    System.exit(1);
                    throw new IllegalStateException();
                }
                ModuleClassLoader classLoader = agentModule.getClassLoaderPrivate();
                InputStream is = classLoader.getResourceAsStream("META-INF/MANIFEST.MF");
                if (is == null) {
                    System.err.printf("Agent JAR %s has no manifest", agentJar);
                    System.exit(1);
                    throw new IllegalStateException();
                }
                try {
                    manifest = new Manifest();
                    manifest.read(is);
                    is.close();
                }
                catch (IOException e) {
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.addSuppressed(e);
                        throw e2;
                    }
                    throw e;
                }
                Attributes attributes = manifest.getMainAttributes();
                String preMainClassName = attributes.getValue("Premain-Class");
                if (preMainClassName != null) {
                    Object[] premainArgs;
                    Method premain;
                    Class<?> preMainClass = Class.forName(preMainClassName, true, classLoader);
                    try {
                        premain = preMainClass.getDeclaredMethod("premain", String.class, Instrumentation.class);
                        premainArgs = new Object[]{agentArgs, instrumentation};
                    }
                    catch (NoSuchMethodException ignore) {
                        premain = preMainClass.getDeclaredMethod("premain", String.class);
                        premainArgs = new Object[]{agentArgs};
                    }
                    catch (Exception e) {
                        System.out.printf("Failed to find premain method: %s", e);
                        System.exit(1);
                        throw new IllegalStateException();
                    }
                    try {
                        premain.invoke(null, premainArgs);
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        System.out.printf("Execution of premain method failed: %s", e.getCause());
                        System.exit(1);
                        throw new IllegalStateException();
                    }
                }
                System.out.printf("Agent JAR %s has no premain method", agentJar);
                System.exit(1);
                throw new IllegalStateException();
            }
        }
        if ((mbeanServerBuilderName = Main.getServiceName(bootClassLoader, "javax.management.MBeanServerBuilder")) != null) {
            System.setProperty("javax.management.builder.initial", mbeanServerBuilderName);
            ManagementFactory.getPlatformMBeanServer();
        }
        block33: for (String addedProvider : addedProviders) {
            int idx = addedProvider.indexOf(47);
            if (idx != -1) {
                String provModule = addedProvider.substring(0, idx);
                String provClazz = addedProvider.substring(idx + 1);
                try {
                    Class<Provider> providerClass = Class.forName(provClazz, false, environmentLoader.loadModule(provModule).getClassLoaderPrivate()).asSubclass(Provider.class);
                    AccessController.doPrivileged(new AddProviderAction(providerClass.getConstructor(new Class[0]).newInstance(new Object[0])), Main.getProviderContext(providerClass));
                }
                catch (Exception e) {
                    Module.getModuleLogger().trace(e, "Failed to initialize a security provider");
                }
                continue;
            }
            ModuleClassLoader classLoader = environmentLoader.loadModule(addedProvider).getClassLoaderPrivate();
            ServiceLoader<Provider> providerServiceLoader = ServiceLoader.load(Provider.class, classLoader);
            Iterator<Provider> iterator = providerServiceLoader.iterator();
            while (true) {
                try {
                    while (true) {
                        if (!iterator.hasNext()) {
                            Module.getModuleLogger().trace("Module \"%s\" did not contain a security provider service", (Object)addedProvider);
                            continue block33;
                        }
                        Provider provider = iterator.next();
                        Class<?> providerClass = provider.getClass();
                        AccessController.doPrivileged(new AddProviderAction(provider), Main.getProviderContext(providerClass));
                    }
                }
                catch (RuntimeException | ServiceConfigurationError e) {
                    Module.getModuleLogger().trace(e, "Failed to initialize a security provider");
                    continue;
                }
                break;
            }
        }
        ServiceLoader<Provider> providerServiceLoader = ServiceLoader.load(Provider.class, bootClassLoader);
        Iterator<Provider> iterator = providerServiceLoader.iterator();
        while (true) {
            try {
                while (iterator.hasNext()) {
                    Provider provider = iterator.next();
                    Class<?> providerClass = provider.getClass();
                    AccessController.doPrivileged(new AddProviderAction(provider), Main.getProviderContext(providerClass));
                }
            }
            catch (RuntimeException | ServiceConfigurationError e) {
                Module.getModuleLogger().trace(e, "Failed to initialize a security provider");
                continue;
            }
            break;
        }
        ModuleLoader.installMBeanServer();
        ArrayList<String> argsList = new ArrayList<String>(moduleArgs.length);
        Collections.addAll(argsList, moduleArgs);
        ServiceLoader<PreMain> preMainServiceLoader = ServiceLoader.load(PreMain.class, bootClassLoader);
        for (PreMain preMain : preMainServiceLoader) {
            preMain.run(argsList);
        }
        try {
            String[] argsArray = argsList.toArray(NO_STRINGS);
            if (className != null) {
                module.run(className, argsArray);
            } else {
                module.run(argsArray);
            }
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private static AccessControlContext getProviderContext(Class<? extends Provider> providerClass) {
        return new AccessControlContext(new ProtectionDomain[]{providerClass.getProtectionDomain()});
    }

    private static String getServiceName(ClassLoader classLoader, String className) throws IOException {
        try (InputStream stream = classLoader.getResourceAsStream("META-INF/services/" + className);){
            String line;
            if (stream == null) {
                String string = null;
                return string;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                int i = line.indexOf(35);
                if (i != -1) {
                    line = line.substring(0, i);
                }
                if ((line = line.trim()).length() == 0) continue;
                String string = line;
                return string;
            }
            String string = null;
            return string;
        }
    }

    public static String getJarName() {
        return JAR_NAME;
    }

    public static String getVersionString() {
        return VERSION_STRING;
    }

    static {
        String versionString;
        String jarName;
        block13: {
            long l = StartTimeHolder.START_TIME;
            NO_STRINGS = new String[0];
            Properties versionProps = new Properties();
            jarName = "(unknown)";
            versionString = "(unknown)";
            try (InputStream stream = Main.class.getResourceAsStream("version.properties");){
                if (stream == null) break block13;
                try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    versionProps.load(reader);
                    jarName = versionProps.getProperty("jarName", jarName);
                    versionString = versionProps.getProperty("version", versionString);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        JAR_NAME = jarName;
        VERSION_STRING = versionString;
    }

    static final class AddProviderAction
    implements PrivilegedAction<Void> {
        private final Provider provider;

        AddProviderAction(Provider provider) {
            this.provider = provider;
        }

        @Override
        public Void run() {
            Security.addProvider(this.provider);
            return null;
        }
    }
}

