/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.cache;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.client.cache.BrowserCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LightweightBrowserCache
implements BrowserCache {
    protected long maxBytes = 2000000L;
    protected volatile CacheHolder holder = new CacheHolder();

    public long getMaxBytes() {
        return this.maxBytes;
    }

    public void setMaxBytes(long maxBytes) {
        this.maxBytes = maxBytes;
    }

    public long getByteCount() {
        return this.holder.bytes.get();
    }

    @Override
    public BrowserCache.Entry getAny(String key) {
        Map<MediaType, BrowserCache.Entry> parent = this.holder.cache.get(key);
        if (parent == null) {
            return null;
        }
        Iterator<BrowserCache.Entry> iterator = parent.values().iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Override
    public void remove(String key, MediaType type) {
        CacheHolder tmpHolder = this.holder;
        Map<MediaType, BrowserCache.Entry> parent = tmpHolder.cache.get(key);
        if (parent == null) {
            return;
        }
        BrowserCache.Entry entry = parent.remove(type);
        if (entry != null) {
            tmpHolder.bytes.addAndGet(-1 * entry.getCached().length);
        }
    }

    @Override
    public BrowserCache.Entry get(String key, MediaType accept) {
        Map<MediaType, BrowserCache.Entry> parent = this.holder.cache.get(key);
        if (parent == null) {
            return null;
        }
        return parent.get(accept);
    }

    @Override
    public BrowserCache.Entry put(String key, MediaType mediaType, MultivaluedMap<String, String> headers, byte[] cached, int expires, String etag, String lastModified) {
        Map<MediaType, BrowserCache.Entry> map;
        CacheEntry cacheEntry = new CacheEntry(key, headers, cached, expires, etag, lastModified, mediaType);
        CacheHolder tmpHolder = this.holder;
        if (tmpHolder.bytes.addAndGet(cached.length) > this.maxBytes) {
            tmpHolder = new CacheHolder();
            tmpHolder.bytes.addAndGet(cached.length);
            this.holder = tmpHolder;
        }
        if ((map = tmpHolder.cache.get(key)) == null) {
            map = new ConcurrentHashMap<MediaType, BrowserCache.Entry>();
            Map<MediaType, BrowserCache.Entry> tmp = tmpHolder.cache.putIfAbsent(key, map);
            map = tmp == null ? map : tmp;
        }
        map.put(mediaType, cacheEntry);
        return cacheEntry;
    }

    @Override
    public void clear() {
        this.holder.cache.clear();
    }

    private static class CacheHolder {
        protected AtomicLong bytes = new AtomicLong(0L);
        protected ConcurrentHashMap<String, Map<MediaType, BrowserCache.Entry>> cache = new ConcurrentHashMap();

        private CacheHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheEntry
    implements BrowserCache.Entry {
        private final MediaType mediaType;
        private final byte[] cached;
        private final int expires;
        private final long timestamp = System.currentTimeMillis();
        private final MultivaluedMap<String, String> headers;
        private BrowserCache.Header[] validationHeaders = new BrowserCache.Header[0];
        private final String key;

        public CacheEntry(String key, MultivaluedMap<String, String> headers, byte[] cached, int expires, String etag, String lastModified, MediaType mediaType) {
            this.key = key;
            this.cached = cached;
            this.expires = expires;
            this.mediaType = mediaType;
            this.headers = headers;
            if (etag != null || lastModified != null) {
                if (etag != null && lastModified != null) {
                    this.validationHeaders = new BrowserCache.Header[2];
                    this.validationHeaders[0] = new BrowserCache.Header("If-Modified-Since", lastModified);
                    this.validationHeaders[1] = new BrowserCache.Header("If-None-Match", etag);
                } else if (etag != null) {
                    this.validationHeaders = new BrowserCache.Header[1];
                    this.validationHeaders[0] = new BrowserCache.Header("If-None-Match", etag);
                } else if (lastModified != null) {
                    this.validationHeaders = new BrowserCache.Header[1];
                    this.validationHeaders[0] = new BrowserCache.Header("If-Modified-Since", lastModified);
                }
            }
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public MultivaluedMap<String, String> getHeaders() {
            return this.headers;
        }

        @Override
        public boolean expired() {
            return System.currentTimeMillis() - this.timestamp >= (long)(this.expires * 1000);
        }

        @Override
        public BrowserCache.Header[] getValidationHeaders() {
            return this.validationHeaders;
        }

        @Override
        public byte[] getCached() {
            return this.cached;
        }

        @Override
        public MediaType getMediaType() {
            return this.mediaType;
        }
    }
}

