/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.core.interception.MessageBodyReaderContextImpl;
import org.jboss.resteasy.core.interception.MessageBodyReaderInterceptor;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GenericType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseClientResponse<T>
extends ClientResponse<T> {
    protected ResteasyProviderFactory providerFactory;
    protected String attributeExceptionsTo;
    protected MultivaluedMap<String, String> headers;
    protected String alternateMediaType;
    protected Class<?> returnType;
    protected Type genericReturnType;
    protected Annotation[] annotations;
    protected int status;
    protected boolean wasReleased = false;
    protected boolean streamWasRead = false;
    protected byte[] rawResults;
    protected Object unmarshaledEntity;
    protected MessageBodyReaderInterceptor[] messageBodyReaderInterceptors;
    protected Exception exception;
    protected boolean cacheInputStream;

    public void setMessageBodyReaderInterceptors(MessageBodyReaderInterceptor[] messageBodyReaderInterceptors) {
        this.messageBodyReaderInterceptors = messageBodyReaderInterceptors;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        this.headers = headers;
    }

    public void setProviderFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void setReturnType(Class<T> returnType) {
        this.returnType = returnType;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setGenericReturnType(Type genericReturnType) {
        this.genericReturnType = genericReturnType;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public String getAttributeExceptionsTo() {
        return this.attributeExceptionsTo;
    }

    public void setAttributeExceptionsTo(String attributeExceptionsTo) {
        this.attributeExceptionsTo = attributeExceptionsTo;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public String getResponseHeader(String headerKey) {
        if (this.headers == null) {
            return null;
        }
        return (String)this.headers.getFirst((Object)headerKey);
    }

    public void setAlternateMediaType(String alternateMediaType) {
        this.alternateMediaType = alternateMediaType;
    }

    @Override
    public T getEntity() {
        if (this.exception != null) {
            throw new RuntimeException("Unable to unmarshall response for " + this.attributeExceptionsTo, this.exception);
        }
        if (this.returnType == null) {
            throw new RuntimeException("No type information to extract entity with, use other getEntity() methods");
        }
        if (this.genericReturnType == null) {
            this.genericReturnType = this.returnType;
        }
        return (T)this.getEntity(this.returnType, this.genericReturnType);
    }

    @Override
    public <T2> T2 getEntity(Class<T2> type, Type genericType) {
        Annotation[] annotations = null;
        if (this.returnType == type && this.genericReturnType == genericType) {
            annotations = this.annotations;
        }
        return this.getEntity(type, genericType, annotations);
    }

    @Override
    public <T2> T2 getEntity(Class<T2> type, Type genericType, Annotation[] anns) {
        if (this.streamWasRead) {
            if (this.unmarshaledEntity != null) {
                if (type.isInstance(this.unmarshaledEntity)) {
                    return (T2)this.unmarshaledEntity;
                }
                throw new RuntimeException("The entity was already read, and it was of type " + this.unmarshaledEntity.getClass());
            }
            throw new RuntimeException("Stream was already read");
        }
        try {
            Object object;
            MediaType media;
            MessageBodyReader<T2> reader;
            if (this.status == 204) {
                T2 T2 = null;
                return T2;
            }
            String mediaType = (String)this.headers.getFirst((Object)"Content-Type");
            if (mediaType == null) {
                mediaType = this.alternateMediaType;
            }
            if ((reader = this.providerFactory.getMessageBodyReader(type, genericType, anns, media = mediaType == null ? MediaType.WILDCARD_TYPE : MediaType.valueOf((String)mediaType))) == null) {
                throw this.createResponseFailure("Unable to find a MessageBodyReader of content-type " + mediaType + " and type " + type.getName());
            }
            try {
                this.streamWasRead = true;
                object = this.unmarshaledEntity = this.readFrom(type, genericType, media, anns, reader);
            }
            catch (Exception e) {
                this.exception = e;
                throw this.createResponseFailure("Failure reading from MessageBodyReader: " + reader.getClass().getName(), e);
            }
            return (T2)object;
        }
        finally {
            this.releaseConnection();
        }
    }

    protected <T2> Object readFrom(Class<T2> type, Type genericType, MediaType media, Annotation[] annotations, MessageBodyReader<T2> reader) throws IOException {
        if (this.messageBodyReaderInterceptors != null && this.messageBodyReaderInterceptors.length > 0) {
            MessageBodyReaderContextImpl ctx = new MessageBodyReaderContextImpl(this.messageBodyReaderInterceptors, reader, type, genericType, annotations, media, this.headers, this.getInputStream());
            return ctx.proceed();
        }
        return reader.readFrom(type, genericType, annotations, media, this.headers, this.getInputStream());
    }

    @Override
    public <T2> T2 getEntity(GenericType<T2> genericType) {
        return this.getEntity(genericType.getType(), genericType.getGenericType());
    }

    @Override
    public <T2> T2 getEntity(GenericType<T2> genericType, Annotation[] ann) {
        return this.getEntity(genericType.getType(), genericType.getGenericType(), ann);
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        MultivaluedMap<String, String> map = this.headers;
        return map;
    }

    public int getStatus() {
        return this.status;
    }

    public void checkFailureStatus() {
        if (this.status > 399 && this.status < 599) {
            throw this.createResponseFailure("Error status " + this.status + " " + Response.Status.fromStatusCode((int)this.status) + " returned");
        }
    }

    public ClientResponseFailure createResponseFailure(String message) {
        return this.createResponseFailure(message, null);
    }

    public ClientResponseFailure createResponseFailure(String message, Exception e) {
        this.setException(e);
        this.returnType = byte[].class;
        this.genericReturnType = null;
        return new ClientResponseFailure(message, e, this);
    }

    @Override
    public Response.Status getResponseStatus() {
        return Response.Status.fromStatusCode((int)this.getStatus());
    }

    public boolean wasReleased() {
        return this.wasReleased;
    }

    public abstract InputStream getInputStream() throws IOException;

    public abstract void releaseConnection();
}

