/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.interception.ClientInterceptor;
import org.jboss.resteasy.core.interception.MessageBodyReaderContext;
import org.jboss.resteasy.core.interception.MessageBodyReaderInterceptor;
import org.jboss.resteasy.core.interception.ServerInterceptor;

@Provider
@ServerInterceptor
@ClientInterceptor
public class GZIPDecodingInterceptor
implements MessageBodyReaderInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(MessageBodyReaderContext context) throws IOException, WebApplicationException {
        Object encoding = context.getHeaders().getFirst((Object)"Content-Encoding");
        if (encoding != null && encoding.toString().equalsIgnoreCase("gzip")) {
            InputStream old = context.getInputStream();
            context.setInputStream(new GZIPInputStream(old));
            try {
                Object object = context.proceed();
                return object;
            }
            finally {
                context.setInputStream(old);
            }
        }
        return context.proceed();
    }
}

