/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors.encoding;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.interception.AcceptedByMethod;
import org.jboss.resteasy.core.interception.MessageBodyWriterContext;
import org.jboss.resteasy.core.interception.ServerInterceptor;
import org.jboss.resteasy.plugins.interceptors.encoding.ContentEncodingHeaderInterceptor;
import org.jboss.resteasy.spi.HttpRequest;

@ServerInterceptor
@Provider
public class ServerContentEncodingHeaderInterceptor
extends ContentEncodingHeaderInterceptor
implements AcceptedByMethod {
    @Context
    protected HttpRequest request;

    public boolean accept(Class declaring, Method method) {
        return this.hasEncodingAnnotation(method.getAnnotations()) || this.hasEncodingAnnotation(declaring.getClass().getAnnotations());
    }

    public void write(MessageBodyWriterContext context) throws IOException, WebApplicationException {
        List acceptEncoding = (List)this.request.getHttpHeaders().getRequestHeaders().get((Object)"Accept-Encoding");
        if (acceptEncoding != null) {
            for (String accept : acceptEncoding) {
                if (!accept.contains(this.encoding)) continue;
                super.write(context);
                return;
            }
        }
        context.proceed();
    }
}

