/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.interceptors.SecurityInterceptor;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GetRestful;
import org.scannotation.AnnotationDB;
import org.scannotation.WarUrlFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResteasyBootstrap
implements ServletContextListener {
    private ResteasyProviderFactory factory = new ResteasyProviderFactory();
    private Registry registry;
    private Dispatcher dispatcher;
    private static final Logger logger = LoggerFactory.getLogger(ResteasyBootstrap.class);

    public void contextInitialized(ServletContextEvent event) {
        String languageExtensions;
        String mimeExtentions;
        String resources;
        String jndiResources;
        String sResources;
        String scanAll;
        String builtin;
        String resourceMethodInterceptors;
        String deploymentSensitive = event.getServletContext().getInitParameter("resteasy.use.deployment.sensitive.factory");
        if (deploymentSensitive == null || Boolean.valueOf(deploymentSensitive.trim()).booleanValue()) {
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (!(defaultInstance instanceof ThreadLocalResteasyProviderFactory)) {
                ResteasyProviderFactory.setInstance(new ThreadLocalResteasyProviderFactory(defaultInstance));
            }
        } else {
            ResteasyProviderFactory.setInstance(this.factory);
        }
        event.getServletContext().setAttribute(ResteasyProviderFactory.class.getName(), (Object)this.factory);
        String async = event.getServletContext().getInitParameter("resteasy.async.job.service.enabled");
        if (async != null && Boolean.valueOf(async.trim()).booleanValue()) {
            String basePath;
            String threadPool;
            String maxWaitStr;
            AsynchronousDispatcher asyncDispatcher = new AsynchronousDispatcher(this.factory);
            String maxJobResults = event.getServletContext().getInitParameter("resteasy.async.job.service.max.job.results");
            if (maxJobResults != null) {
                int maxJobs = Integer.valueOf(maxJobResults);
                asyncDispatcher.setMaxCacheSize(maxJobs);
            }
            if ((maxWaitStr = event.getServletContext().getInitParameter("resteasy.async.job.service.max.wait")) != null) {
                long maxWait = Long.valueOf(maxWaitStr);
                asyncDispatcher.setMaxWaitMilliSeconds(maxWait);
            }
            if ((threadPool = event.getServletContext().getInitParameter("resteasy.async.job.service.thread.pool.size")) != null) {
                int threadPoolSize = Integer.valueOf(threadPool);
                asyncDispatcher.setThreadPoolSize(threadPoolSize);
            }
            if ((basePath = event.getServletContext().getInitParameter("resteasy.async.job.service.base.path")) != null) {
                asyncDispatcher.setBasePath(basePath);
            }
            this.dispatcher = asyncDispatcher;
            asyncDispatcher.start();
        } else {
            this.dispatcher = new SynchronousDispatcher(this.factory);
        }
        this.registry = this.dispatcher.getRegistry();
        event.getServletContext().setAttribute(Dispatcher.class.getName(), (Object)this.dispatcher);
        event.getServletContext().setAttribute(Registry.class.getName(), (Object)this.registry);
        String applicationConfig = event.getServletContext().getInitParameter(Application.class.getName());
        if (applicationConfig == null) {
            applicationConfig = event.getServletContext().getInitParameter("javax.ws.rs.Application");
        } else {
            logger.warn("The use of " + Application.class.getName() + " is deprecated, please use javax.ws.rs.Application as a context-param instead");
        }
        String providers = event.getServletContext().getInitParameter("resteasy.providers");
        if (providers != null) {
            this.setProviders(providers);
        }
        if ((resourceMethodInterceptors = event.getServletContext().getInitParameter("resteasy.resource.method.interceptors")) != null) {
            throw new RuntimeException("resteasy.resource.method.interceptors is no longer a supported context param.  See documentation for more details");
        }
        String resteasySecurity = event.getServletContext().getInitParameter("resteasy.role.based.security");
        if (resteasySecurity != null && Boolean.valueOf(resteasySecurity.trim()).booleanValue()) {
            this.factory.getServerPreProcessInterceptorRegistry().registerFirst(SecurityInterceptor.class);
        }
        if ((builtin = event.getServletContext().getInitParameter("resteasy.use.builtin.providers")) == null || Boolean.valueOf(builtin.trim()).booleanValue()) {
            RegisterBuiltin.register(this.factory);
        }
        boolean scanProviders = false;
        boolean scanResources = false;
        String sProviders = event.getServletContext().getInitParameter("resteasy.scan.providers");
        if (sProviders != null) {
            scanProviders = Boolean.valueOf(sProviders.trim());
        }
        if ((scanAll = event.getServletContext().getInitParameter("resteasy.scan")) != null) {
            boolean tmp = Boolean.valueOf(scanAll.trim());
            scanProviders = tmp || scanProviders;
            boolean bl = scanResources = tmp || scanResources;
        }
        if ((sResources = event.getServletContext().getInitParameter("resteasy.scan.resources")) != null) {
            scanResources = Boolean.valueOf(sResources.trim());
        }
        if (scanProviders || scanResources) {
            if (applicationConfig != null) {
                throw new RuntimeException("You cannot deploy a javax.ws.rs.core.Application and have scanning on as this may create errors");
            }
            URL[] urls = WarUrlFinder.findWebInfLibClasspaths((ServletContextEvent)event);
            URL url = WarUrlFinder.findWebInfClassesPath((ServletContextEvent)event);
            AnnotationDB db = new AnnotationDB();
            String[] ignoredPackages = new String[]{"org.jboss.resteasy.plugins", "org.jboss.resteasy.annotations", "org.jboss.resteasy.client", "org.jboss.resteasy.specimpl", "org.jboss.resteasy.core", "org.jboss.resteasy.spi", "org.jboss.resteasy.util", "org.jboss.resteasy.mock", "javax.ws.rs"};
            db.setIgnoredPackages(ignoredPackages);
            try {
                if (url != null) {
                    db.scanArchives(new URL[]{url});
                }
                db.scanArchives(urls);
                try {
                    db.crossReferenceImplementedInterfaces();
                    db.crossReferenceMetaAnnotations();
                }
                catch (AnnotationDB.CrossReferenceException ignored) {}
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to scan WEB-INF for JAX-RS annotations, you must manually register your classes/resources", e);
            }
            if (scanProviders) {
                this.processProviders(db);
            }
            if (scanResources) {
                this.processResources(db);
            }
        }
        if ((jndiResources = event.getServletContext().getInitParameter("resteasy.jndi.resources")) != null) {
            this.processJndiResources(jndiResources);
        }
        if ((resources = event.getServletContext().getInitParameter("resteasy.resources")) != null) {
            this.processResources(resources);
        }
        if ((mimeExtentions = event.getServletContext().getInitParameter("resteasy.media.type.mappings")) != null) {
            Map<String, String> map = this.parseMap(mimeExtentions);
            HashMap<String, MediaType> extMap = new HashMap<String, MediaType>();
            for (String ext : map.keySet()) {
                String value = map.get(ext);
                extMap.put(ext, MediaType.valueOf((String)value));
            }
            if (this.dispatcher.getMediaTypeMappings() != null) {
                this.dispatcher.getMediaTypeMappings().putAll(extMap);
            } else {
                this.dispatcher.setMediaTypeMappings(extMap);
            }
        }
        if ((languageExtensions = event.getServletContext().getInitParameter("resteasy.language.mappings")) != null) {
            Map<String, String> map = this.parseMap(languageExtensions);
            if (this.dispatcher.getLanguageMappings() != null) {
                this.dispatcher.getLanguageMappings().putAll(map);
            } else {
                this.dispatcher.setLanguageMappings(map);
            }
        }
        if (applicationConfig != null) {
            try {
                Class<?> configClass = Thread.currentThread().getContextClassLoader().loadClass(applicationConfig.trim());
                Application config = (Application)configClass.newInstance();
                ResteasyBootstrap.processApplication(config, this.registry, this.factory);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void processApplication(Application config, Registry registry, ResteasyProviderFactory factory) {
        logger.info("Deploying " + Application.class.getName() + ": " + config.getClass());
        if (config.getClasses() != null) {
            for (Class clazz : config.getClasses()) {
                if (clazz.isAnnotationPresent(Path.class)) {
                    logger.info("Adding class resource " + clazz.getName() + " from Application " + Application.class.getName());
                    registry.addPerRequestResource(clazz);
                    continue;
                }
                logger.info("Adding class @Provider " + clazz.getName() + " from Application " + Application.class.getName());
                factory.registerProvider(clazz);
            }
        }
        if (config.getSingletons() != null) {
            for (Object obj : config.getSingletons()) {
                if (obj.getClass().isAnnotationPresent(Path.class)) {
                    logger.info("Adding singleton resource " + obj.getClass().getName() + " from Application " + Application.class.getName());
                    registry.addSingletonResource(obj);
                    continue;
                }
                logger.info("Adding singleton @Provider " + obj.getClass().getName() + " from Application " + Application.class.getName());
                factory.registerProviderInstance(obj);
            }
        }
    }

    protected Map<String, String> parseMap(String map) {
        String[] entries;
        HashMap<String, String> parsed = new HashMap<String, String>();
        for (String entry : entries = map.trim().split(",")) {
            String[] split = entry.trim().split(":");
            parsed.put(split[0].trim(), split[1].trim());
        }
        return parsed;
    }

    protected void processJndiResources(String jndiResources) {
        String[] resources;
        for (String resource : resources = jndiResources.trim().split(",")) {
            logger.info("Adding jndi resource " + resource);
            this.registry.addJndiResource(resource.trim());
        }
    }

    protected void processResources(String list) {
        String[] resources;
        for (String resource : resources = list.trim().split(",")) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(resource.trim());
                logger.info("Adding listed resource class: " + resource);
                this.registry.addPerRequestResource(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void processProviders(AnnotationDB db) {
        Set classes = (Set)db.getAnnotationIndex().get(Provider.class.getName());
        if (classes == null) {
            return;
        }
        for (String clazz : classes) {
            logger.info("Adding scanned @Provider: " + clazz);
            this.registerProvider(clazz);
        }
    }

    private void registerProvider(String clazz) {
        Class<?> provider = null;
        try {
            provider = Thread.currentThread().getContextClassLoader().loadClass(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.factory.registerProvider(provider);
    }

    protected void processResources(AnnotationDB db) {
        HashSet classes = new HashSet();
        Set paths = (Set)db.getAnnotationIndex().get(Path.class.getName());
        if (paths != null) {
            classes.addAll(paths);
        }
        for (String clazz : classes) {
            logger.info("Adding scanned resource: " + clazz);
            this.processResource(clazz);
        }
    }

    protected void processResource(String clazz) {
        Class<?> resource = null;
        try {
            resource = Thread.currentThread().getContextClassLoader().loadClass(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (resource.isInterface()) {
            return;
        }
        if (!GetRestful.isRootResource(resource)) {
            return;
        }
        System.out.println("FOUND JAX-RS resource: " + clazz);
        this.registry.addPerRequestResource(resource);
    }

    protected void setProviders(String providers) {
        String[] p;
        for (String provider : p = providers.split(",")) {
            logger.info("Adding listed @Provider class " + provider);
            provider = provider.trim();
            this.registerProvider(provider);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
    }
}

