/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.core.ClientInvoker;
import org.jboss.resteasy.client.core.ClientInvokerInterceptorFactory;
import org.jboss.resteasy.client.core.ClientProxy;
import org.jboss.resteasy.client.core.executors.ApacheHttpClientExecutor;
import org.jboss.resteasy.client.core.marshallers.ResteasyClientProxy;
import org.jboss.resteasy.spi.ProviderFactoryDelegate;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.IsHttpMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyFactory {
    public static <T> T create(Class<T> clazz, String base) {
        return ProxyFactory.create(clazz, base, new HttpClient());
    }

    @Deprecated
    public static <T> T create(Class<T> clazz, String base, HttpClient client) {
        return ProxyFactory.create(clazz, ProxyFactory.createUri(base), client, ResteasyProviderFactory.getInstance());
    }

    public static <T> T create(Class<T> clazz, String base, ClientExecutor client) {
        return ProxyFactory.create(clazz, ProxyFactory.createUri(base), client, ResteasyProviderFactory.getInstance());
    }

    public static URI createUri(String base) {
        try {
            return new URI(base);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static <T> T create(Class<T> clazz, URI baseUri, HttpClient httpClient, ResteasyProviderFactory providerFactory) {
        return ProxyFactory.create(clazz, baseUri, new ApacheHttpClientExecutor(httpClient), providerFactory);
    }

    public static <T> T create(Class<T> clazz, URI baseUri, ClientExecutor executor, ResteasyProviderFactory providerFactory) {
        HashMap<Method, ClientInvoker> methodMap = new HashMap<Method, ClientInvoker>();
        if (providerFactory instanceof ProviderFactoryDelegate) {
            providerFactory = ((ProviderFactoryDelegate)((Object)providerFactory)).getDelegate();
        }
        for (Method method : clazz.getMethods()) {
            ClientInvoker invoker = null;
            Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
            if (httpMethods == null || httpMethods.size() != 1) {
                throw new RuntimeException("You must use at least one, but no more than one http method annotation on: " + method.toString());
            }
            invoker = new ClientInvoker(baseUri, clazz, method, providerFactory, executor);
            ClientInvokerInterceptorFactory.applyDefaultInterceptors(invoker, providerFactory, clazz, method);
            invoker.setHttpMethod(httpMethods.iterator().next());
            methodMap.put(method, invoker);
        }
        Class[] intfs = new Class[]{clazz, ResteasyClientProxy.class};
        ClientProxy clientProxy = new ClientProxy(methodMap);
        clientProxy.setClazz(clazz);
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), intfs, (InvocationHandler)clientProxy);
    }
}

