/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.delegates;

import javax.ws.rs.core.NewCookie;
import javax.ws.rs.ext.RuntimeDelegate;

public class NewCookieHeaderDelegate
implements RuntimeDelegate.HeaderDelegate {
    public Object fromString(String newCookie) throws IllegalArgumentException {
        String[] parts;
        if (newCookie == null) {
            throw new IllegalArgumentException("NewCookie value is null");
        }
        String cookieName = null;
        String cookieValue = null;
        String comment = null;
        String domain = null;
        int maxAge = -1;
        String path = null;
        boolean secure = false;
        int version = 1;
        for (String part : parts = newCookie.split("[;,]")) {
            String value;
            String[] nv = part.split("=", 2);
            String name = nv.length > 0 ? nv[0].trim() : "";
            String string = value = nv.length > 1 ? nv[1].trim() : "";
            if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                value = value.substring(1, value.length() - 1);
            }
            if (name.equalsIgnoreCase("Comment")) {
                comment = value;
                continue;
            }
            if (name.equalsIgnoreCase("Domain")) {
                domain = value;
                continue;
            }
            if (name.equalsIgnoreCase("Max-Age")) {
                maxAge = Integer.parseInt(value);
                continue;
            }
            if (name.equalsIgnoreCase("Path")) {
                path = value;
                continue;
            }
            if (name.equalsIgnoreCase("Secure")) {
                secure = true;
                continue;
            }
            if (name.equalsIgnoreCase("Version")) {
                version = Integer.parseInt(value);
                continue;
            }
            cookieName = name;
            cookieValue = value;
        }
        return new NewCookie(cookieName, cookieValue, path, domain, version, comment, maxAge, secure);
    }

    protected void quote(StringBuilder b, String value) {
        if (value.indexOf(32) > -1) {
            b.append('\"');
            b.append(value);
            b.append('\"');
        } else {
            b.append(value);
        }
    }

    public String toString(Object value) {
        NewCookie cookie = (NewCookie)value;
        StringBuilder b = new StringBuilder();
        b.append(cookie.getName()).append('=');
        this.quote(b, cookie.getValue());
        b.append(";").append("Version=").append(cookie.getVersion());
        if (cookie.getComment() != null) {
            b.append(";Comment=");
            this.quote(b, cookie.getComment());
        }
        if (cookie.getDomain() != null) {
            b.append(";Domain=");
            this.quote(b, cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            b.append(";Path=");
            this.quote(b, cookie.getPath());
        }
        if (cookie.getMaxAge() != -1) {
            b.append(";Max-Age=");
            b.append(cookie.getMaxAge());
        }
        if (cookie.isSecure()) {
            b.append(";Secure");
        }
        return b.toString();
    }
}

