/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.validation;

import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintViolation;
import javax.ws.rs.WebApplicationException;
import org.jboss.resteasy.plugins.providers.validation.ViolationsContainer;

public class ResteasyViolationException
extends WebApplicationException {
    private static final long serialVersionUID = 2623733139912277260L;
    private ViolationsContainer container;
    private List<String> allExceptions;
    private List<String> fieldViolations = new ArrayList<String>();
    private List<String> propertyViolations = new ArrayList<String>();
    private List<String> classViolations = new ArrayList<String>();
    private List<String> parameterViolations = new ArrayList<String>();
    private List<String> returnValueViolations = new ArrayList<String>();
    private List<List<String>> allViolations;

    public ResteasyViolationException() {
        super(500);
    }

    public ResteasyViolationException(ViolationsContainer<?> container) {
        super(500);
        this.container = container;
    }

    public void setExceptions(List<String> exceptions) {
        this.allExceptions = exceptions;
    }

    public List<String> getExceptions() {
        if (this.allExceptions == null) {
            this.allExceptions = new ArrayList<String>();
            this.allExceptions.addAll(this.fieldViolations);
            this.allExceptions.addAll(this.propertyViolations);
            this.allExceptions.addAll(this.classViolations);
            this.allExceptions.addAll(this.parameterViolations);
            this.allExceptions.addAll(this.returnValueViolations);
        }
        return this.allExceptions;
    }

    public List<String> getFieldViolations() {
        if (this.size() == 0) {
            this.convertToStrings();
        }
        return this.fieldViolations;
    }

    public List<String> getPropertyViolations() {
        if (this.size() == 0) {
            this.convertToStrings();
        }
        return this.propertyViolations;
    }

    public List<String> getClassViolations() {
        if (this.size() == 0) {
            this.convertToStrings();
        }
        return this.classViolations;
    }

    public List<String> getParameterViolations() {
        if (this.size() == 0) {
            this.convertToStrings();
        }
        return this.parameterViolations;
    }

    public List<String> getReturnValueViolations() {
        if (this.size() == 0) {
            this.convertToStrings();
        }
        return this.returnValueViolations;
    }

    public int size() {
        return this.fieldViolations.size() + this.propertyViolations.size() + this.classViolations.size() + this.parameterViolations.size() + this.returnValueViolations.size();
    }

    public List<List<String>> getStrings() {
        if (this.size() == 0) {
            this.convertToStrings();
        }
        return this.allViolations;
    }

    protected ViolationsContainer getViolationsContainer() {
        return this.container;
    }

    protected void setViolationsContainer(ViolationsContainer container) {
        this.container = container;
    }

    protected void convertToStrings() {
        if (this.allViolations != null) {
            return;
        }
        this.allViolations = new ArrayList<List<String>>();
        for (ConstraintViolation cv : this.container.getFieldViolations()) {
            this.fieldViolations.add("field " + cv.getPropertyPath() + ": " + cv.getMessage() + ": " + cv.getInvalidValue().toString());
        }
        for (ConstraintViolation cv : this.container.getPropertyViolations()) {
            this.propertyViolations.add("property " + cv.getPropertyPath() + ": " + cv.getMessage() + ": " + cv.getInvalidValue().toString());
        }
        for (ConstraintViolation cv : this.container.getClassViolations()) {
            this.classViolations.add(cv.getMessage() + ": " + cv.getInvalidValue().toString());
        }
        for (ConstraintViolation cv : this.container.getParameterViolations()) {
            this.parameterViolations.add("parameter " + cv.getPropertyPath() + ": " + cv.getMessage() + ": " + cv.getInvalidValue().toString());
        }
        for (ConstraintViolation cv : this.container.getReturnValueViolations()) {
            this.returnValueViolations.add("return value: " + cv.getMessage() + ": " + cv.getInvalidValue().toString());
        }
        this.allViolations.add(this.fieldViolations);
        this.allViolations.add(this.propertyViolations);
        this.allViolations.add(this.classViolations);
        this.allViolations.add(this.parameterViolations);
        this.allViolations.add(this.returnValueViolations);
    }

    protected String expandDelimiter(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            sb.append(s.charAt(i));
            if (s.charAt(i) != ':') continue;
            sb.append(':');
        }
        return sb.toString();
    }

    protected String contractDelimiter(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            sb.append(s.charAt(i));
            if (s.charAt(i) != ':' || s.charAt(i + 1) != ':') continue;
            ++i;
        }
        return sb.toString();
    }
}

