/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.BeanParam;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.annotations.Form;
import org.jboss.resteasy.annotations.Suspend;
import org.jboss.resteasy.core.AsynchronousResponseInjector;
import org.jboss.resteasy.core.ConstructorInjectorImpl;
import org.jboss.resteasy.core.ContextParameterInjector;
import org.jboss.resteasy.core.CookieParamInjector;
import org.jboss.resteasy.core.FormInjector;
import org.jboss.resteasy.core.FormParamInjector;
import org.jboss.resteasy.core.HeaderParamInjector;
import org.jboss.resteasy.core.ListFormInjector;
import org.jboss.resteasy.core.MapFormInjector;
import org.jboss.resteasy.core.MatrixParamInjector;
import org.jboss.resteasy.core.MessageBodyParameterInjector;
import org.jboss.resteasy.core.MethodInjectorImpl;
import org.jboss.resteasy.core.PathParamInjector;
import org.jboss.resteasy.core.PrefixedFormInjector;
import org.jboss.resteasy.core.PropertyInjectorImpl;
import org.jboss.resteasy.core.QueryParamInjector;
import org.jboss.resteasy.core.SuspendInjector;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.FindAnnotation;
import org.jboss.resteasy.util.Types;

public class InjectorFactoryImpl
implements InjectorFactory {
    private ConcurrentHashMap<Class<?>, Class<?>> contextProxyCache = new ConcurrentHashMap();

    @Override
    public ConstructorInjector createConstructor(Constructor constructor, ResteasyProviderFactory providerFactory) {
        return new ConstructorInjectorImpl(constructor, providerFactory);
    }

    @Override
    public PropertyInjector createPropertyInjector(Class resourceClass, ResteasyProviderFactory providerFactory) {
        return new PropertyInjectorImpl(resourceClass, providerFactory);
    }

    @Override
    public MethodInjector createMethodInjector(Class root, Method method, ResteasyProviderFactory providerFactory) {
        return new MethodInjectorImpl(root, method, providerFactory);
    }

    @Override
    public ValueInjector createParameterExtractor(Class injectTargetClass, AccessibleObject injectTarget, Class type, Type genericType, Annotation[] annotations, ResteasyProviderFactory providerFactory) {
        return this.createParameterExtractor(injectTargetClass, injectTarget, type, genericType, annotations, true, providerFactory);
    }

    @Override
    public ValueInjector createParameterExtractor(Class injectTargetClass, AccessibleObject injectTarget, Class type, Type genericType, Annotation[] annotations, boolean useDefault, ResteasyProviderFactory providerFactory) {
        QueryParam query;
        DefaultValue defaultValue = FindAnnotation.findAnnotation(annotations, DefaultValue.class);
        boolean encode = FindAnnotation.findAnnotation(annotations, Encoded.class) != null || injectTarget.isAnnotationPresent(Encoded.class) || type.isAnnotationPresent(Encoded.class);
        String defaultVal = null;
        if (defaultValue != null) {
            defaultVal = defaultValue.value();
        }
        if ((query = FindAnnotation.findAnnotation(annotations, QueryParam.class)) != null) {
            return new QueryParamInjector(type, genericType, injectTarget, query.value(), defaultVal, encode, annotations, providerFactory);
        }
        HeaderParam header = FindAnnotation.findAnnotation(annotations, HeaderParam.class);
        if (header != null) {
            return new HeaderParamInjector(type, genericType, injectTarget, header.value(), defaultVal, annotations, providerFactory);
        }
        FormParam formParam = FindAnnotation.findAnnotation(annotations, FormParam.class);
        if (formParam != null) {
            return new FormParamInjector(type, genericType, injectTarget, formParam.value(), defaultVal, encode, annotations, providerFactory);
        }
        CookieParam cookie = FindAnnotation.findAnnotation(annotations, CookieParam.class);
        if (cookie != null) {
            return new CookieParamInjector(type, genericType, injectTarget, cookie.value(), defaultVal, annotations, providerFactory);
        }
        PathParam uriParam = FindAnnotation.findAnnotation(annotations, PathParam.class);
        if (uriParam != null) {
            return new PathParamInjector(type, genericType, injectTarget, uriParam.value(), defaultVal, encode, annotations, providerFactory);
        }
        Form form = FindAnnotation.findAnnotation(annotations, Form.class);
        if (form != null) {
            String prefix = form.prefix();
            if (prefix.length() > 0) {
                if (genericType instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)genericType;
                    if (Types.isA(List.class, pType)) {
                        return new ListFormInjector(type, Types.getArgumentType(pType, 0), prefix, providerFactory);
                    }
                    if (Types.isA(Map.class, pType)) {
                        return new MapFormInjector(type, Types.getArgumentType(pType, 0), Types.getArgumentType(pType, 1), prefix, providerFactory);
                    }
                }
                return new PrefixedFormInjector(type, prefix, providerFactory);
            }
            return new FormInjector(type, providerFactory);
        }
        if (FindAnnotation.findAnnotation(annotations, BeanParam.class) != null) {
            return new FormInjector(type, providerFactory);
        }
        MatrixParam matrix = FindAnnotation.findAnnotation(annotations, MatrixParam.class);
        if (matrix != null) {
            return new MatrixParamInjector(type, genericType, injectTarget, matrix.value(), defaultVal, encode, annotations, providerFactory);
        }
        Suspend suspend = FindAnnotation.findAnnotation(annotations, Suspend.class);
        if (suspend != null) {
            return new SuspendInjector(suspend, type);
        }
        if (FindAnnotation.findAnnotation(annotations, Context.class) != null) {
            Class<?> proxy = null;
            if (type.isInterface() && (proxy = this.contextProxyCache.get(type)) == null) {
                proxy = Proxy.getProxyClass(type.getClassLoader(), type);
                this.contextProxyCache.putIfAbsent(type, proxy);
            }
            return new ContextParameterInjector(proxy, type, providerFactory);
        }
        Suspended suspended = FindAnnotation.findAnnotation(annotations, Suspended.class);
        if (suspended != null) {
            return new AsynchronousResponseInjector(suspended);
        }
        if (AsyncResponse.class.isAssignableFrom(type)) {
            return new AsynchronousResponseInjector(suspended);
        }
        if (useDefault) {
            return new MessageBodyParameterInjector(injectTargetClass, injectTarget, type, genericType, annotations, providerFactory);
        }
        return null;
    }
}

