/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.WriterInterceptor;
import org.jboss.resteasy.core.MessageBodyParameterInjector;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.core.interception.JaxrsInterceptorRegistry;
import org.jboss.resteasy.core.interception.JaxrsInterceptorRegistryListener;
import org.jboss.resteasy.core.interception.PostMatchContainerRequestContext;
import org.jboss.resteasy.plugins.providers.validation.ResteasyViolationExceptionExtension;
import org.jboss.resteasy.plugins.providers.validation.ViolationsContainer;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.spi.validation.GeneralValidator;
import org.jboss.resteasy.util.FeatureContextDelegate;
import org.jboss.resteasy.util.Types;
import org.jboss.resteasy.util.WeightedMediaType;

public class ResourceMethod
implements ResourceInvoker,
JaxrsInterceptorRegistryListener {
    protected MediaType[] produces;
    protected MediaType[] consumes;
    protected Consumes methodConsumes;
    protected List<WeightedMediaType> preferredProduces = new ArrayList<WeightedMediaType>();
    protected List<WeightedMediaType> preferredConsumes = new ArrayList<WeightedMediaType>();
    protected Set<String> httpMethods;
    protected MethodInjector methodInjector;
    protected InjectorFactory injector;
    protected ResourceFactory resource;
    protected ResteasyProviderFactory parentProviderFactory;
    protected ResteasyProviderFactory resourceMethodProviderFactory;
    protected Method method;
    protected Class<?> resourceClass;
    protected ContainerRequestFilter[] requestFilters;
    protected ContainerResponseFilter[] responseFilters;
    protected WriterInterceptor[] writerInterceptors;
    protected ConcurrentHashMap<String, AtomicLong> stats = new ConcurrentHashMap();
    protected Type genericReturnType;
    protected GeneralValidator validator;
    protected ViolationsContainer<?> violationsContainer;
    protected ResourceInfo resourceInfo;

    public ResourceMethod(Class<?> clazz, Method method, InjectorFactory injector, ResourceFactory resource, ResteasyProviderFactory providerFactory, Set<String> httpMethods) {
        int i;
        Consumes c;
        this.injector = injector;
        this.resource = resource;
        this.parentProviderFactory = providerFactory;
        this.httpMethods = httpMethods;
        this.resourceClass = clazz;
        this.method = method;
        this.resourceInfo = new ResourceInfo(){

            public Method getResourceMethod() {
                return ResourceMethod.this.method;
            }

            public Class<?> getResourceClass() {
                return ResourceMethod.this.resourceClass;
            }
        };
        this.resourceMethodProviderFactory = new ResteasyProviderFactory(providerFactory);
        for (DynamicFeature feature : providerFactory.getServerDynamicFeatures()) {
            feature.configure(this.resourceInfo, (FeatureContext)new FeatureContextDelegate(this.resourceMethodProviderFactory));
        }
        this.methodInjector = injector.createMethodInjector(clazz, method, this.resourceMethodProviderFactory);
        Produces p = method.getAnnotation(Produces.class);
        if (p == null) {
            p = clazz.getAnnotation(Produces.class);
        }
        if (p == null) {
            p = method.getDeclaringClass().getAnnotation(Produces.class);
        }
        if ((c = (this.methodConsumes = method.getAnnotation(Consumes.class))) == null) {
            c = clazz.getAnnotation(Consumes.class);
        }
        if (c == null) {
            c = method.getDeclaringClass().getAnnotation(Consumes.class);
        }
        if (p != null) {
            this.produces = new MediaType[p.value().length];
            i = 0;
            for (String mediaType : p.value()) {
                this.produces[i++] = MediaType.valueOf((String)mediaType);
                this.preferredProduces.add(WeightedMediaType.valueOf(mediaType));
            }
        }
        if (c != null) {
            this.consumes = new MediaType[c.value().length];
            i = 0;
            for (String mediaType : c.value()) {
                this.consumes[i++] = MediaType.valueOf((String)mediaType);
                this.preferredConsumes.add(WeightedMediaType.valueOf(mediaType));
            }
        }
        Collections.sort(this.preferredProduces);
        Collections.sort(this.preferredConsumes);
        this.requestFilters = this.resourceMethodProviderFactory.getContainerRequestFilterRegistry().postMatch(this.resourceClass, method);
        this.responseFilters = (ContainerResponseFilter[])this.resourceMethodProviderFactory.getContainerResponseFilterRegistry().postMatch(this.resourceClass, method);
        this.writerInterceptors = (WriterInterceptor[])this.resourceMethodProviderFactory.getServerWriterInterceptorRegistry().postMatch(this.resourceClass, method);
        providerFactory.getContainerRequestFilterRegistry().getListeners().add(this);
        providerFactory.getContainerResponseFilterRegistry().getListeners().add(this);
        providerFactory.getServerWriterInterceptorRegistry().getListeners().add(this);
        this.genericReturnType = Types.getGenericReturnTypeOfGenericInterfaceMethod(clazz, method);
        ContextResolver<GeneralValidator> resolver = providerFactory.getContextResolver(GeneralValidator.class, MediaType.WILDCARD_TYPE);
        if (resolver != null) {
            this.validator = (GeneralValidator)providerFactory.getContextResolver(GeneralValidator.class, MediaType.WILDCARD_TYPE).getContext(null);
        }
    }

    public void cleanup() {
        this.parentProviderFactory.getContainerRequestFilterRegistry().getListeners().remove(this);
        this.parentProviderFactory.getContainerResponseFilterRegistry().getListeners().remove(this);
        this.parentProviderFactory.getServerWriterInterceptorRegistry().getListeners().remove(this);
        for (ValueInjector param : this.methodInjector.getParams()) {
            if (!(param instanceof MessageBodyParameterInjector)) continue;
            this.parentProviderFactory.getServerReaderInterceptorRegistry().getListeners().remove(param);
        }
    }

    @Override
    public void registryUpdated(JaxrsInterceptorRegistry registry) {
        this.resourceMethodProviderFactory = new ResteasyProviderFactory(this.parentProviderFactory);
        for (DynamicFeature feature : this.parentProviderFactory.getServerDynamicFeatures()) {
            feature.configure(this.resourceInfo, (FeatureContext)new FeatureContextDelegate(this.resourceMethodProviderFactory));
        }
        if (registry.getIntf().equals(WriterInterceptor.class)) {
            this.writerInterceptors = (WriterInterceptor[])this.resourceMethodProviderFactory.getServerWriterInterceptorRegistry().postMatch(this.resourceClass, this.method);
        } else if (registry.getIntf().equals(ContainerRequestFilter.class)) {
            this.requestFilters = this.resourceMethodProviderFactory.getContainerRequestFilterRegistry().postMatch(this.resourceClass, this.method);
        } else if (registry.getIntf().equals(ContainerResponseFilter.class)) {
            this.responseFilters = (ContainerResponseFilter[])this.resourceMethodProviderFactory.getContainerResponseFilterRegistry().postMatch(this.resourceClass, this.method);
        }
    }

    protected void incrementMethodCount(String httpMethod) {
        AtomicLong old;
        AtomicLong stat = this.stats.get(httpMethod);
        if (stat == null && (old = this.stats.putIfAbsent(httpMethod, stat = new AtomicLong())) != null) {
            stat = old;
        }
        stat.incrementAndGet();
    }

    public Map<String, AtomicLong> getStats() {
        return this.stats;
    }

    public ContainerRequestFilter[] getRequestFilters() {
        return this.requestFilters;
    }

    public ContainerResponseFilter[] getResponseFilters() {
        return this.responseFilters;
    }

    public WriterInterceptor[] getWriterInterceptors() {
        return this.writerInterceptors;
    }

    public Type getGenericReturnType() {
        return this.genericReturnType;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public Annotation[] getMethodAnnotations() {
        return this.method.getAnnotations();
    }

    public List<WeightedMediaType> getPreferredProduces() {
        return this.preferredProduces;
    }

    public List<WeightedMediaType> getPreferredConsumes() {
        return this.preferredConsumes;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public BuiltResponse invoke(HttpRequest request, HttpResponse response) {
        Object target = this.resource.createResource(request, response, this.resourceMethodProviderFactory);
        return this.invoke(request, response, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuiltResponse invoke(HttpRequest request, HttpResponse response, Object target) {
        request.setAttribute(ResourceMethod.class.getName(), this);
        this.incrementMethodCount(request.getHttpMethod());
        ResteasyUriInfo uriInfo = request.getUri();
        uriInfo.pushCurrentResource(target);
        try {
            Object type;
            BuiltResponse jaxrsResponse = this.invokeOnTarget(request, response, target);
            if (jaxrsResponse != null && jaxrsResponse.getEntity() != null && (type = jaxrsResponse.getMetadata().getFirst((Object)"Content-Type")) == null) {
                jaxrsResponse.getMetadata().putSingle((Object)"Content-Type", (Object)this.resolveContentType(request, jaxrsResponse.getEntity()));
            }
            BuiltResponse builtResponse = jaxrsResponse;
            return builtResponse;
        }
        finally {
            uriInfo.popCurrentResource();
        }
    }

    protected BuiltResponse invokeOnTarget(HttpRequest request, HttpResponse response, Object target) {
        if (this.validator != null) {
            this.violationsContainer = new ViolationsContainer(this.validator.validate(target, new Class[0]));
            request.setAttribute(ViolationsContainer.class.getName(), this.violationsContainer);
            request.setAttribute(GeneralValidator.class.getName(), this.validator);
        }
        PostMatchContainerRequestContext requestContext = new PostMatchContainerRequestContext(request, this);
        for (ContainerRequestFilter filter : this.requestFilters) {
            try {
                filter.filter((ContainerRequestContext)requestContext);
            }
            catch (IOException e) {
                throw new ApplicationException(e);
            }
            BuiltResponse serverResponse = (BuiltResponse)requestContext.getResponseAbortedWith();
            if (serverResponse == null) continue;
            return serverResponse;
        }
        Object rtn = this.methodInjector.invoke(request, response, target);
        if (this.violationsContainer != null && this.violationsContainer.size() > 0) {
            throw new ResteasyViolationExceptionExtension(this.violationsContainer);
        }
        if (request.getAsyncContext().isSuspended()) {
            request.getAsyncContext().getAsyncResponse().setAnnotations(this.method.getAnnotations());
            request.getAsyncContext().getAsyncResponse().setWriterInterceptors(this.writerInterceptors);
            request.getAsyncContext().getAsyncResponse().setResponseFilters(this.responseFilters);
            request.getAsyncContext().getAsyncResponse().setMethod(this);
            return null;
        }
        if (rtn == null || this.method.getReturnType().equals(Void.TYPE)) {
            BuiltResponse build = (BuiltResponse)Response.noContent().build();
            build.setAnnotations(this.method.getAnnotations());
            return build;
        }
        if (Response.class.isAssignableFrom(this.method.getReturnType()) || rtn instanceof Response) {
            BuiltResponse rtn1 = (BuiltResponse)((Object)rtn);
            rtn1.setAnnotations(this.method.getAnnotations());
            return rtn1;
        }
        Response.ResponseBuilder builder = Response.ok((Object)rtn);
        builder.type(this.resolveContentType(request, rtn));
        BuiltResponse jaxrsResponse = (BuiltResponse)builder.build();
        jaxrsResponse.setGenericType(this.genericReturnType);
        jaxrsResponse.setAnnotations(this.method.getAnnotations());
        return jaxrsResponse;
    }

    public boolean doesProduce(List<? extends MediaType> accepts) {
        if (accepts == null || accepts.size() == 0) {
            return true;
        }
        if (this.produces == null || this.produces.length == 0) {
            return true;
        }
        for (MediaType mediaType : accepts) {
            for (MediaType mediaType2 : this.preferredProduces) {
                if (!mediaType2.isCompatible(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean doesConsume(MediaType contentType) {
        boolean matches = false;
        if (contentType == null) {
            if (this.methodConsumes == null) {
                return true;
            }
            for (MediaType mediaType : this.preferredConsumes) {
                if (!mediaType.equals((Object)MediaType.WILDCARD_TYPE)) continue;
                return true;
            }
            return false;
        }
        if (this.consumes == null || this.consumes.length == 0) {
            matches = true;
        } else {
            for (MediaType mediaType : this.preferredConsumes) {
                if (!mediaType.isCompatible(contentType)) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    public MediaType resolveContentType(HttpRequest in, Object entity) {
        MediaType chosen = (MediaType)in.getAttribute("RESTEASY_CHOSEN_ACCEPT");
        if (chosen != null && !chosen.equals((Object)MediaType.WILDCARD_TYPE)) {
            return chosen;
        }
        List accepts = in.getHttpHeaders().getAcceptableMediaTypes();
        if (accepts == null || accepts.size() == 0) {
            if (this.produces == null) {
                return MediaType.WILDCARD_TYPE;
            }
            return this.produces[0];
        }
        if (this.produces == null || this.produces.length == 0) {
            return this.resolveContentTypeByAccept(accepts, entity);
        }
        for (MediaType accept : accepts) {
            for (MediaType type : this.produces) {
                if (!type.isCompatible(accept)) continue;
                return type;
            }
        }
        return MediaType.WILDCARD_TYPE;
    }

    protected MediaType resolveContentTypeByAccept(List<MediaType> accepts, Object entity) {
        if (accepts == null || accepts.size() == 0 || entity == null) {
            return MediaType.WILDCARD_TYPE;
        }
        Class clazz = entity.getClass();
        Type type = this.genericReturnType;
        if (entity instanceof GenericEntity) {
            GenericEntity gen = (GenericEntity)entity;
            clazz = gen.getRawType();
            type = gen.getType();
        }
        for (MediaType accept : accepts) {
            if (this.resourceMethodProviderFactory.getMessageBodyWriter(clazz, type, this.method.getAnnotations(), accept) == null) continue;
            return accept;
        }
        return MediaType.WILDCARD_TYPE;
    }

    public Set<String> getHttpMethods() {
        return this.httpMethods;
    }

    public MediaType[] getProduces() {
        return this.produces;
    }

    public MediaType[] getConsumes() {
        return this.consumes;
    }
}

